<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		          |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com (C) 2005              |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";

if (get_magic_quotes_gpc()) {
	$_POST = array_map('stripslashes_deep', $_POST);
	$_GET = array_map('stripslashes_deep', $_GET);
	$_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

if(isset( $_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"]!= ""){
	$adminname = $_SESSION["sess_adminname"];
}else{
	header("Location:login.php");
	exit;
}

$adminCurrency	= GetAdminCurrency();

$adminSymbol	= $adminCurrency['currency_symbol'];

/*
 * Orders
*/

$WhereCondition = "WHERE o.vpayment_status=:pstatus";
$whereArray['pstatus'] = "C";

$sql = "SELECT o.order_id,o.order_date,
CONCAT(o.billing_first_name, ' ' ,o.billing_last_name) as user_name,
od.product_discount,
(o.order_total_price+o.taxrate) as total
FROM ".$tableprefix."orders o
INNER JOIN ".$tableprefix."order_details od ON o.order_id = od.order_id
".$WhereCondition."    
GROUP BY o.order_id ORDER BY o.order_id DESC LIMIT 0,5";

$orderResult= $pdo->pdoQuery($sql,$whereArray)->results();


/*
 * Orders - End
*/

/*
 * Order Counts Start
*/
$totalOrders        = 0;
$pendingOrders      = 0;
$shippedOrders      = 0;
$deliveredOrders    = 0;

$WhereCondition = " WHERE o.vpayment_status=:pstatus AND (o.order_status =:od_status_a OR o.order_status =:od_status_b OR o.order_status =:od_status_c)";
$whereArray['pstatus'] = "C";
$whereArray['od_status_a'] = "1";
$whereArray['od_status_b'] = "3";
$whereArray['od_status_c'] = "4";

$sql = "SELECT o.order_id
FROM ".$tableprefix."orders o".$WhereCondition;

$query_result= $pdo->pdoQuery($sql,$whereArray)->results();

if(count($query_result) > 0){
	
	foreach($query_result as $row){
		
		if(getOrderStatus($row['order_id'])=="Pending") {
			$pendingOrders++;
		}
		if(getOrderStatus($row['order_id'])=="Delivered") {
			$deliveredOrders++;
		}
		if(getOrderStatus($row['order_id'])=="Shipped") {
			$shippedOrders++;
		}
		$totalOrders++;
	}
}

$pendingOrdersPerc   = 0;
$shippedOrdersPerc   = 0;
$deliveredOrdersPerc = 0;

if($pendingOrders > 0)
{
	$pendingOrdersPerc = round($pendingOrders * 100 / $totalOrders);
}

if($shippedOrders > 0)
{
	$shippedOrdersPerc = round($shippedOrders * 100 / $totalOrders);
}

if($deliveredOrders > 0)
{
	$deliveredOrdersPerc = round($deliveredOrders * 100 / $totalOrders);
}

//Today
$totalOrdersTodayCount = 0;



$sqlOrdCnt = "SELECT o.order_id FROM ".$tableprefix."orders o WHERE o.vpayment_status='C' AND o.order_date = DATE(NOW())";

$orderCntResult = $pdo->pdoQuery($sqlOrdCnt)->results();


if(count($orderCntResult) > 0)
{
	$ordCntRow = (object)($orderCntResult[0]);
	$totalOrdersTodayCount = count($orderCntResult);
}

//Week
$totalOrdersWeekCount = 0;
$sqlOrdCnt = "SELECT o.order_id
FROM ".$tableprefix."orders o
INNER JOIN ".$tableprefix."order_details od ON o.order_id = od.order_id
WHERE o.vpayment_status='C' AND YEARWEEK(o.order_date) = YEARWEEK(NOW())  GROUP BY o.order_id";


$orderCntResult = $pdo->pdoQuery($sqlOrdCnt)->results();
if(count($orderCntResult) > 0)
{
	$ordCntRow = (object)($orderCntResult[0]);
	$totalOrdersWeekCount = count($orderCntResult);
}

//Month
$totalOrdersMonthCount = 0;
$sqlOrdCnt = "SELECT o.order_id
FROM ".$tableprefix."orders o
INNER JOIN ".$tableprefix."order_details od ON o.order_id = od.order_id
WHERE o.vpayment_status='C' AND date_format(o.order_date,'%Y%m') = date_format(NOW(),'%Y%m')  GROUP BY o.order_id";


$orderCntResult = $pdo->pdoQuery($sqlOrdCnt)->results();
if(count($orderCntResult) > 0)
{
	$ordCntRow = (object)($orderCntResult[0]);
	$totalOrdersMonthCount = count($orderCntResult);
}

//Last Month
$totalOrdersLastMonthCount = 0;
$sqlOrdCnt = "SELECT o.order_id
FROM ".$tableprefix."orders o
INNER JOIN ".$tableprefix."order_details od ON o.order_id = od.order_id
AND date_format(o.order_date,'%Y%m') = date_format(NOW() - INTERVAL 1 MONTH, '%Y%m')   WHERE o.vpayment_status='C'   GROUP BY o.order_id";
$orderCntResult = $pdo->pdoQuery($sqlOrdCnt)->results();

if(count($orderCntResult) > 0)
{
	$ordCntRow = (object)($orderCntResult[0]);
	$totalOrdersLastMonthCount = count($orderCntResult);
}

if ( $totalOrdersLastMonthCount == 0 )
{
	$totalOrdersChangeCount = $totalOrdersMonthCount ;
}
else if ( $totalOrdersMonthCount == 0 )
{
	$totalOrdersChangeCount = '-'.$totalOrdersLastMonthCount ;
}
else
{
	$totalOrdersChangeCount = ( ( $totalOrdersMonthCount - $totalOrdersLastMonthCount )/ $totalOrdersLastMonthCount )*100 ;
}
//$totalOrdersChangeCount = number_format( $totalOrdersChangeCount,2,".","");



/*
 * Order Counts End
*/

//Amounts

$sellerAmountPending = 0;

$sql = "SELECT SUM(product_price - product_commission_amount) AS totalamount
FROM ".$tableprefix."order_details od
INNER JOIN ".$tableprefix."orders o ON o.order_id = od.order_id
AND o.vpayment_status != 'P'
AND od.item_status = 4";

$orderAmntResult = $pdo->pdoQuery($sql)->results();

if(count($orderAmntResult) > 0)
{
	$row = (object)($orderAmntResult[0]);
	$sellerAmountPending = $row->totalamount > 0 ? $row->totalamount : 0;
	
}


//Vendor Count

$approveSellers = 0;
$query = "SELECT COUNT(a.artist_id) as totalcount
FROM ".$tableprefix."artists a
WHERE a.vapproved != 'Y' AND a.deleted='N'";

$result = $pdo->pdoQuery($query)->results();
if(count($result) > 0)
{
	$row = (object)($result[0]);
	$approveSellers = $row->totalcount;
}


//Today
$totalVendorsTodayCount = 0;

$query = "SELECT COUNT(a.artist_id) as totalcount
FROM ".$tableprefix."artists a
WHERE a.date_registered = DATE(NOW())";
$result = $pdo->pdoQuery($query)->results();

if(count($result) > 0)
{
	$row = (object)($result[0]);
	$totalVendorsTodayCount = $row->totalcount;
}

//Today
$totalVendorsTodayCount = 0;

$result = $pdo->pdoQuery($query)->results();

if(count($result) > 0)
{
	$row = (object)($result[0]);
	$totalVendorsTodayCount = $row->totalcount;
}

//Week
$totalVendorsWeekCount = 0;
$query = "SELECT COUNT(a.artist_id) as totalcount
FROM ".$tableprefix."artists a
WHERE YEARWEEK(a.date_registered) = YEARWEEK(NOW())";

$result = $pdo->pdoQuery($query)->results();

if(count($result) > 0)
{
	$row = (object)($result[0]);
	$totalVendorsWeekCount = $row->totalcount;
}

//Month
$totalVendorsMonthCount = 0;
$query = "SELECT COUNT(a.artist_id) as totalcount
FROM ".$tableprefix."artists a
WHERE date_format(a.date_registered,'%Y%m') = date_format(NOW(),'%Y%m')";

$result = $pdo->pdoQuery($query)->results();
if(count($result) > 0)
{
	$row = (object)($result[0]);
	$totalVendorsMonthCount = $row->totalcount;
}


//Last Month
$totalVendorsLastMonthCount = 0;
$query = "SELECT COUNT(a.artist_id) as totalcount
FROM ".$tableprefix."artists a
WHERE date_format(a.date_registered,'%Y%m') = date_format(NOW() - INTERVAL 1 MONTH, '%Y%m')";

$result = $pdo->pdoQuery($query)->results();
if(count($result) > 0)
{
	$row = (object)($result[0]);
	$totalVendorsLastMonthCount = $row->totalcount;
}
//Change


$totalVendorsChangeCount = 0;
if ( $totalVendorsLastMonthCount == 0 )
{
	$totalVendorsChangeCount = $totalVendorsMonthCount ;
}
else if ( $totalVendorsMonthCount == 0 )
{
	$totalVendorsChangeCount = '-'.$totalVendorsLastMonthCount ;
}
else
{
	$totalVendorsChangeCount = ( ( $totalVendorsMonthCount - $totalVendorsLastMonthCount )/ $totalVendorsLastMonthCount )*100 ;
}
//Vendor Count - End

//Products Count

$baseQuery = "SELECT COUNT(p.product_id) as totalcount
FROM ".$tableprefix."products p WHERE ";

$query = $baseQuery . " p.date_added = DATE(NOW())";

//Today
$totalProductsTodayCount = 0;

$result = $pdo->pdoQuery($query)->results();
if(count($result) > 0)
{
	$row = (object)($result[0]);
	$totalProductsTodayCount = $row->totalcount;
}

//Week
$totalProductsWeekCount = 0;
$query = $baseQuery . " YEARWEEK(p.date_added) = YEARWEEK(NOW())";

$result = $pdo->pdoQuery($query)->results();
if(count($result) > 0)
{
	$row = (object)($result[0]);
	$totalProductsWeekCount = $row->totalcount;
}

//Month
$totalProductsMonthCount = 0;
$query = $baseQuery . " date_format(p.date_added,'%Y%m') = date_format(NOW(),'%Y%m')";

$result = $pdo->pdoQuery($query)->results();
if(count($result) > 0)
{
	$row = (object)($result[0]);
	$totalProductsMonthCount = $row->totalcount;
}


//Last Month
$totalProductsLastMonthCount = 0;
$query = $baseQuery . " date_format(p.date_added,'%Y%m') = date_format(NOW() - INTERVAL 1 MONTH, '%Y%m')";

$result = $pdo->pdoQuery($query)->results();
if(count($result) > 0)
{
	$row = (object)($result[0]);
	$totalProductsLastMonthCount = $row->totalcount;
}
//Change

$totalProductsChangeCount = 0;
if ( $totalProductsLastMonthCount == 0 )
{
	$totalProductsChangeCount = $totalProductsMonthCount ;
}
else if ( $totalProductsMonthCount == 0 )
{
	$totalProductsChangeCount = '-'.$totalProductsLastMonthCount ;
}
else
{
	$totalProductsChangeCount = ( ( $totalProductsMonthCount - $totalProductsLastMonthCount )/ $totalProductsLastMonthCount )*100 ;
}
//Products Count - End

//Commission
$commissionAmount = 0;
/*$sql = "SELECT sum((od.product_price-(od.product_price*od.product_discount/100) * a.commission/100) * od.product_quantity) as totalamount
 FROM ".$tableprefix."order_details od
INNER JOIN ".$tableprefix."orders o ON o.order_id = od.order_id
AND o.vpayment_status != 'P'
AND o.order_status = 4
INNER JOIN ".$tableprefix."artists a ON a.artist_id = od.artist_id
WHERE od.artist_payment_status = 1";*/

$sql = "SELECT SUM(product_commission_amount) AS adminCommission
FROM ".$tableprefix."order_details od
INNER JOIN ".$tableprefix."orders o ON o.order_id = od.order_id
AND o.vpayment_status != 'P'
AND od.item_status = 4";

$orderAmntResult = $pdo->pdoQuery($sql)->results();

if(count($orderAmntResult) > 0)
{
	$row = (object)($orderAmntResult);
	$commissionAmount = $row->adminCommission > 0 ? $row->adminCommission : 0;
	
}
//Commission End
$approveAffiliates = 0;
$query = "SELECT COUNT(a.affiliate_id) as totalcount
FROM ".$tableprefix."affiliates a
WHERE a.vapproved != 'Y' AND a.deleted='N'";

$result = $pdo->pdoQuery($query)->results();
if(count($result) > 0)
{
	$row = (object)($result[0]);
	$approveAffiliates = $row->totalcount;
}

$approveProducts = 0;
$query = "SELECT COUNT(p.product_id) as totalcount
FROM ".$tableprefix."products p
WHERE p.vapproved != 'Y'  AND p.deleted='N'";

$result = $pdo->pdoQuery($query)->results();
if(count($result) > 0)
{
	$row = (object)($result[0]);
	$approveProducts = $row->totalcount;
}

/***************/
$productCountSql = "SELECT COUNT(product_id) AS totalcount
FROM " . $tableprefix . "products p         
WHERE 
p.publish_status = 'N' AND product_category != 1";
$productCountResult = $pdo->pdoQuery($productCountSql)->results();
if (count($productCountResult) > 0) {
	$uppublishedRow = (object)($productCountResult[0]);
	$unPublishCount = $uppublishedRow->totalcount;
}
/***************/

$sql="select count(r.refund_id) as totalcount
from ".$tableprefix."refunds r
INNER JOIN ".$tableprefix."orders o
ON o.order_id=r.order_id
INNER JOIN ".$tableprefix."artists a ON a.artist_id=r.seller_id
where r.Status is NULL ";

$CountRefundResult = $pdo->pdoQuery($sql)->results();
if(count($CountRefundResult) > 0)
{
	$ordRow = (object)($CountRefundResult[0]);
	$refundCount = $ordRow->totalcount;
}

//Messages Count
$newMessages = 0;
$sql = "SELECT COUNT(message_to_seller_id) AS total
FROM ".$tableprefix."message_to_seller
WHERE `read` ='N'";

$orderAmntResult = $pdo->pdoQuery($sql)->results();

if(count($orderAmntResult) > 0)
{
	$row = (object)($orderAmntResult[0]);
	$newMessages = $row->total;
}
//Messages Count - End

//Seller Feedback Count
$sellerFeedbacks = 0;
$sql = "SELECT COUNT(af.artist_feedback_id) AS total
FROM ".$tableprefix."artist_feedbacks af
INNER JOIN ".$tableprefix."users u ON af.user_id = u.user_id
INNER JOIN ".$tableprefix."artists a ON af.artist_id = a.artist_id
WHERE af.published !='Y'";

$orderAmntResult = $pdo->pdoQuery($sql)->results();

if(count($orderAmntResult) > 0)
{
	$row = (object)($orderAmntResult[0]);
	$sellerFeedbacks = $row->total;
}
//Seller Feedback Count - End

//Site Feedback
$siteFeedbacks = false;
$sql = "SELECT CONCAT(first_name, ' ' ,last_name) AS name,feedback_content, date_added
FROM ".$tableprefix."feedbacks
ORDER BY feedback_id DESC
LIMIT 0,3";

$result = $pdo->pdoQuery($sql)->results();

if(count($result) > 0)
{
	$siteFeedbacks = $result;
}
//Seller Feedback Count - End
include "../includes/htmltop1.php";
?>
<script src="<?php echo $site_url; ?>/js/pie-chart.js"></script>
<script language="javascript" type="text/javascript">
	$(document).ready(function(){
		$(".jqPendingProgress").animate({width:'<?php echo $pendingOrdersPerc ?>%'}, 1500) ;
		$(".jqShippedProgress").animate({width:'<?php echo $shippedOrdersPerc ?>%'}, 1500) ;
		$(".jqDeliveredProgress").animate({width:'<?php echo $deliveredOrdersPerc ?>%'}, 1500) ;
		
	});
	
</script>
<body>
	<div class="main_outer">

		<!--header area start -->
		<?php
		include_once("../includes/topheader_admin1.php")
		?>
		<!--header area end -->
		<div class="contant_area">
			<!--main body start -->
			<?php
			include_once("../includes/admintopmenu1.php");
			?>
			
			<div class="right_main_cont_outer">
				<div class="right_main_cont_inner">
					<!-- right_main_cont_inner START -->
					
					<h1><?php echo ADMIN_PANEL;?></h1>
					
					<div class="row">
						<div class="col-xs-12 col-sm-12 col-md-7">
							<h2><?php echo ORDER_STATUS;?></h2>
							<div class="order_status_outer">
								
								<div class="row">
									<div class="col-xs-12 col-sm-4">
										<div class="dashboard_graph_outer delivered_txt_outer">
											<i class="fa fa-check" aria-hidden="true"></i>
											<div class="clearfix"></div>
											<?php echo DELIVERED;?>
										</div>
									</div>
									<div class="col-xs-12 col-sm-4">
										<div class="dashboard_graph_outer shipped_txt_outer">
											<i class="fa fa-truck" aria-hidden="true"></i>
											<div class="clearfix"></div>
											<?php echo SHIPPED;?>
										</div>
									</div>
									<div class="col-xs-12 col-sm-4">
										<div class="dashboard_graph_outer pendind_txt_outer">
											<i class="fa fa-spinner" aria-hidden="true"></i>
											<div class="clearfix"></div>
											<?php echo PENDING;?>
										</div>
									</div>
								</div>
								
								<div class="statusshipp_div">
									<div class="progress_ship">
										<div class="statustxt">
											<span><?php echo $deliveredOrdersPerc ?>%</span>
										</div>
										<div class="gree_progress jqDeliveredProgress" style="width:<?php echo 0 ?>%"></div>
										<div class="clear"></div>
									</div>
									
									<div class="progress_ship">
										<div class="statustxt">
											<span><?php echo $shippedOrdersPerc ?>%</span>
										</div>
										<div class="blue_progress jqShippedProgress" style="width:<?php echo 0 ?>%"></div>
										<div class="clear"></div>
									</div>
									
									<div class="progress_ship">
										<div class="statustxt">
											<span><?php echo $pendingOrdersPerc ?>%</span>
										</div>
										<div class="red_progress jqPendingProgress" style="width:<?php echo 0 ?>%"></div>
										<div class="clear"></div>
									</div>
									
									<div class="clear"></div>
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-12 col-md-5">
							<h2><?php echo TOTAL_SALES;?></h2>
							<div class="clearfix"></div>
							<div class="total_sale_outer">
								<?php include 'graph_sales.php'; ?>
							</div>
						</div>
					</div>
					
					<div class="clearfix">&nbsp;</div>
					<div class="row">
						<div class="col-xs-12">
							<div class="dashboard_bottom_icons_outer">
								<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 dashboard_bottom_icons_inner">
									<a href="sellers.php?rghtMenu=rghtMenu6">
										<i class="fa fa-user-o" aria-hidden="true"></i>
										<span class="txt"><?php echo APPROVE_SELLERS;?></span>
										<span class="count"><?php echo $approveSellers;?></span>
									</a>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 dashboard_bottom_icons_inner">
									<a href="product_approve.php?rghtMenu=rghtMenu6">
										<i class="fa fa-archive" aria-hidden="true"></i>
										<span class="txt"><?php echo APPROVE_PRODUCTS;?></span>
										<span class="count"><?php echo $approveProducts;?></span>
									</a>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 dashboard_bottom_icons_inner">
									<a href="listProducts.php?rghtMenu=rghtMenu5&displayDiv=Product Management">
										<i class="fa fa-globe" aria-hidden="true"></i>
										<span class="txt"><?php echo PUBLISH_PRODUCTS;?></span>
										<span class="count"><?php echo $unPublishCount;?></span>
									</a>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 dashboard_bottom_icons_inner">
									<a href="affiliates_approval.php?rghtMenu=rghtMenu6htMenu5">
										<i class="fa fa-users" aria-hidden="true"></i>
										<span class="txt"><?php echo APPROVE_AFFILIATES;?></span>
										<span class="count"><?php echo $approveAffiliates;?></span>
									</a>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 dashboard_bottom_icons_inner">
									<a href="artistfeedbacks.php?rghtMenu=rghtMenu10">
										<i class="fa fa-comments-o" aria-hidden="true"></i>
										<span class="txt"><?php echo SELLER_FEEDBACK;?></span>
										<span class="count"><?php echo $sellerFeedbacks;?></span>
									</a>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 dashboard_bottom_icons_inner">
									<a href="refunds_requests.php">
										<i class="fa fa-thumbs-o-up" aria-hidden="true"></i>
										<span class="txt"><?php echo RMAS_TO_BE_APPROVED;?></span>
										<span class="count"><?php echo $refundCount;?></span>
									</a>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 dashboard_bottom_icons_inner">
									<a href="messages.php">
										<i class="fa fa-envelope-o" aria-hidden="true"></i>
										<span class="txt"><?php echo EMAIL_FROM_USERS;?></span>
										<span class="count"><?php echo $newMessages;?></span>													
									</a>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 dashboard_bottom_icons_inner">
									<a href="orders.php">
										<i class="fa fa-list-alt" aria-hidden="true"></i>
										<span class="txt"><?php echo ORDERS_TO_BE_SHIPPED;?></span>
										<span class="count"><?php echo $pendingOrders; ?></span>
									</a>
								</div>
								<div class="clearfix"></div>
							</div>
						</div>
						
					</div>	
					<div class="clearfix">&nbsp;</div>										
					<div class="row">
						<div class="col-xs-12">
							<h2>
								<?php echo RECENT_ORDERS;?>
								<span class="view_orders_txt"><a href="orders.php"><?php echo VIEW_ALL_ORDERS;?></a></span>
							</h2>
							<div class="clearfix"></div>
							<div class="table-responsive">
								<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table admin_table">
									<tr>
										<th valign="top" align="left"><?php echo ORDER_ID;?></th>
										<th valign="top" align="left"><?php echo USER_NAME;?></th>
										<th valign="top" align="left"><?php echo ORDER_STATUS;?></th>
										<th valign="top" align="left"><?php echo DATE_ADDED;?></th>
										<th valign="top" align="left"><?php echo ORDER_TOTAL;?></th>
										<th width="5%" valign="top" align="left">&nbsp;</th>
									</tr>
									<?php if(count($orderResult) > 0){ ?>
									
									<?php foreach($orderResult as $ordRow){ 
										
										$orderTotal=$ordRow["total"];												
										$link = 'vieworder.php?orderid='.$ordRow["order_id"];
										
										?>
										<tr>
											<td valign="top" align="left"><?php echo htmlentities($ordRow["order_id"]); ?>
											</td>
											<td valign="top" align="left"><?php echo ($ordRow["user_name"]); ?>
											</td>
											<td valign="top" align="left"><?php echo getOrderStatus($ordRow["order_id"]); ?>
											</td>
											<td valign="top" align="left"><?php echo dateFormat($ordRow["order_date"], "Y-m-d", "m/d/Y") ?>
											</td>
											<td valign="top" align="left"><?php echo $adminSymbol;?>
												&nbsp;<?php echo htmlentities(number_format($orderTotal, 2, '.', '')); ?>
											</td>
											<td><a href="<?php echo $link; ?>"><?php echo VIEW;?></a></td>
											
										</tr>
										<?php } ?>
										<?php }else{ ?>
										<tr>
											<td valign="top" colspan="5" align="left"><?php echo NO_ORDRES_FOUND;?></td>
										</tr>
										<?php } ?>
									</table>
								</div>
							</div>
						</div>								
						<div class="clearfix">&nbsp;</div>
						<div class="row">
							<div class="col-xs-12 col-sm-6">
								<h2><?php echo PRODUCTS;?></h2>
								<div class="dashboard_bottom_box">
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo TODAY;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalProductsTodayCount; ?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo THIS_WEEK;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalProductsWeekCount;?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo THIS_MONTH;?>
										</div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalProductsMonthCount;?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo LAST_MONTH;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalProductsLastMonthCount;?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo CHANGE;?> %</div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalProductsChangeCount;?></div>
									</div>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6">
								<h2><?php echo VENDORS;?></h2>
								<div class="dashboard_bottom_box">
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo TODAY;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalVendorsTodayCount;?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo THIS_WEEK;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalVendorsWeekCount;?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo THIS_MONTH;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalVendorsMonthCount;?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo LAST_MONTH;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalVendorsLastMonthCount;?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo CHANGE;?> %</div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalVendorsChangeCount;?></div>
									</div>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6">
								<h2><?php echo ORDERS;?></h2>
								<div class="dashboard_bottom_box">
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo TODAY;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalOrdersTodayCount; ?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo THIS_WEEK;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalOrdersWeekCount; ?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo THIS_MONTH;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalOrdersMonthCount; ?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo LAST_MONTH;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalOrdersLastMonthCount; ?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo CHANGE;?> %</div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R"><?php echo $totalOrdersChangeCount; ?></div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo VENDOR_AMOUNT;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R">
											<?php echo $adminSymbol;?>
											<?php echo number_format($sellerAmountPending, 2, '.', ''); ?>
										</div>
									</div>
									<div class="dashboard_bottom_box_inner">
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_L"><?php echo COMMISSION;?></div>
										<div class="col-xs-12 col-sm-6 dashboard_bottom_box_inner_R">
											<?php echo $adminSymbol;?>
											<?php echo number_format($commissionAmount, 2, '.', ''); ?>
										</div>
									</div>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6">
								<div class="feedback_box_bottom">
									<h2>
										<?php echo RECENT_SITE_FEEDBACK;?> <a href="feedbacks.php?rghtMenu=rghtMenu10" class="pull-right"><?php echo VIEW_ALL; ?></a>
									</h2>
									<div class="feedback_box_cont">
										<?php if($siteFeedbacks != false){
											foreach($siteFeedbacks as $row){ $row=(object)$row;
												?>
												<div class="feedback_box_cont_inner">
													<p>
														<?php echo substr($row->feedback_content,0,80); ?>
													</p>
													<h3>
														<p><?php echo $row->name; ?></p>
														<span><?php echo date('m/d/Y', strtotime($row->date_added)); ?></span>
														<div class="clear"></div>
													</h3>
													<div class="clear"></div>
													
												</div>
												
												
												<?php }
											}else{ ?>
											<?php echo NO_FEEDBACK_FOUND;?>
											<?php } ?>
											
										</div>
									</div>
								</div>
								
							</div>
							<div class="clearfix">&nbsp;</div>
							<!--content area ends -->
						</div>
						<!-- right_main_cont_inner END -->
						<div class="clearfix"></div>	
					</div>
				</div>
				
			</div>



			<div class="clearfix"></div>


			<?php
			include "../includes/admin_new_footer.php";
			?>