<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		              |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

if (isset($_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"] != "") {
    $adminname = $_SESSION["sess_adminname"];
} else {
    header("Location:login.php");
    exit;
}

/** Manu R S - 24/01/18 */
/** -------Search keywords persistence------- */
if (isset($_GET["txtSearch"]) and $_GET["txtSearch"] != "") {
    $txtSearch = $_GET["txtSearch"];
    $cmbSearchType = $_GET["cmbSearchType"];
} else if (isset($_POST["txtSearch"]) and $_POST["txtSearch"] != "") {
    $txtSearch = $_POST["txtSearch"];
    $cmbSearchType = $_POST["cmbSearchType"];
}

$txtSearch = trim($txtSearch);
$txtSearch = strip_tags($txtSearch);

if (isset($_GET["msg"]) and $_GET["msg"] != "") {
    $msg = $_GET["msg"];
    switch ($msg) {
        case "deleted": $message = FEEDBACK_DEL_SUCC."!";
        break;
        default:
        ;
    } // switch
}

if (isset($_POST['gotoPage'])) {
	$txtSearch     = $_POST['searchbox'];
    $cmbSearchType = $_POST['searchboxtype'];
    $txtSeller     = $_POST['seller'];
    header("Location:".$_SERVER['PHP_SELF']."?page=".$_POST['gotoPage']."&txtSearch=".$txtSearch."&cmbSearchType=".$cmbSearchType."&msg=" . $msg);
    exit();
}

$qryopt = "";
$qryopt.="WHERE o.vpayment_status='C' ";
if ($txtSearch != "") {
    if ($cmbSearchType == "artistname") {
        $qryopt .= "  AND   s.artist_name like '" . addslashes($txtSearch) . "%'";
    } else if ($cmbSearchType == "datepaid") {
        $dt = $txtSearch;
        $arrdt = explode("/", $dt);
        $day = $arrdt[1];
        $month = $arrdt[0];
        $year = $arrdt[2];
        $dt = $year . "-" . $month . "-" . $day;
        $qryopt .= "  AND  sp.payment_date like '" . addslashes($dt) . "%'";
    } else if ($cmbSearchType == "orderid") {
        $qryopt .= "  AND  sp.order_id like '" . addslashes($txtSearch) . "%'";
    }
}

$sql = " SELECT sp.*,s.artist_name, o.* FROM " . $tableprefix . "artist_payments sp
INNER JOIN  " . $tableprefix . "artists s
ON sp.artist_id = s.artist_id
INNER JOIN  " . $tableprefix . "orders o ON o.order_id = sp.order_id
" . $qryopt . "   order by sp.artist_payment_id DESC   ";
//echo $sql;
if (!(isset($pagenum))) {
    $pagenum = 1;
}

$limit = getSettingsValue('npagination_limit');

$page = isset($_GET['page']) ? trim($_GET['page']) : 1;


if (empty($page)) {
    $page = 1;
}

$result = $pdo->pdoQuery($sql)->results();

$totalrows = count($result);

$limitvalue = ($page - 1) * $limit;

$query_string = " LIMIT $limitvalue, $limit";

$sql = $sql . $query_string;

$rs = $pdo->pdoQuery($sql)->results();

$numofpages = ceil($totalrows / $limit);

include "../includes/htmltop1.php";
?>
<link rel="stylesheet" href="<?php echo SITE_URL; ?>/style/jquery-ui.css">
<script src="<?php echo SITE_URL; ?>/js/jquery-ui.js"></script>
<script language="JavaScript" type="text/JavaScript">
   $(document).ready(function () {
    $("#datepicker").datepicker({
        dateFormat: 'mm/dd/yy',
        maxDate: '0'
        
    });
    
    $("#cmbSearchType").on("change",function(){
        if(this.value=='datepaid'){
           $("#textSelector").hide();
           $("#dateSelector").show();
           $("#txtSearch").attr("disabled","disabled");
           $("#datepicker").removeAttr("disabled");
           
       }else{
           $("#textSelector").show();
           $("#dateSelector").hide();
           $("#datepicker").attr("disabled","disabled");
           $("#txtSearch").removeAttr("disabled");
           
       }
       
       
   });
});
   function clickSearch()
   {
    document.frmFeedbacks.submit();
}
function changeStatus(id){
    var frm = document.frmFeedbacks;
    if(Confirm("<?php echo ARE_YOU_SURE;?>?")){
        document.frmFeedbacks.submit();
    }
}

function setValForSearchType(val)
{
   document.frmFeedbacks1.searchboxtype.value = val;
}
</script>
<body>
    <div class="main_outer">
        <!--header area start -->
        <?php
        include_once("../includes/topheader_admin1.php")
        ?>
        <!--header area end -->
        <div class="contant_area">
          <!--main body start -->

          <?php
          include_once("../includes/admintopmenu1.php")
          ?>		
          
          <div class="right_main_cont_outer">

            <div class="right_main_cont_inner">

                <!--content area start -->

                <h1><?php echo PAYMENTS;?></h1>
                <div class="text_information_success"><?php echo $message ?></div>
                <form action="<?php echo $_SERVER["PHP_SELF"] ?>" method="post" name="frmFeedbacks">
                  <?php
                  $dateblock = "none";
                  if($cmbSearchType!= "datepaid"){
                     $txtBlock = "display";
                     $dateblock = "none";
                     $txtSearch1 = $txtSearch; 
                     $disabled1   = "";
                     $disabled2   = "disabled=disabled";
                 } else{
                     $txtBlock = "none";
                     $dateblock = "display";
                     $txtSearch2 = $txtSearch;
                     $disabled1   = "disabled=disabled";
                     $disabled2   = "";
                 }
                 
                 ?>
                 
                 <div class="white_cont_outer margin_B_30">
                  <div class="row">
                     <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 list_search_outer_L">
                        <h3><?php echo SEARCH;?></h3>
                        <div class="row">
                           <div class="col-xs-12 col-sm-4 col-md-5">
                              <select name="cmbSearchType"  id="cmbSearchType" onChange="javascript:setValForSearchType(this.value);" class="form-control">
                                 <option value="artistname"  <?php if ($cmbSearchType == "artistname" || $cmbSearchType == "") {
                                  echo("selected");
                              } ?>><?php echo SELLER_NAME;?></option>
                              <option value="orderid"  <?php if ($cmbSearchType == "orderid") {
                                  echo("selected");
                              } ?>><?php echo ORDER;?> #</option>
                              <option value="datepaid"  <?php if ($cmbSearchType == "datepaid") {
                                  echo("selected");
                              } ?>><?php echo DATE_PAID;?> <!--(<?php echo MM."/".DD."/".YYYY;?>)--></option>
                              
                          </select>
                      </div>
                      <div class="col-xs-12 col-sm-5 col-md-5 list_search_outer_L_inner">
                          <span id="textSelector" style="display:<?php echo $txtBlock; ?>"  >
                             <input type="text" <?php echo $disabled1; ?> name="txtSearch" id="txtSearch" size="20" maxlength="50" onKeyPress="if(window.event.keyCode == '13'){ return false; }" value="<?php echo(htmlentities($txtSearch1)); ?>"   class="form-control">
                         </span>
                         <span id="dateSelector" style="display:<?php echo $dateblock; ?>" >
                             <input type="text" <?php echo $disabled2; ?> name="txtSearch" id="datepicker" size="20" maxlength="50" value="<?php echo(htmlentities($txtSearch2)); ?>"   class="form-control">
                         </span>
                     </div>
                     <div class="col-xs-12 col-sm-3 col-sm-2">
                      <a href="javascript:clickSearch();" class="search_button pull-left">
                         <i class="fa fa-search" aria-hidden="true"></i> <?php echo BTN_SEARCH; ?>
                     </a>
                 </div>
             </div>
         </div>
     </div>
 </div>
</form>					

<form action="<?php echo $_SERVER["PHP_SELF"];?>" method="post" name="frmFeedbacks1">
   <input type="hidden" name="searchbox" id="searchbox" value="<?php echo $_REQUEST['txtSearch']; ?>">
   <input type="hidden" name="searchboxtype" id="searchboxtype" value="<?php echo $_REQUEST['cmbSearchType']; ?>">

   <div class="table-responsive no_margin">
    <table  width="100%" cellpadding="0" cellspacing="0" class="table admin_table no_margin">
       
     <tr align="left">
        <td  colspan="9" class="lineheight_24">
           <?php echo ADMIN_COMMISION_AMOUNT;?><br>
           <?php echo AMOUNT_PAYABLE_NOTE;?>
       </td>
   </tr> 
   
   
   <tr class="page_title2" align="left">
    <th width="3%" align="left" height="30">#</th>
    <th width="15%" align="left"><?php echo SELLER_NAME;?></th>
    <th width="8%" align="left"><?php echo ORDER;?> #</th>
    <th width="14%" align="left"><?php echo SELLER_ORDER_TOTAL;?></th>
    <th width="14%" align="left"><?php echo PRO_TOTAL;?></th>
    <th width="10%" align="left"><?php echo DISCOUNT;?> </th>
    <th width="18%" align="left"><?php echo COMMISSION_AMOUNT;?></th>
    <th width="14%" align="left"><?php echo AMOUNT_PAYABLE;?></th>
    <th width="20%" align="left"><?php echo PAYMENT_STATUS;?> </th>
</tr>
<?php
if (count($result) > 0) {
    $i = 1;
                                //echopre($rs);
    foreach ($rs as $row) {
        $link = "<a href='viewpayment.php?paymentid=" . $row["artist_payment_id"] . "' class='links'>";
        $txtPaymentDate = (isNotNull($row["payment_date"] and ($row["payment_date"] != "0000-00-00")) ? dateFormat($row["payment_date"], "Y-m-d", "m/d/Y") : "");

        $currencycode = getSellerCurrencySybol($row['artist_id']);
        $currencySymbol = getCurrencySybol($currencycode);


        if ($row['payment_status'] == 'P') {
            $Paymentstatus = NOT_YET_SETTLE;
        } else {
            $Paymentstatus = PAID;
        }
                                   //added for showing gift/coupon code amount.
        if($row['vgiftcertificate_code']!='' && $row['nused_gift_amount']!=0 ){
            
            $giftDiscountAmount         =   $row['nused_gift_amount'];
            
            
        }


        $couponCodeDiscountAmount = 0;

        if (($row['artist_id'] == $row['couponCodeSeller_Id']) && ($row['couponCodeDiscount'] > 0)) {
          $couponCodeDiscountAmount = $row['couponCodeDiscount'];
      }


      
      if($row['vgiftcertificate_code']!=''|| $row['couponCodeDiscount'] > 0){
          $totalDiscount=$giftDiscountAmount+$couponCodeDiscountAmount;
      }else $totalDiscount=0;

                                //end added for showing gift/coupon code amount.
      $orderTotal = $row['namount_paid']+$totalDiscount;

      ?>
      <tr align="left">
        <td><?php echo (($page * $limit) + $i - $limit) ?></td> 
        <td><?php echo $link . (substr($row["artist_name"], 0, 40)) . "</a>"; ?></td>
        <td><?php echo $link . htmlentities($row["order_id"]) . "</a>"; ?></td>
        <td><?php echo $adminCurrency['currency_symbol']; ?> &nbsp; <?php echo $link . htmlentities(number_format($orderTotal, 2, '.', '')) . "</a>"; ?></td>

        
        <td><?php echo $adminCurrency['currency_symbol']; ?> &nbsp; <?php echo $link . htmlentities(number_format($row["total_amount"], 2, '.', '')) . "</a>"; ?></td>
        <td><?php echo $adminCurrency['currency_symbol']; ?> &nbsp; <?php echo $link . htmlentities(number_format($totalDiscount, 2, '.', '')) . "</a>"; ?></td>
        <td><?php echo $adminCurrency['currency_symbol']; ?> &nbsp; <?php echo $link . htmlentities(number_format($row["admin_commision_amount"], 2, '.', '')) . "</a>"; ?> &nbsp; (<?php echo $row["commission_percentage"] ?>%) </td>
        <td><?php echo $adminCurrency['currency_symbol']; ?> &nbsp; <?php echo $link . htmlentities(number_format($orderTotal- ($row["admin_commision_amount"]+$totalDiscount), 2, '.', '')) . "</a>"; ?></td>
        <td><?php echo $link . $Paymentstatus . "</a>"; ?></td>
    </tr>
    <?php
    $i++;
}
} else {
    ?>					
    <tr>
        <td align="center" valign="middle" colspan="9"  class="text_information"><?php echo NO_RECORDS_FOUND;?> !!</td>
    </tr>					
    <?php
}
?>


</table>



</div>


<div class="clearfix"></div>

<?php

if ($page > 1) {
 $pageprev = $page - 1;
 
 $previous_page = "<a href=" . $_SERVER['PHP_SELF'] . "?rghtMenu=" . $_GET["rghtMenu"] . "&page=$pageprev alt='Previous' border='0' class='prv_nxt_btt'><i class='fa fa-angle-left' aria-hidden='true'></i></a>";
}


if ($page < $numofpages) {
 $pagenext = ($page + 1);
 
 $next = "<a href=" . $_SERVER['PHP_SELF'] . "?rghtMenu=" . $_GET["rghtMenu"] . "&page=$pagenext alt='Next' border='0' class='prv_nxt_btt'><i class='fa fa-angle-right' aria-hidden='true'></i></a>";
}
?> 
<?php
if ($page < $numofpages || $page > 1) {
  ?>
  
  <div class="pagination_outer">
     <div class="row">
        <div class="col-xs-12 col-sm-4 col-md-7 col-lg-7">
           
        </div>											
        <div class="col-xs-12 col-sm-8 col-md-5 col-lg-5">
           <div class="feild_outer">
              <select class="form-control" name="gotoPage">
                 <?php
                 for ($i = 1; $i <= $numofpages; $i++) {
                    if ($i == $_GET['page']) {
                       $page_selected = "selected";
                   } else {
                       $page_selected = "";
                   }
                   ?>
                   <option value="<?php echo $i ?>" <?php echo $page_selected ?>>
                    <?php echo $i ?>
                </option>

                <?php
            }
            ?>
        </select>
        <a onClick="Javascript:document.frmFeedbacks1.submit();" class="go_btt"><i class="fa fa-paper-plane" aria-hidden="true"></i> <?php echo GO; ?></a>
    </div>
    <div class="prv_nxt_btt_outer">
       <?php echo $previous_page ?>
       <?php //echo PAGE."(".S.")";?>
       <span class="numofpages"><?php echo $page ?>/<?php echo $numofpages ?></span>
       <?php //echo GO_TO;?>
       <?php echo $next ?>
   </div>
   
</div>
</div>
</div>

<?php
}
?>








</form>


<!--content area end-->

</div>
</div>

<!--main body end -->
</div>


<?php
include "../includes/admin_new_footer.php";
?>