<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		              |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";
include "../includes/arrays.inc.php";

if (get_magic_quotes_gpc()) {
	$_POST = array_map('stripslashes_deep', $_POST);
	$_GET = array_map('stripslashes_deep', $_GET);
	$_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

if (isset($_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"] != "") {
	$adminname = $_SESSION["sess_adminname"];
} else {
	header("Location:login.php");
	exit;
}

$select_shipping_settings = "SELECT * FROM " . $tableprefix . "shipping_settings";
$result_shipping_settings = $pdo->pdoQuery($select_shipping_settings)->results();

if (count($result_shipping_settings) > 0) {
	$rs_ship = ($result_shipping_settings[0]);
	$ups_weight = $rs_ship['nShippingweight'];
	$ups_rate = $rs_ship['ups_rate'];
	$ups_container = $rs_ship['container_type'];
	$ups_type = $rs_ship['address_quote_method'];
} // end if 




include "../includes/htmltop1.php";

$message = "";
if (isset($_POST['submit'])) {


	$ups_weight = $_POST['nweight'];
	$ups_rate = $_POST['ups_rate'];
	$ups_container = $_POST['container_type'];
	$ups_type = $_POST['res_type'];
	(isset($_POST['enable_shipping'])) ? $txtEnableShipping = $_POST['enable_shipping'] : $txtEnableShipping = 'N';
	if (empty($ups_weight)) {
		$message = PLS_MAX;
	}
    if ($message == "") { // check no error
    	$update_settings = "UPDATE " . $tableprefix . "shipping_settings SET nShippingweight= :ups_weight,ups_rate= :ups_rate, container_type= :ups_container,address_quote_method= :ups_type ";
    	$pdo->pdoQuery($update_settings,array("ups_weight"=>$ups_weight, "ups_rate"=>$ups_rate, "ups_container"=>$ups_container, "ups_type"=>$ups_type))->results();

    	$sql="UPDATE " . $tableprefix . "settings 
    	SET enable_shipping = :txtEnableShipping";
    	$pdo->pdoQuery($sql,array("txtEnableShipping"=>$txtEnableShipping))->results();

    	$success_message = MSG_SETTINGS;
    }
}


$sql = "SELECT * FROM " . $tableprefix . "settings ";
$result = $pdo->pdoQuery($sql)->results();
if (count($result) != 0) {
	$row = ($result[0]);

	$txtEnableShipping = $row["enable_shipping"];
	$txtfedex = $row["enable_fedexshipping"];
	$txtusps = $row["enable_uspsshipping"];
	$chkcanadapost = $row["enable_canadapost"];
	$chkaustraliapost = $row["enable_australiapost"];

	$txtflatShipping = $row["enable_flatrate"];
	$default_flatrate = $row["default_flatrate"];
	$flatrate_additional = $row["additional_flatrate"];
	$flatrate_name = stripslashes($row["flatrate_displayname"]);
}

if ($txtEnableShipping == "Y") {
	$shipping_checked = "checked";
	$ups_shipping_block = "visible";
} else {
	$shipping_checked = "";
	$ups_shipping_block = "none";
}
if ($txtMembership == "Y") {
	$Membership_checked = "checked";
}

if ($chkcanadapost == "Y") {
	$canadapost_checked = "checked";
} else {
	$canadapost_checked = "";
}
if ($chkaustraliapost == "Y") {
	$australiapost_checked = "checked";
} else {
	$australiapost_checked = '';
}

if ($txtusps == "Y") {
	$shipping_usps_checked = "checked";
} else {
	$shipping_usps_checked = "";
}
if ($txtEnableYourPay == "Y") {
	$yourpay = "checked";
	$yourpay_block = "";
} else {
	$yourpay = "";
	$yourpay_block = "none";
}
if ($txtfedex != "N") {
	$fedex_checked = "checked";
	$fedex_shipping_block = "";
} else {
	$fedex_checked = "";
	$fedex_shipping_block = "none";
}


if ($txtflatShipping == "Y") {
	$flat_checked = "checked";
	$flatrate_block = "";
} else {
	$flat_checked = "";
	$flatrate_block = "none";
}
?>
<script language="javascript">
	function checkUpsshipping()
	{
		if(document.frmSettings.enable_shipping.checked == true)
		{
			document.getElementById("upsBlock").style.display = "";
		}
		else
		{
			document.getElementById("upsBlock").style.display = "none";
		}
	}
</script>
<body>
	<div class="main_outer">
		<!--header area start -->
		<?php
		include_once("../includes/topheader_admin1.php")
		?>
		<!--header area end -->
		<div class="contant_area">
			<!--main body start -->
			<?php
			include_once("../includes/admintopmenu1.php")
			?>
			
			<div class="right_main_cont_outer">
				<div class="right_main_cont_inner">
					<h1><?php echo EDIT_USPSHPNG;?></h1>
					<div class="clearfix"></div>
					<form action="#" method="post" name="frmSettings" onSubmit="return validate();">
						<div class="text_information">
							<?php if ($message) { ?>
							<div class='error_msg white_bg'>
								<i class="fa fa-exclamation-triangle" aria-hidden="true"></i> <?php echo $message?>
							</div>			
							<?php } ?>
						</div>
						<div class="text_information_success">
							<?php if ($success_message) { ?>
							<div class='success_msg white_bg'>
								<i class='fa fa-check' aria-hidden='true'></i><?php echo $success_message; ?>
							</div>
							<?php } ?>
						</div>				
						<div class="clearfix"></div>
						
						<?php include_once("../includes/shippingmenu.php") ?>
						
						<div class="clearfix"></div>
						<div class="white_cont_outer margin_B_30">
							<div class="row">
								<div class="form_outer">
									<div class="col-xs-12 col-sm-12">
										<?php echo ENABLE_SHPN;?> &nbsp; 
										<input type="checkbox" name="enable_shipping" value="Y" <?php echo $shipping_checked ?>  onClick="checkUpsshipping();"/>  &nbsp; 
										<?php echo ENABLE_USPSS;?>
										
										<div class="clearfix">&nbsp;</div>
										
										<div id="upsBlock" style="display:<?php echo $ups_shipping_block; ?>">
											<div class="row">
												<div class="col-xs-12 col-sm-6 col-md-6 col-lg-3 shipping_settings_cont_outer">
													<label><?php echo MAX_WEIGHT;?> <span class="required">* </span></label>
													<input type='text' name='nweight' id ='nweight' value='<?php echo $ups_weight; ?>' class='form-control' size='21'>
												</div>
												<div class="col-xs-12 col-sm-6 col-md-6 col-lg-3 shipping_settings_cont_outer">
													<label><?php echo UPSR;?> <span class="required">* </span></label>
													<select class="form-control" name="ups_rate">
														<?php
														foreach ($rate_array as $r => $rates) {
															?>
															<option value="<?php echo $r; ?>" <?php
																if ($ups_rate == $r) {
																	echo "Selected";
																}
																?>><?php echo $rates; ?></option>
																<?php
															} // end for each 
															?>
														</select>
													</div>
													<div class="col-xs-12 col-sm-6 col-md-6 col-lg-3 shipping_settings_cont_outer">
														<label><?php echo CONT_TYP;?><span class="required">* </span></label>
														<select class="form-control" name="container_type">
															<?php
															foreach ($container_type as $cp => $types) {
																?>
																<option value="<?php echo $cp; ?>" <?php
																	if ($ups_container == $cp) {
																		echo "Selected";
																	}
																	?>><?php echo $types; ?></option>
																	<?php
															} // end for each 
															?>
														</select>
													</div>
													<div class="col-xs-12 col-sm-6 col-md-6 col-lg-3 shipping_settings_cont_outer">
														<label><?php echo ADDRESS_QUOTE;?><span class="required">* </span></label>
														<select class="form-control" name="res_type">
															<?php
															foreach ($res_type as $re => $res) {
																?>
																<option value="<?php echo $re; ?>" <?php
																	if ($ups_type == $re) {
																		echo "Selected";
																	}
																	?>><?php echo $res; ?></option>
																	<?php
															} // end for each 
															?>
														</select>
													</div>
													
													<div class="clearfix">&nbsp;</div>
													
												</div>
												
											</div>
											
											<div class="row">
												<div class="clearfix"></div>											
												<div class="col-xs-12 col-sm-12 col-md-4"></div>
												<div class="col-xs-12 col-sm-6 col-md-4"></div>
												<div class="col-xs-12 col-sm-6 col-md-4">
													<button type="submit" name="submit" value="<?php echo BTN_UPDATE; ?>" class="primery_btt">
														<i class="fa fa-refresh" aria-hidden="true"></i> <?php echo BTN_UPDATE; ?>
													</button>
												</div>
											</div>
											
										</div>
									</div>
								</div>
								
							</div>
						</form>
					</div>
				</div>
			</div>

			

		</div>


		<?php
		include "../includes/admin_new_footer.php";
		?>
		<script language="javascript">

			function validate()
			{
				if(document.frmSettings.nweight.value=="")
				{
					alert("<?php echo PLS_MAX;?>");
					document.frmSettings.nweight.focus();
					return false;
				}
				else if(isNaN(document.frmSettings.nweight.value))
				{
					alert("<?php echo SHPNG_INTEGER;?>");
					document.frmSettings.nweight.focus();
					return false;
				}	
				else
					return true;

			}
		</script>

