<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		          |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com (C) 2005              |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "includes/config.php";
include "includes/session.php";
include "includes/functions.php";
include "classes/cls_user.php";
include "classes/cls_store.php";
/*display the active template*/
$active_template    =   displayTemplate();

include "includes/htmltop.php";

/* Top File Name */

include_once ("includes/".$active_template[0]);

/*---Display the terms and conditions------*/

$cms_content_terms = displayCMS('about_us');

/*---Display the terms and conditions------*/

?>


<div class="main_body">
	<div class="container">
		<div class="row">
		<form name="frmRegister" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES, 'UTF-8');?>" method="POST" onSubmit="">
			<input type="hidden" name="action" value="<?php echo htmlentities($action);?>">
			<section class="sec_marg">
				<div class="col-sm-12 col-lg-6 col-md-6 ">
						<h3><?php echo SELLERS_TEXT;?></h3>
				</div>
				<div class="col-sm-12 col-lg-6 col-md-6 ">
					<div style="float:right;">
					   <input type="button" onclick="window.location.href='sellers/login.php'"  value="<?php echo SELLER_LOGIN_BUTTON;?>" class="button" />
                                           <?php //check if seller account is activated
                                           $arrIsSeller = User::is_seller_account_activated($_SESSION["sess_userid"]);
                                           if ($arrIsSeller->data['is_seller'] == "Y") {
                                               $sellerObj = Store::get_seller_account_info($arrIsSeller->data->seller_id);
                                               if ($sellerObj->data['deleted'] == "N" && $sellerObj->data['vapproved'] == "Y") {
                                                   $is_seller = true;
                                               } else {
                                                   $is_seller = false;
                                               }
                                           } else {
                                               $is_seller = false;
                                           }
                                           ?>
                                           <?php if(!$is_seller){?>
					   <input type="button" onclick="window.location.href='sellers/register.php'" value="<?php echo REGISTER_BUTTON;?>"  class="button" />
                                           <?php } ?>
					</div>
				</div>
				<div class="col-sm-12 col-lg-12 col-md-12">
					<div class="text_information" align="center"><?php echo $message?></div>
				</div>
			<div class="clear"></div>
			</section>
	<div class="cms_content_area">
	<?php        
        $sql="SELECT  ar.artist_id,ap.artist_description,ap.artist_photo,ar.artist_name,
                    ar.first_name, ar.last_name, ar.artist_name,ar.storename
			  FROM ".$tableprefix."artists ar
                              LEFT JOIN ".$tableprefix."artist_portfolios ap ON ar.artist_id = ap.artist_id
			  WHERE ar.vapproved='Y'  AND ar.deleted='N' AND plan_expired ='N' ";
       /* if($_SESSION["sess_artistid"]!='') {
                $sql.=' AND ar.artist_id!="'.$_SESSION["sess_artistid"].'" ';
        }*/
        $sql.=" ORDER BY ar.first_name  ASC";

$condArray = '';
$limit=getPaginationLimit();
$sql_qr=dopagingbypdo($sql,'',$limit,$condArray,$pdo);
if($limit==0)
{
	$limit=12;
}	

$page=$_GET['page'];

if(empty($page))
	{
		$page = 1;
	}
	$prodimagedir = "products/";
				
	if(!(isset($pagenum)))
	{
		$pagenum = 1;
	} 
	$resultCount=$pdo->pdoQuery($sql)->results();
	$result=$pdo->pdoQuery($sql_qr,$condArray)->results();

	if(!empty($resultCount)){
            $totalrows = count($resultCount);
    } else $totalrows = 0;
	if($page > 0){
	$limitvalue = ($page - 1) * $limit;
        }
        else
        {
            $limitvalue = 0;
        }
	
	if(!empty($result))
	{
            foreach($result as $row)
            {	

                        $foto = $row['artist_photo'];
                        
                        $profileImage    =   SITE_URL."/portfolios/".$foto;
                        
                        
                        if(!(is_file("./portfolios/". $foto) && file_exists("./portfolios/". $foto)))
                        {
                            $foto = 'noimage.jpg';
                            $profileImage    =   SITE_URL."/portfolios/".$foto;
                            
                        }
                        
                             
                    
                        if($enable_seller_friendly == "Y")
                        {
                           
                            $sellerLink = (!empty($row['storename'])) ? SITE_URL . "/stores/" . $row['storename'] : SITE_URL . "/store/" . $row['artist_name'];
                            //$sellerLink = SITE_URL . "/store/" . $row['artist_name'];
                        }
                        else
                        {
                            $sellerLink = (!empty($row['storename'])) ? SITE_URL."/showportfolio.php?storename=" . $row['storename'] : SITE_URL."/showportfolio.php?artistid=" . $row['artist_id'];
                        }
?>			
<section class="sec_marg">
<div class="col-sm-12 col-lg-6 col-md-6 ">
<div class="seller_lst_wrap">
	<div class="row">
		<div class="col-sm-12 col-lg-3 col-md-3 ">
			<div class="image_div">
			   <a href="<?php echo $sellerLink; ?>" target="_blank">  
			   <img src="<?php echo $profileImage; ?>" />
			   </a>
			</div>
		</div>
		<div class="col-sm-12 col-lg-9 col-md-9 ">
			<div class="sellerlst_content">
			<h3><a href="<?php echo $sellerLink; ?>" target="_blank" >  <?php echo ucfirst($row['artist_name']);?> </a>        </h3>
			<?php if($row["artist_description"]!='') { ?>
                        <div> 
				<?php 
				$desc = strip_tags($row["artist_description"]);
				$seller_desc = preg_replace('/\s+?(\S+)?$/', '', substr($desc, 0, 220));
				echo $seller_desc."...";
				?>
			</div>
                        
                        <?php } ?>
			
			<div class="clear"></div>
			</div>
		</div>
	</div>
	<div class="clear"></div>
</div>
<div class="clear"></div>

</div>
</section>			

<?php
			}
		
	
		}
		else{
		
		     echo "<br>".SELLER_NOT_FOUND_TEXT;
		}
	
		if($page > 1)
		{
			$pageprev = $page-1;
			
			$previous_page = "<a href=".$_SERVER['PHP_SELF']."?page=$pageprev&tab=$currentTabID alt='".PREVIOUS_TEXT."' title='".PREVIOUS_TEXT."' border='0'><img src='".$active_template[3]."/previous_btn.gif' alt='".PREVIOUS_TEXT."' border='0' /></a>";
			
		}
		
		$numofpages = ceil($totalrows / $limit);
					
		if($page < $numofpages)
		{
			$pagenext = ($page + 1);
			
			$next = "<a href=".$_SERVER['PHP_SELF']."?page=$pagenext&tab=$currentTabID alt='".NEXT_TEXT."' title='".NEXT_TEXT."' border='0'><img src='".$active_template[3]."/next_btn.gif' alt='".NEXT_TEXT."' border='0'/></a>&nbsp;";
			
		}
		
?>	
		</form>

		<?php
		//echopre($totalrows); echopre($limit);
		if ($totalrows > $limit) { ?>
			<div class="col-sm-12 col-lg-12 col-md-12">
            	<div  class="pagination"> <?php echo rightpaging(); ?></div>
        	</div>	
		<?php } ?>						
					
		<div class="col-sm-12 col-lg-12 col-md-12">
			<div style="width:auto; float:right;" class="align_lt">
            	<input type="button" onclick="window.location.href='sellers/login.php'"   value="<?php echo SELLER_LOGIN_BUTTON;?>" class="button" />
                <?php if(!$is_seller){ ?>
                <input type="button" onclick="window.location.href='sellers/register.php'" value="<?php echo REGISTER_BUTTON;?>"  class="button" />
                <?php } ?>
        	</div>
		</div>
	</div>
	</div>		
</div>
    
				

<?php
include "includes/".$active_template[2];	/* Bottom File Name */
?>