<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		              |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com © 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "includes/config.php";
include "includes/session.php";
include "includes/functions.php";
include_once "includes/arrays.inc.php";
include_once "classes/cls_cart.php";
include_once "classes/cls_products.php";
include_once "classes/cls_user.php";
include_once "classes/cls_combopack.php";

/* if (get_magic_quotes_gpc()) {
  $_POST = array_map('stripslashes_deep', $_POST);
  $_GET = array_map('stripslashes_deep', $_GET);
  $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
  $_SESSION = array_map('stripslashes_deep', $_SESSION);
  } */
if (isset($_SESSION["sess_userid"]) and $_SESSION["sess_userid"] != "") {
    $userid = $_SESSION["sess_userid"];
    if (isCartEmpty($userid)) {
        header("Location:viewcart.php");
        exit;
    }

} else if (isset($_GET['guest_login']) && $_GET['guest_login'] == 1) {
    $guest_login = $_GET['guest_login'];

    $_SESSION['guest_login'] = $guest_login;

    if (isset($_SESSION['guest_login']) && $_SESSION['guest_login'] == 1) {
        $_SESSION["sess_userid"] = '';
    }
} else {

    if (isVisitorCartEmpty(session_id())) {
        header("Location:viewcart.php");
        exit;
    } else {
        if (!isset($_SESSION['guest_login'])) {
            header("Location:" . SITE_URL . "/login.php?action=checkout");
            exit;
        }
    }
}


//echopre($_SESSION);

//****************************************************Multicart3.0 Modifications*****************************
 if($_SESSION["sess_userid"]!='')  {
                            //Check the product is logged users product
                            $sellerAccObj   =    User::is_seller_account_activated($_SESSION["sess_userid"]);
                                  //echopre($sellerAccObj);
                                if($sellerAccObj->status==SUCCESS)
                                    {
                                            $sellerAccObjVal            =   $sellerAccObj->data;
                                            $seller_activated_status    =   $sellerAccObjVal['is_seller'];
                                            $activated_seller_id        =   $sellerAccObjVal['seller_id'];

                                    }
          // Check logged sellers product exist in cart // if single account enabled for buyer and seller

            $sellerCartObj      =    Cart::getCartCountBySellerId($_SESSION["sess_userid"],$visitorId,$activated_seller_id);
            //echopre($sellerCartObj);
            if($sellerCartObj->status==SUCCESS)
                    {
                         $sellerCartObjVal      =   $sellerCartObj->data;
                         $samesellerItemCount   =   $sellerCartObjVal['selleritemCount'];

                         if($samesellerItemCount>0)
                             {
                                    $redirecturl    =   "viewcart.php?msg=same_seller";
                                    generalMethods::redirect($redirecturl);
                             }
                    }

            }

//**********************************************Multicart3.0  Modifications**********************************

//$_SESSION["sess_addresses_collected"] = false;
if ($_SESSION["sess_userid"] == '' && $_SESSION['guest_login'] == '') {
    $_SESSION["sess_addresses_collected"] = false;

    header("Location:" . SITE_URL . "/login.php?action=checkout");
    exit;
}

//$_SESSION["sess_addresses_collected"] = false;
//==================Select shipping Details
 $result = $pdo->select($tableprefix."settings",'','')->result();
if (!empty($result)) {
    $row = $result;
    $fedexmode = $row['enable_fedexshipping'];
    $upsmode = $row['enable_shipping'];
    $uspsmode = $row['enable_uspsshipping'];
    $canadapost = $row['enable_canadapost'];
    $australiapost = $row['enable_australiapost'];
    $flatrate = $row['enable_flatrate'];
    //$default_flatrate=$row['default_flatrate'];
    //$flatrate_additional=$row['additional_flatrate'];
    //$flatrate_name=stripslashes($row['flatrate_displayname']);
    $flatrate_name = TEXT_OUR_SHIPPING;
    switch ($fedexmode) {
        case "FDXE":
            $fedexShipping = FDXE_TEXT;
            $fedexServiceArray = $fedexService;
            break;
        case "FDXG":
            $fedexShipping = FDXG_TEXT;
            $fedexServiceArray = $fedexGroundService;
            break;
        case "N":
            $fedexShipping = FEDEX_INACTIVE_TEXT;
            break;
         default :
             $fedexShipping = FDXG_TEXT;
            break;
    }// end if

    if ($fedexmode != "N" || $upsmode != "N") {
        $fedex_block_display = "";
        $check_shipping_enable = "Y";
    }

    if ($fedexmode == "N") {
        $fedex_block_display = "none";
    }
} // end number of rows check


/* -------Multicart 2.0 Upgradation--------- */

/* -------function call to check whether cart contains digital or gift coupon products so as to hide shipping--- */

//$hide_shipping_division = hideShipping();
//$hide_shipping_division_Free_shipp = checkFreeShipping();

if($_SESSION["sess_userid"]!='')
     {
         $visitorId     =  '';
     }else{
         $visitorId     = generalMethods::sessionid();
     }

//$hide_shipping_meth_division =  Cart::checkShippingRequired($_SESSION["sess_userid"],$visitorId);


$hide_shipping_division = Cart::checkShippingBlockRequired($_SESSION["sess_userid"],$visitorId);

/* -------function call to check whether cart contains digital or gift coupon products so as to hide shipping------ */
if ($upsmode != 'N' || $fedexmode != 'N' || $uspsmode != 'N' || $canadapost != 'N' || $australiapost != 'N' || $flatrate == "Y") { // check whether shipping Enabled or Not
    $check_shipping_enable = "Y";
} // end Shipping Check

if ($check_shipping_enable == "Y" && $hide_shipping_division == 1) {
    $shipping_block_display = "";
    $shipping_address_block_display = "";
} else {
    $shipping_block_display = "none";
}
$_SESSION['shipping_enabled'] = "true";
if ($upsmode == 'N' && $fedexmode == 'N' && $uspsmode == 'N' && $canadapost == 'N' && $australiapost == 'N' && $flatrate == "N") {
    $shipping_block_display = "none";
    $shipping_address_block_display = "none";
    $_SESSION['shipping_enabled'] = "false";
}

/* -------Multicart 2.0 Upgradation--------- */


if ($hide_shipping_division == 1) {
    $shipping_address_block_display = "";
} else {
    $shipping_address_block_display = "none";
}


if ($hide_shipping_division == 1) {
    $shipping_block_display = "";
} else {
    $shipping_block_display = "none";
}

//check Methods Needs to Enable

$shippingSelection_Needed   =   0;

if($check_shipping_enable=='Y' && $hide_shipping_division==1)
{
    $shippingSelection_Needed   =   1;
}

if (isset($_GET["msg"]) and ($_GET["msg"] != "")) {
    $msg = $_GET["msg"];
    switch ($msg) {
        case "updateqty": $message = UPDATE_QUANTITY_ERROR_MSG."<br>";
            break;
        default:
            ;
    } // switch
}

$txtBillingFirstName = $_POST["txtBillingFirstName"];
$txtBillingLastName = $_POST["txtBillingLastName"];
$txtBillingAddress1 = $_POST["txtBillingAddress1"];
$txtBillingAddress2 = $_POST["txtBillingAddress2"];
$txtBillingCity = $_POST["txtBillingCity"];

$txtBillingZIP = $_POST["txtBillingZIP"];

$txtBillingPhone = $_POST["txtBillingPhone"];
$txtBillingEmail = $_POST["txtBillingEmail"];
$ddlBillingCountry = $_POST["bill_country"];
$txtBillingState = $_POST["bill_state"];
$chkSameAsAbove = $_POST["chkSameAsAbove"];



if ($chkSameAsAbove == "on") {
    $txtShippingFirstName = $txtBillingFirstName;
    $txtShippingLastName = $txtBillingLastName;
    $txtShippingAddress1 = $txtBillingAddress1;
    $txtShippingAddress2 = $txtBillingAddress2;
    $txtShippingCity = $txtBillingCity;
    $txtShippingZIP = $txtBillingZIP;

    $txtShippingPhone = $txtBillingPhone;
    $txtShippingEmail = $txtBillingEmail;
    $ddlShippingCountry = $ddlBillingCountry;
    $txtShippingState = $txtBillingState;

    $sameshipping = 1;
} else {
    $txtShippingFirstName = $_POST["txtShippingFirstName"];
    $txtShippingLastName = $_POST["txtShippingLastName"];
    $txtShippingAddress1 = $_POST["txtShippingAddress1"];
    $txtShippingAddress2 = $_POST["txtShippingAddress2"];
    $txtShippingCity = $_POST["txtShippingCity"];
    $txtShippingZIP = $_POST["txtShippingZIP"];

    $txtShippingPhone = $_POST["txtShippingPhone"];
    $txtShippingEmail = $_POST["txtShippingEmail"];
    $ddlShippingCountry = $_POST["ship_country"];
    $txtShippingState = $_POST["ship_state"];

    $sameshipping = 0;
}

if (isset($_POST["btnConfirmOrder"])) {



    $txtComments = $_POST['txtComments'];

    $_SESSION["SESS_BUYER_COMMENTS"] = $txtComments;

    $_SESSION["sess_addresses_collected"] = true;




    if (isset($_SESSION['guest_login']) && $_SESSION['guest_login'] == 1 && $_SESSION["sess_userid"]=='') {
        $chk_email_exists = $pdo->select($tableprefix."users",array("user_id"),array("email"=>$txtBillingEmail))->results();
        $chk_email_exists_num_rows = count($chk_email_exists);

        if ($chk_email_exists_num_rows > 0) {

            $rsObj = $chk_email_exists[0];
            if ($rsObj['user_id'] != '') {
                $userid = $rsObj['user_id'];

                // When User wish to purchase as a guest Check Cart Items  Exists for a user  with same email id Modified By Asha ON 08-10-2012

                $sql_itmesQ = "SELECT * FROM  " . $tableprefix . "cart c
                        LEFT JOIN " . $tableprefix . "cart c1 ON (c1.product_id=c.product_id AND c1.product_option_id=c.product_option_id) where
                        c1.visitor_cart_id =:visitor_cart_id AND  c.user_id =:user_id";

                $rs_itemsQ = $pdo->pdoQuery($sql_itmesQ,array("visitor_cart_id"=>session_id(),"user_id"=>$userid))->results();

                $cartitems = array();

                if (!empty($rs_itemsQ)) {
                    foreach ($rs_itemsQ as $itemsRow) {
                        $cartitems[] = $itemsRow['cart_id'];
                    }


                    $cartitemslist = implode(",", $cartitems);

                    list($qarr,$qstr) = getInQueryString($cartitemslist);
                    $sql_Delitems = "DELETE  FROM " . $tableprefix . "cart  where cart_id IN ($qstr) ";

                    $rs_Delitems = $pdo->pdoQuery($sql_Delitems,$qarr);
                }



                // End Check
            }
        } else {

            $userstring = strtolower(substr($txtBillingFirstName, 0, 3));
            $get_username = generateUsername(6, 2);

            if ($userstring != '') {
                $username = $userstring . $get_username;
            }

            $guest_password = generatePassword(6, 2);

            $curdate  =  date('Y-m-d');

            $userdata =  array("user_name"=>$username,
                        "password"=>md5($guest_password),
                        "first_name"=>$txtBillingFirstName,
                        "last_name"=>$txtBillingLastName,
                        "address1"=>$txtBillingAddress1,
                        "address2"=>$txtBillingAddress2,
                         "city"=>$txtBillingCity,
                         "state"=>$txtBillingState,
                         "country"=>$ddlBillingCountry,
                         "phone"=>$txtBillingPhone,
                         "zip"=>$txtBillingZIP,
                         "email"=>$txtBillingEmail,
                         "date_registered"=>$curdate);



           $userid  = $pdo->insert($tableprefix."users",$userdata)->lastInsertId();


            $_SESSION["sess_guest_login_id"] = $userid;

            $_SESSION["sess_guest_username"] = $username;

            $_SESSION["sess_guest_password"] = $guest_password;
        }

        $_SESSION["sess_userid"] = $userid;

        // Update Cart with User Id

        if ($_SESSION["sess_userid"] != '') {
            $rs_up = $pdo->update($tableprefix.'cart', array("user_id" =>$_SESSION['sess_userid'],"visitor_cart_id"=>''), array("visitor_cart_id"=>session_id()))->affectedRows();
        }

        //$_SESSION["sess_guest_user_login_id"]=$userid;
    }


    if ($_POST['shippingmode'] != '') {
        $txtShippingMethod = $_POST['shippingmode'];
    }

    $_SESSION["sessShippingMethod"] = $txtShippingMethod;
    $message = "";

    if (!isset($_SESSION["sess_addresses_collected"]) or ($_SESSION["sess_addresses_collected"] == false )) {
                if (!isNotNull($txtBillingFirstName)) {
                    $message .= BILL_FIRST_NAME_EMPTY_MSG."<br>";
                }
                if (!isNotNull($txtBillingAddress1)) {
                    $message .= BILL_ADDR_LINE1_EMPTY_MSG."<br>";
                }
                if (!isNotNull($txtBillingCity)) {
                    $message .= BILL_CITY_EMPTY_MSG."<br>";
                }
                if (!isNotNull($txtBillingState)) {
                    $message .= BILL_STATE_EMPTY_MSG."<br>";
                }

                if (!isNotNull($ddlBillingCountry)) {
                    $message .= BILL_COUNTRY_EMPTY_MSG."<br>";
                }
                if (!isNotNull($txtBillingZIP)) {
                    $message .= BILL_ZIP_EMPTY_MSG."<br>";
                }
                if (!isNotNull($txtBillingEmail)) {
                    $message .= BILL_EMAIL_EMPTY_MSG."<br>";
                } else {
                    if (!isValidEmail($txtBillingEmail)) {
                        $message .= BILL_INVALID_EMAIL_TEXT."<br>";
                    }
                }
                if (!isNotNull($txtBillingPhone)) {
                    $message .= BILL_PHONE_EMPTY_MSG."<br>";
                }

                /* ---------Multicart 2.0 Upgradation------------------ */

                if ($sameshipping != 1 && $shipping_address_block_display == "") {

                    /* ---------Multicart 2.0 Upgradation------------------ */

                    if (!isNotNull($txtShippingFirstName)) {
                        $message .= SHIP_FIRST_NAME_EMPTY_MSG."<br>";
                    }
                    if (!isNotNull($txtShippingAddress1)) {
                        $message .= SHIP_ADDR_LINE1_EMPTY_MSG."<br>";
                    }
                    if (!isNotNull($txtShippingCity)) {
                        $message .= SHIP_CITY_EMPTY_MSG."<br>";
                    }
                    if ($_POST['ship_state'] == '' && $_POST['bill_state'] == '') {
                        $message .= SHIP_STATE_EMPTY_MSG."<br>";
                    }

                    if ($_POST['ship_state'] == '') {
                        if ($_POST['bill_state'] != '') {
                            $txtShippingState = $_POST['bill_state'];
                        }
                    }

                    if (!isNotNull($ddlShippingCountry)) {
                        $message .= SHIP_COUNTRY_EMPTY_MSG."<br>";
                    }
                    if (!isNotNull($txtShippingZIP)) {
                        $message .= SHIP_ZIP_EMPTY_MSG."<br>";
                    }
                    if (!isNotNull($txtShippingEmail)) {
                        $message .= SHIP_EMAIL_EMPTY_MSG."<br>";
                    } else {
                        if (!isValidEmail($txtShippingEmail)) {
                            $message .= SHIP_INVALID_EMAIL_TEXT."<br>";
                        }
                    }
                }
    }

    $quantitiesadjusted = adjustQuantities($userid);
    if ($quantitiesadjusted) {
        $message .= "<br>".LOW_STOCK_QUANTITIES_ADJUSTED;
    }

    if ($message != "") { // error
        $message = "<br>".CORRECT_ERRORS_TEXT."<br>" . $message;
    } else {

          $_SESSION["sessBillingFirstName"] = $txtBillingFirstName;
            $_SESSION["sessBillingLastName"] = $txtBillingLastName;
            $_SESSION["sessBillingAddress1"] = $txtBillingAddress1;
            $_SESSION["sessBillingAddress2"] = $txtBillingAddress2;
            $_SESSION["sessBillingCity"] = $txtBillingCity;
            $_SESSION["sessBillingState"] = $txtBillingState;
            $_SESSION["sessBillingZIP"] = $txtBillingZIP;

            $_SESSION["sessBillingPhone"] = $txtBillingPhone;
            $_SESSION["sessBillingEmail"] = $txtBillingEmail;
            $_SESSION["sessBillingCountry"] = $ddlBillingCountry;

            $_SESSION["sessShippingFirstName"] = $txtShippingFirstName;
            $_SESSION["sessShippingLastName"] = $txtShippingLastName;
            $_SESSION["sessShippingAddress1"] = $txtShippingAddress1;
            $_SESSION["sessShippingAddress2"] = $txtShippingAddress2;
            $_SESSION["sessShippingCity"] = $txtShippingCity;
            $_SESSION["sessShippingState"] = $txtShippingState;
            $_SESSION["sessShippingZIP"] = $txtShippingZIP;

            $_SESSION["sessShippingPhone"] = $txtShippingPhone;
            $_SESSION["sessShippingEmail"] = $txtShippingEmail;
            $_SESSION["sessShippingCountry"] = $ddlShippingCountry;


        if (isset($_SESSION['sess_userid']) && $_SESSION['guest_login'] != 1 && $userid != "") {
            $sql = "UPDATE " . $tableprefix . "users SET
			first_name = :first_name";
            $argArr['first_name'] = $txtBillingFirstName;
            if ($txtBillingLastName != ""){
                $sql .= ",last_name = :last_name";
                $argArr['last_name'] = $txtBillingLastName;
            }
            if ($txtBillingAddress1 != ""){
                $sql .= ",address1 = :address1";
                $argArr['address1'] = $txtBillingAddress1;
            }
            if ($txtBillingAddress2 != ""){
                $argArr['address2'] = $txtBillingAddress2;
                $sql .= ",address2 = :address2";
            }
            if ($txtBillingCity != ""){
                $argArr['city'] = $txtBillingCity;
                $sql .= ",city = :city";
            }
            if ($txtBillingState != ""){
                $sql .= ",state = :state";
                $argArr['state'] = $txtBillingState;
            }
            if ($ddlBillingCountry != ""){
                $sql .= ",country = :country";
                $argArr['country'] = $ddlBillingCountry;
            }
            if ($txtBillingPhone != ""){
                $sql .= ",phone = :phone";
                $argArr['phone'] = $txtBillingPhone;
            }

            if ($txtBillingZIP != ""){
                $argArr['zip'] = $txtBillingZIP;
                $sql .= ",zip = :zip";
            }
            if ($txtBillingEmail != ""){
                $argArr['email'] = $txtBillingEmail;
                $sql .= ",email = :email";
            }

            $sql .= " WHERE user_id =  :user_id";
            $argArr['user_id'] = $userid;

            $pdo->pdoQuery($sql,$argArr)->results();

        }

        if ($_SESSION["sess_addresses_collected"] == false) {
            $_SESSION["sessBillingFirstName"] = $txtBillingFirstName;
            $_SESSION["sessBillingLastName"] = $txtBillingLastName;
            $_SESSION["sessBillingAddress1"] = $txtBillingAddress1;
            $_SESSION["sessBillingAddress2"] = $txtBillingAddress2;
            $_SESSION["sessBillingCity"] = $txtBillingCity;
            $_SESSION["sessBillingState"] = $txtBillingState;
            $_SESSION["sessBillingZIP"] = $txtBillingZIP;

            $_SESSION["sessBillingPhone"] = $txtBillingPhone;
            $_SESSION["sessBillingEmail"] = $txtBillingEmail;
            $_SESSION["sessBillingCountry"] = $ddlBillingCountry;

            $_SESSION["sessShippingFirstName"] = $txtShippingFirstName;
            $_SESSION["sessShippingLastName"] = $txtShippingLastName;
            $_SESSION["sessShippingAddress1"] = $txtShippingAddress1;
            $_SESSION["sessShippingAddress2"] = $txtShippingAddress2;
            $_SESSION["sessShippingCity"] = $txtShippingCity;
            $_SESSION["sessShippingState"] = $txtShippingState;
            $_SESSION["sessShippingZIP"] = $txtShippingZIP;

            $_SESSION["sessShippingPhone"] = $txtShippingPhone;
            $_SESSION["sessShippingEmail"] = $txtShippingEmail;
            $_SESSION["sessShippingCountry"] = $ddlShippingCountry;

            $_SESSION["sess_addresses_collected"] = true;
        }


        if (!isset($_SESSION["sess_stock_adjusted"]) or ($_SESSION["sess_stock_adjusted"] == false )) {
            //$stockadjusted = adjustStock($userid,"-");
            $_SESSION["sess_stock_adjusted"] = true;
        }



        $select_cart_digital = "SELECT ct.cart_id
                                        FROM " . $tableprefix . "cart ct
                                        INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = ct.product_option_id
                                        INNER JOIN " . $tableprefix . "products prd ON prd.product_id = po.product_id
                                        WHERE ct.product_id = prd.product_id AND vdigital_product = 'Y' AND ct.user_id = :user_id" ;

        $result_cart_digital = $pdo->pdoQuery($select_cart_digital,array("user_id"=>$userid))->results();

        $select_cart_gift = "SELECT ct.cart_id
                                     FROM " . $tableprefix . "cart ct
                                     INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = ct.product_option_id
                                     INNER JOIN " . $tableprefix . "products prd ON prd.product_id = po.product_id
                                     INNER JOIN " . $tableprefix . "categories ctry ON prd.product_category = ctry.category_id
                                     AND ctry.gift_certificate_flag = 'Y'  AND ct.user_id = :user_id";
        $result_cart_gift = $pdo->pdoQuery($select_cart_gift,array("user_id"=>$userid))->results();

       $check_shipping_enable = checkShippingEnable();

        if ($check_shipping_enable == "Y" && $hide_shipping_division == 1) {
            $_SESSION["sessShippingMethod"] = $_POST['shippingmode'];
            //exit();
            $_SESSION['SESS_SHIPPING'] = 1;
            header("location: shipping_options.php");
            exit;
        } else {

            header("Location:paymentoptions.php");
            exit;
        }

    }
}

/* --------Multicart 2.0 Begins------------ */

if ($_SESSION["sess_userid"] != '') {
    $result_user_details =  $pdo->select($tableprefix."users",'',array("user_id"=>$_SESSION["sess_userid"]))->results();

    if (!empty($result_user_details)) {

        $user_details_row = $result_user_details[0];

        $txtBillingFirstName = $user_details_row['first_name'];
        $txtBillingLastName = $user_details_row['last_name'];
        $txtBillingAddress1 = $user_details_row['address1'];
        $txtBillingAddress2 = $user_details_row['address2'];
        $txtBillingCity = $user_details_row['city'];
        $txtBillingState = $user_details_row['state'];
        $txtBillingZIP = $user_details_row['zip'];

        $txtBillingPhone = $user_details_row['phone'];
        $txtBillingEmail = $user_details_row['email'];
        $ddlBillingCountry = $user_details_row['country'];
    }
}
if($_SESSION["sess_addresses_collected"]==true){

        $txtBillingFirstName = $_SESSION["sessBillingFirstName"];
        $txtBillingLastName = $_SESSION["sessBillingLastName"];
        $txtBillingAddress1 = $_SESSION["sessBillingAddress1"];
        $txtBillingAddress2 = $_SESSION["sessBillingAddress2"];
        $txtBillingCity = $_SESSION["sessBillingCity"];
        $txtBillingState = $_SESSION["sessBillingState"];
        $txtBillingZIP = $_SESSION["sessBillingZIP"];

        $txtBillingPhone = $_SESSION["sessBillingPhone"];
        $txtBillingEmail = $_SESSION["sessBillingEmail"];
        $ddlBillingCountry = $_SESSION["sessBillingCountry"];

        $txtShippingFirstName  = $_SESSION["sessShippingFirstName"];
        $txtShippingLastName   = $_SESSION["sessShippingLastName"];
        $txtShippingAddress1   = $_SESSION["sessShippingAddress1"];
        $txtShippingAddress2   = $_SESSION["sessShippingAddress2"];
        $txtShippingCity       = $_SESSION["sessShippingCity"];
        $txtShippingState      = $_SESSION["sessShippingState"];
        $txtShippingZIP        = $_SESSION["sessShippingZIP"];

        $txtShippingPhone      = $_SESSION["sessShippingPhone"];
        $txtShippingEmail      = $_SESSION["sessShippingEmail"];
        $ddlShippingCountry    = $_SESSION["sessShippingCountry"];
}





/* --------Multicart 2.0 Ends------------ */

$countrylist = makeCountryList();

/* display the active template */

$active_template = displayTemplate();
$adminCurrency = GetAdminCurrency();

$txtCurrency = $adminCurrency['currency_code'];
$deafultCountry = $currencyBasedCountries[$txtCurrency];

//***********************Multicart3.0 Addition***********************************************

//check digital products count in cart
 if($_SESSION["sess_userid"]!='')
     {
         $visitorId     =  '';
     }else{
         $visitorId     = generalMethods::sessionid();
     }

 $objDigitalCart                        =     Cart::getDigitalItemsCartCount($_SESSION["sess_userid"],$visitorId);
 if($objDigitalCart->status==SUCCESS)
 {
        $cartDigitalObjVal         =    $objDigitalCart->data;
        $cartDigitalCount          =    $cartDigitalObjVal['digitalcount'];
 }

//***********************Multicart3.0 Addition****************************************************

include "includes/htmltop.php";

/* Top File Name */

include_once ("includes/" . $active_template[0]);
?>
<script type="text/javascript">
    defaultCountryCode = '<?php echo $deafultCountry; ?>';
</script>
<script language="javascript" src="js/function.js"></script>
<script type="text/javascript" src="<?php echo SITE_URL ?>/js/blockUI.js"></script>
<script language="javascript">
$(document).ajaxStop($.unblockUI);

function validateEmail(email) {
  var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
  if( !emailReg.test(email ) ) {
    return false;
  } else {
    return true;
  }
}
    function ConfirmCheck()
    {

        var shipStatus = $(".clscheckbox:checked").length;

        var shippingOption = '<?php echo $hide_shipping_division; ?>';

        var shippingNeeded = '<?php echo $shippingSelection_Needed;?>';

        if($("#txtBillingFirstName").val()=='')
        {
            alert("<?php echo ALERT_FIRST_NAME_MSG; ?>");
            $('#txtBillingFirstName').focus();
            return false;
        }

        if($("#txtBillingAddress1").val()=='')
        {
            alert("<?php echo ALERT_ADDR_LINE1_MSG; ?>");
            $('#txtBillingAddress1').focus();
            return false;
        }

        if($("#txtBillingCity").val()=='')
        {
            alert("<?php echo ALERT_CITY_MSG; ?>");
            $('#txtBillingCity').focus();
            return false;
        }
        if($("#billCountrySelect").val()=='')
        {
            alert("<?php echo ALERT_STATE_MSG; ?>");
            $('#billCountrySelect').focus();
            return false;
        }

        if($("#billStateSelect").val()=='')
        {
            alert("<?php echo ALERT_COUNTRY_MSG; ?>");
            $('#billStateSelect').focus();
            return false;
        }

        if($("#txtBillingZIP").val()=='')
        {
            alert("<?php echo ALERT_ZIP_MSG; ?>");

            $('#txtBillingZIP').focus();
            return false;
        }

        var txtBillingEmail = $("#txtBillingEmail").val();
        if(txtBillingEmail=='')
        {
            alert("<?php echo ALERT_EMAIL_MSG; ?>");
            $('#txtBillingEmail').focus();
            return false;
        }

        if(txtBillingEmail!='')
        {
            if( !validateEmail(txtBillingEmail)){
	             alert("<?php echo ALERT_INVALID_BILLING_EMAIL_MSG; ?>");
                        $('#txtBillingEmail').focus();
                        return false;
	        }

        }

        if($("#txtBillingPhone").val()=='')
        {
            alert("<?php echo ALERT_PHONE_MSG; ?>");
            $('#txtBillingPhone').focus();
            return false;
        }

         if(shipStatus==0 && shippingOption==1){
            if($("#txtShippingFirstName").val()=='')
            {
                alert("<?php echo ALERT_FIRST_NAME_MSG_SHIP; ?>");
                $('#txtShippingFirstName').focus();
                return false;
            }

            if($("#txtShippingAddress1").val()=='')
            {
                alert("<?php echo ALERT_ADDR_LINE1_MSG_SHIP; ?>");
                $('#txtShippingAddress1').focus();
                return false;
            }

            if($("#txtShippingCity").val()=='')
            {
                alert("<?php echo ALERT_CITY_MSG_SHIP; ?>");
                $('#txtShippingCity').focus();
                return false;
            }

            if($("#shipCountrySelect").val()=='')
            {
                alert("<?php echo ALERT_STATE_MSG_SHIP; ?>");
                $('#shipCountrySelect').focus();
                return false;
            }


            if($("#shipStateSelect").val()=='')
            {
                alert("<?php echo ALERT_COUNTRY_MSG_SHIP; ?>");
                $('#shipStateSelect').focus();
                return false;
            }

            if($("#txtShippingZIP").val()=='')
            {
                alert("<?php echo ALERT_ZIP_MSG_SHIP; ?>");
                $('#txtShippingZIP').focus();
                return false;
            }
             var txtShippingEmail = $("#txtShippingEmail").val();
            if(txtShippingEmail=='')
            {
                alert("<?php echo ALERT_EMAIL_MSG_SHIP; ?>");
                $('#txtShippingEmail').focus();
                return false;
            }
            if($("#txtShippingPhone").val()=='')
            {
            alert("<?php echo ALERT_PHONE_MSG_SHP; ?>");
            $('#txtShippingPhone').focus();
            return false;
            }

            if(txtShippingEmail!='')
        {
                if( !validateEmail(txtShippingEmail)){
	             alert("<?php echo ALERT_INVALID_SHIPPING_EMAIL_MSG; ?>");
                        $('#txtShippingEmail').focus();
                        return false;
	        }

        }

            if(shippingNeeded=='1') {
                var strlen=$(".checkbox:checked").length;
                if(strlen==0)
                {
                    alert("<?php echo ALERT_SHIPPING_METHOD; ?>");
                    return false;
                }
                else
                {
                    $.blockUI({ message: null });
                    $("#btnConfirmOrder").prop('value', 'Loading.. Please wait..');
                    return true;
                }
            }
        }

        else
        {
            $.blockUI({ message: null });
            $("#btnConfirmOrder").prop('value', 'Loading.. Please wait..');
            document.getElementById("shipCountrySelect").disabled = false;
            document.getElementById("billCountrySelect").disabled = false;
            document.getElementById("shipStateSelect").disabled = false;
            document.getElementById("billStateSelect").disabled = false;
            return true;
        }
    }

/** Manu R S - 10/01/18 */
/** Process to check User with same email, if exists, proceed to add the products to the cart for the same user */
    function verifyEmail(flag){
        if(flag=='ship'){
            var email =$('#txtShippingEmail').val();
        }else{
        var email =$('#txtBillingEmail').val();
        }

        var guestflag= '<?php echo $_SESSION['guest_login']; ?>';
        if(email!='' && guestflag=='1' ){
            $.blockUI({ message: null });
            var postData = {email:email};
            $.ajax({url:'verifyemail.php',
                type:'post',
                dataType:'json',
                data:postData,
                success:function(reply)
                {
                    //console.log(reply);
                    if(reply.response=='exists')
                    {
                        var res = confirm("<?php echo USER_ADD_EXISTS_CART_CONFIRM; ?>");
                        if(res){
                            $.blockUI({ message: null });
                            //console.log(postData);
                            $.ajax({url:'verifyemailprocess.php',
                                type:'post',
                                dataType:'json',
                                data:postData,
                                success:function(reply)
                                {
                                    //console.log(reply);
                                    if(reply.response=='updated') {
                                        alert("<?php echo USER_ADD_EXISTS_CART_CONFIRM_MSG; ?>");
                                        window.location="login.php?action=viewcart";
                                        return true;
                                    } else if(reply.response=='failure') {
                                        $("#txtBillingEmail").val('');
                                        $("#txtBillingEmail").focus();
                                        return false;
                                    }
                                }
                            });
                        } else {
                            $("#txtBillingEmail").val('');
                            $("#txtBillingEmail").focus();
                            return false;
                        }
                    } else {
                        return true;
                    }
                }
            });
        }
    }
/** Process to check User with same email ends */

    function sameAsAbove(){
        var frm = document.frmCheckout;
        if(frm.chkSameAsAbove.checked==true){
           // document.getElementById("divShippingAddress").style.display = "none";
           // $("#txtShippingFirstName").val()  = $("#txtBillingFirstName").val();

            document.getElementById("txtShippingFirstName").value = document.getElementById("txtBillingFirstName").value;
            /*document.getElementById("txtShippingFirstName").disabled = true;
            document.getElementById("txtBillingFirstName").disabled = true;*/
            $("#txtShippingFirstName").prop("readonly",true);
            $("#txtBillingFirstName").prop("readonly",true);

            document.getElementById("txtShippingLastName").value   = document.getElementById("txtBillingLastName").value;
            /*document.getElementById("txtShippingLastName").disabled = true;
            document.getElementById("txtBillingLastName").disabled = true;*/
            $("#txtShippingLastName").prop("readonly",true);
            $("#txtBillingLastName").prop("readonly",true);

            document.getElementById("txtShippingAddress1").value   = document.getElementById("txtBillingAddress1").value;
            /*document.getElementById("txtShippingAddress1").disabled = true;
            document.getElementById("txtBillingAddress1").disabled = true;*/
            $("#txtShippingAddress1").prop("readonly",true);
            $("#txtBillingAddress1").prop("readonly",true);

            document.getElementById("txtShippingAddress2").value   = document.getElementById("txtBillingAddress2").value;
            /*document.getElementById("txtShippingAddress2").disabled = true;
            document.getElementById("txtBillingAddress2").disabled = true;*/
            $("#txtShippingAddress2").prop("readonly",true);
            $("#txtBillingAddress2").prop("readonly",true);

            document.getElementById("txtShippingCity").value       = document.getElementById("txtBillingCity").value;
            /*document.getElementById("txtShippingCity").disabled = true;
            document.getElementById("txtBillingCity").disabled = true;*/
            $("#txtShippingCity").prop("readonly",true);
            $("#txtBillingCity").prop("readonly",true);

            document.getElementById("txtShippingZIP").value        = document.getElementById("txtBillingZIP").value;
            /*document.getElementById("txtShippingZIP").disabled = true;
            document.getElementById("txtBillingZIP").disabled = true;*/
            $("#txtShippingZIP").prop("readonly",true);
            $("#txtBillingZIP").prop("readonly",true);

            document.getElementById("txtShippingPhone").value      = document.getElementById("txtBillingPhone").value;
            /*document.getElementById("txtShippingPhone").disabled = true;
            document.getElementById("txtBillingPhone").disabled = true;*/
            $("#txtShippingPhone").prop("readonly",true);
            $("#txtBillingPhone").prop("readonly",true);

            document.getElementById("txtShippingEmail").value      = document.getElementById("txtBillingEmail").value;
            /*document.getElementById("txtShippingEmail").disabled = true;
            document.getElementById("txtBillingEmail").disabled = true;*/
            $("#txtShippingEmail").prop("readonly",true);
            $("#txtBillingEmail").prop("readonly",true);

            if(document.getElementById("billCountrySelect").value!=document.getElementById("shipCountrySelect").value){
                document.getElementById("shipCountrySelect").value          = document.getElementById("billCountrySelect").value;
                document.getElementById("shipCountrySelect").disabled = true;
                document.getElementById("billCountrySelect").disabled = true;
                updateState('shipCountrySelect');
            }
            else{
                document.getElementById("shipCountrySelect").value = document.getElementById("billCountrySelect").value;
                document.getElementById("shipCountrySelect").disabled = true;
                document.getElementById("billCountrySelect").disabled = true;
            }

            document.getElementById("shipStateSelect").value       = document.getElementById("billStateSelect").value;
            document.getElementById("shipStateSelect").disabled = true;
            document.getElementById("billStateSelect").disabled = true;

        } else {
           // document.getElementById("divShippingAddress").style.display = "";
            document.getElementById("txtShippingFirstName").value   = '';
            /*document.getElementById("txtShippingFirstName").disabled = false;
            document.getElementById("txtBillingFirstName").disabled = false;*/
            $("#txtShippingFirstName").prop("readonly",false);
            $("#txtBillingFirstName").prop("readonly",false);
            document.getElementById("txtShippingLastName").value   = '';
            /*document.getElementById("txtShippingLastName").disabled = false;
            document.getElementById("txtBillingLastName").disabled = false;*/
            $("#txtShippingLastName").prop("readonly",false);
            $("#txtBillingLastName").prop("readonly",false);
            document.getElementById("txtShippingAddress1").value   = '';
            /*document.getElementById("txtShippingAddress1").disabled = false;
            document.getElementById("txtBillingAddress1").disabled = false;*/
            $("#txtShippingAddress1").prop("readonly",false);
            $("#txtBillingAddress1").prop("readonly",false);
            document.getElementById("txtShippingAddress2").value   = '';
            /*document.getElementById("txtShippingAddress2").disabled = false;
            document.getElementById("txtBillingAddress2").disabled = false;*/
            $("#txtShippingAddress2").prop("readonly",false);
            $("#txtBillingAddress2").prop("readonly",false);
            document.getElementById("txtShippingCity").value       = '';
            /*document.getElementById("txtShippingCity").disabled = false;
            document.getElementById("txtBillingCity").disabled = false;*/
            $("#txtShippingCity").prop("readonly",false);
            $("#txtBillingCity").prop("readonly",false);
            document.getElementById("txtShippingZIP").value        = '';
            /*document.getElementById("txtShippingZIP").disabled = false;
            document.getElementById("txtBillingZIP").disabled = false;*/
            $("#txtShippingZIP").prop("readonly",false);
            $("#txtBillingZIP").prop("readonly",false);
            document.getElementById("txtShippingPhone").value      = '';
            /*document.getElementById("txtShippingPhone").disabled = false;
            document.getElementById("txtBillingPhone").disabled = false;*/
            $("#txtShippingPhone").prop("readonly",false);
            $("#txtBillingPhone").prop("readonly",false);
            document.getElementById("txtShippingEmail").value      = '';
            /*document.getElementById("txtShippingEmail").disabled = false;
            document.getElementById("txtBillingEmail").disabled = false;*/
            $("#txtShippingEmail").prop("readonly",false);
            $("#txtBillingEmail").prop("readonly",false);
            //document.getElementById("ship_country").value          = '';
            document.getElementById("shipCountrySelect").disabled = false;
            document.getElementById("billCountrySelect").disabled = false;
            //document.getElementById("shipStateSelect").value       = '';
            document.getElementById("shipStateSelect").disabled = false;
            document.getElementById("billStateSelect").disabled = false;
        }
    }
    function checkSameAsAbove(same){
        var frm = document.frmCheckout;
        if(same == 1){
            sameAsAbove();
        }
    }
    function popupWindow(url) {
        window.open(url,'popupWindow','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=yes,copyhistory=no,width=1000,height=500,screenX=150,screenY=150,top=150,left=150')
    }
    function checkShipping()
    {
        if(document.frmCheckout.shippingEnable.value == "")
        {
            if(eval(document.frmCheckout.totalShippingWeight.value) > eval(document.frmCheckout.maxShippingWeight.value))
            {
                alert('<?php echo SHIPPING_WEIGHT_MSG; ?>');
                return false;
            }
        }
    }
    function Togglecheck()
    {
        var strlen=$(".checkbox:checked").length;
        if(strlen==0)
        {
            alert("<?php echo ALERT_SHIPPING_METHOD; ?>");
            return false;
        }
        else
        {
            return true;
        }
    }
</script>
<!--mainbody area start -->
<div class="main_body">
	<div class="container">
		<div class="row">
    <?php
    if ($ddlBillingCountry == '') {
        $ddlBillingCountry = $deafultCountry;
    }
    $enable_commentbox = getSettingsValue('enable_commentbox');
    ?>
    <form name="frmCheckout" action="<?php echo $_SERVER["PHP_SELF"] ?>" method="POST">
        <!-- The id of the country field(s).  If more than one, seperate with spaces -->
        <input type="hidden" value="shipCountrySelect billCountrySelect" name="cs_config_country_field" id="cs_config_country_field">
        <input type="hidden" value="shipStateSelect billStateSelect"     name="cs_config_state_field"   id="cs_config_state_field">
        <!-- The id of the the fields holding the default values.  If more than one, seperate with spaces -->
        <input type="hidden" value="shipCountryDefault billCountryDefault" name="cs_config_country_default" id="cs_config_country_default">
        <input type="hidden" value="shipStateDefault billStateDefault"     name="cs_config_state_default"   id="cs_config_state_default">
        <!-- The actual default values -->

        <input type="hidden" value="<?php echo $ddlShippingCountry ?>" name="shipCountryDefault" id="shipCountryDefault">
        <input type="hidden" value="<?php echo $txtShippingState; ?>"   name="shipStateDefault"   id="shipStateDefault">
        <input type="hidden" value="<?php echo $ddlBillingCountry ?>" name="billCountryDefault" id="billCountryDefault">
        <input type="hidden" value="<?php echo $txtBillingState; ?>"   name="billStateDefault"   id="billStateDefault">
        <SCRIPT type="text/javascript" SRC="js/country-state.js"></SCRIPT>
        <div align="left" id="item_details">
            <!--items display area start -->
			<section class="sec_marg">
			<div class="col-sm-12 col-lg-12 col-md-12 ">
				<h3><?php echo YOUR_CART_TEXT; ?></h3>
			</div>
			</section>
			<div class="clear"></div>
            <div class="warning" align="center"><?php echo $message ?></div>
            <?php if($cartDigitalCount>0) { ?>
            <div style="margin-left: 14px;"> <img src="<?php echo SITE_URL?>/images/digital_icon.png" alt="<?php echo DIGITAL_PRODUCT_FLAG;?>" title="<?php echo DIGITAL_PRODUCT_FLAG;?>"> &nbsp;&nbsp; <?php echo DIGITAL_PRODUCT_MARK_TEXT;?>
            <td colspan="3"><!--<img src="<?php echo SITE_URL?>/images/subscription_icon.jpg" alt="<?php echo SUBSCRIPTION_PRODUCT_FLAG;?>" title="<?php echo SUBSCRIPTION_PRODUCT_FLAG;?>"> &nbsp;&nbsp; <?php echo SUBSCRIPTION_PRODUCT_MARK_TEXT;?>--></td>
            </div>
            <?php } ?>

            <div class="col-sm-12 col-lg-12 col-md-12 ">
                <?php

                /* ------------Multicart 2.0 Upgradation------------ */
                $currency_attributes = displayCurrencyType();
                /* ------------Multicart 2.0 Upgradation------------ */

                $total = 0;
                $cartitems = "";
                $total_shipping_weight = 0;

                if ($_SESSION["sess_userid"] != '') {
                    $sql = "SELECT c.*, p.product_id,p.product_name,(p.product_price+po.additional_price) AS product_price,p.product_artist_id, gm.ngift_id,po.discount,po.product_shipping_weight,p.vdigital_product,p.allow_free_shipping
			  FROM " . $tableprefix . "cart c
                          INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
                          INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
                          LEFT JOIN " . $tableprefix . "giftcoupon_master gm ON gm.ngift_product_id=c.product_id
		          WHERE  c.user_id = :user_id";
                    $wreArr = array("user_id"=>$_SESSION["sess_userid"]);
                } else {

                    $sql = "SELECT c.*, p.product_id,p.product_name,(p.product_price+po.additional_price) AS product_price,p.product_artist_id, gm.ngift_id,po.discount,po.product_shipping_weight,p.vdigital_product,p.allow_free_shipping
                          FROM " . $tableprefix . "cart c
                          INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = c.product_option_id
                          INNER JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
                          LEFT JOIN " . $tableprefix . "giftcoupon_master gm ON gm.ngift_product_id=c.product_id
                          WHERE c.visitor_cart_id = :visitor_cart_id";
                            $wreArr = array("visitor_cart_id"=>session_id());
                }


                $cnt = 1;
                $res =$pdo->pdoQuery($sql,$wreArr)->results();

                ///////////////////////////////////////////////////////////////////////////////////////






                $combo_items=array();
$combo_crt_id_map='';
//print_r($res);exit;
foreach ($res as $index=>$prd) {
    if($prd['combo_id']!='')
    {
        $combo_items[$prd['combo_id']]['prd_name'][$prd['product_option_id']]=$prd['product_name'];
        $combo_items[$prd['combo_id']]['prd_qty'][$prd['product_option_id']]=$prd['quantity'];
       $selectCase = array("product_id" => $prd['product_id'],"product_option_id"=>$prd['product_option_id'],"combo_id"=>$prd['combo_id']);
            $result = $pdo->select($tableprefix . "combo_products", "product_quantity", $selectCase)->results();
            $combo_quantity=$prd['quantity']/$result[0]["product_quantity"];
            $combo_items[$prd['combo_id']]['quantity']=$combo_quantity;
             if(isset($combo_items[$prd['combo_id']]['productoptionids']))
            {
                $combo_items[$prd['combo_id']]['productoptionids'].="," .$prd['product_option_id'];
            }
            else {
                $combo_items[$prd['combo_id']]['productoptionids']=$prd['product_option_id'];
            }

            if(isset($combo_items[$prd['combo_id']]['cartids']))
            {
                $combo_items[$prd['combo_id']]['cartids'].="," .$prd['cart_id'];
            }
            else {
                $combo_items[$prd['combo_id']]['cartids']=$prd['cart_id'];
            }
    }
}



$combo_details=array();
foreach($combo_items as $index=>$combos)
{

   $combo_details[$index] =  ComboPack::get_combo_details($index);
   $combo_details[$index]['required_quantity']=$combo_items[$index]['quantity'];
}

                ////////////////////////////////////////////////////////////////////////////////////////


                if (!empty($res)) {
                    echo "<div class=\"table-responsive\">";
                    echo "<table width=\"100%\"  border=\"0\" cellspacing=\"1\" class=\"table table-bordered\" cellpadding=\"6\">";
                    echo "<tr class='shopcart_heads'><td width='1%'>&nbsp;</td><td width='49%'>".PRODUCT_TEXT."</td>
					<td width='5%' align='right'>".QUANTITY_TEXT."</td>
					";

                    echo "<td width='5%'>";

                    if ($check_shipping_enable == "Y" && $shipping_block_display != "none") {
                        echo " ".WEIGHT_TEXT." ";
                    } else {
                        echo " &nbsp; ";
                    }

                    echo "</td>";

                    echo "
					<td width='30%' align='right'>".RATE_TEXT."</td>
					<td width='10%' align='right'>".PRICE_TEXT."</td>
				</tr>";
                    foreach ($res as $rw) {
                        $row_style=($rw['combo_id']!='')?'display:none':'';
                        $productname = generalMethods::html_entity($rw["product_name"]);
                        //$product_id  = $rw["product_id"];

                        $giftId = $rw["ngift_id"];

                        if (!empty($giftId)) {
                            $giftflag = "true";
                        } else {

                            $giftflag = "false";
                        }

                        /* ------------Multicart 2.0 Upgradation------------ */



                        $conversionRate = ConvertedCurrencyRate($currency_attributes[2]);
                        $converted_price = $rw['product_price'] * $conversionRate;

                        $rate = $converted_price;
                        /* ------------Multicart 2.0 Upgradation------------ */
                        $product_option_id = $rw["product_option_id"];
                        $qty = $rw["quantity"];
                        $price = $qty * $rate;
                        $product_weight = $qty * $rw["product_shipping_weight"];
                        $discountstr = "";
                        if ($rw["discount"] != "0") {
                            $price = number_format($price, 2, ".", "");
                            $discountprice = $rate - ($rate * $rw["discount"]) / 100;
                            $discountprice = number_format($discountprice, 2, ".", "");
                            $discountrate = ($discountprice * $qty);
                            $price = $discountrate;
                            $discountstr = "<br>".strtolower(DISCOUNT_TEXT)."(" . $rw["discount"] . "%)";
                        }
                        $optionsStr = "";
                        $optionVal = getProductOptionsName($product_option_id);
                        if ($optionVal != "") {
                            $optionsStr = "<br>" . $optionVal;
                        }
                        if($rw['combo_id']==''){
                        $total += $price;

                  }





                        //*************Multicart3.0 Additions Check  Free Ship Settings , cart item is digital product or not
                         if($rw['vdigital_product']=='Y' || $rw['allow_free_shipping']=='Y')
                        {
                             $product_weight        =   0;

                        }

                        $total_shipping_weight += $product_weight;

                        $objRow     =   Cart::isDigitalIteminCart($rw['cart_id']);
                        if($objRow->status==SUCCESS)
                        {
                            $digitalFlag  = $objRow->data;
                        }
                        //*************Multicart3.0 Additions Check cart item is subscription product or not

                        $objSubRow     =   Cart::isSubscriptionIteminCart($rw['cart_id']);

                        if($objSubRow->status==SUCCESS)
                        {
                            $subscriptionFlag  = $objSubRow->data;
                        }

                        // Free ship text display

                        $freeship_flag_text    =   Products::check_free_ship_product_text($rw["product_id"]);

                         //*************Multicart3.0 Additions End ***************************************************
          if($rw['combo_id']=='')
                     {
                        echo "<tr class=\"whitebg\" style=".$row_style."><td width='5%' >" . $cnt . "</td>
				<td align='left' style='word-break:break-all;'>";

                        if($digitalFlag=='Y')
                        {
                            echo '<img src='.SITE_URL.'/images/digital_icon.png alt="'.DIGITAL_PRODUCT_FLAG.'" title="'.DIGITAL_PRODUCT_FLAG.'">&nbsp;';
                        }/*elseif($subscriptionFlag=='Y'){
                            echo '<img src='.SITE_URL.'/images/subscription_icon.jpg alt="'.SUBSCRIPTION_PRODUCT_FLAG.'" title="'.SUBSCRIPTION_PRODUCT_FLAG.'">&nbsp;';
                        }*/
                        echo $productname . $discountstr . $optionsStr . " <span class='freeship_text'> ".$freeship_flag_text." </span></td>";
                        echo "<td align='right'>" . $qty . "</td>";
                        echo "<td align='right'>";
                        if ($check_shipping_enable == "Y" && $shipping_block_display != "none") {
                            echo "" . $product_weight . "";
                        } else {
                            echo "&nbsp;";
                        }
                        echo "</td>";
                        echo "
				<td align='right' width='30%'>";

                        if ($rw["discount"] != "0") {
                            echo $currency_attributes[0] . "&nbsp;" . $discountprice . "&nbsp;";

                            echo " ( <strike>" . $currency_attributes[0] . "&nbsp;" . number_format($rate, 2, ".", "") . "&nbsp;" . "</strike> ) ";
                        } else {
                            echo $currency_attributes[0] . "&nbsp;" . number_format($rate, 2, ".", "") . "&nbsp;";
                        }


                        echo "<td align='right' class=\"\">" . $currency_attributes[0] . "&nbsp;" . number_format($price, 2, ".", "") . "</td></tr>";
                        $cartitems .= "," . $rw["cart_id"];

                        $cnt++;

                    }
                    }
                    $cartitems = substr($cartitems, 1);





                    //////////////////////////////////////////////////////////////////////////////////////////////

                    $cartcombo_items ='';
                    foreach ($combo_details as $combo) {

                     $cartcombo_items .= "," . $combo["combo_id"];
                                   $cntt++;
                                   $price=$combo["price"];
                                   $combo_products='';
                                    foreach ($combo_items[$combo["combo_id"]]['prd_name'] as $index=>$prd_name) {
                                       $combo_products.='<div class="col-xs-9 col-md-8">'.$prd_name.' <i>-'.$combo_items[$combo["combo_id"]]['prd_qty'][$index].' Item</i></div>';
                                   }


                                   $check = "<input type='checkbox' class='checkbox combo' name='chkcomboitems[]' value='" . $combo["combo_id"] . "' > ";
                                   $qtytextbox = "<input type='text' id='txtQuantity_combo_" . $cntt . "' name='txtQuantity_combo_" . $combo["combo_id"] . "' value='" . $combo["required_quantity"] . "' size='1' maxlength='3' class='textbox qty_txtbox'> ";
                                   $combo_cart_map="<input type='hidden' id='txt_combo_cart_map_" . $cntt . "' name='txt_combo_cart_map_" . $combo["combo_id"] . "' value='" . $combo_items[$combo["combo_id"]]['cartids'] . "' size='1' maxlength='3' class='textbox combo_cart_txtbox'> ";
                                   $combo_products_map="<input type='hidden' id='txt_combo_products_map_" . $cntt . "' name='txt_combo_products_map_" . $combo["combo_id"] . "' value='" . $combo_items[$combo["combo_id"]]['productoptionids'] . "' size='1' maxlength='3' class='textbox combo_products_txtbox'> ";

                                   $digitalFlag='N';
                                    $discountstr='';
                                    $optionsStr='';
                                    $productname=$combo["combo_name"];
                                     $conversionRate = ConvertedCurrencyRate($currency_attributes[2]);
                        $converted_price = $combo["required_quantity"]*$price * $conversionRate;

                        $rate = $converted_price;
                        $freeship_flag_text='';
                         $total += $converted_price;


                                   if($activated_seller_id==$combo['seller_id'])
                                    {
                                         $flag_single_account_flag_class   =   'tr_bg_warning';
                                    }
                                    else{
                                        $flag_single_account_flag_class   =   '';
                                    }



                        $product_weight = $combo["required_quantity"] * ComboPack::get_combo_weight($combo["combo_id"]);

                        $total_shipping_weight += $product_weight;


                        echo "<tr class=\"whitebg\"><td width='5%' >" . $cnt . "</td>
				<td align='left' style='word-break:break-all;'>";

                        echo $productname . $discountstr . $optionsStr . " <span class='freeship_text'> ".$freeship_flag_text." </span>";
                        echo  '<div class="clearfix"></div>';
                        echo '<div class="row">'.$combo_products.'</div>';
                        echo "</td>";
                        echo "<td align='right'>" . $qty . "</td>";
                        echo "<td align='right'>";
                            echo "" . $product_weight . "";
                        echo "</td>";
                        echo "
				<td align='right' width='30%'>";

                            echo $currency_attributes[0] . "&nbsp;" . number_format($price, 2, ".", "") . "&nbsp;";
                        echo "<td align='right' class=\"\">" . $currency_attributes[0] . "&nbsp;" . number_format($rate, 2, ".", "") . "</td></tr>";
                        $cnt++;

                    }


                      $_SESSION['SESS_shipping_weight'] = number_format($total_shipping_weight, 2, ".", "");

                    $_SESSION['SESS_shipping_maxweight'] = $shipping_row['vvalue'];


                    echo "<tr class=\"whitebg\">
					<td align='right' colspan='6' class=\"prodtotal_td\"><b><span class='product_amounthd'>" . $currency_attributes[0] . "&nbsp;" . number_format($total, 2, ".", "") . "</span> <span class='product_amounthd'>".PRODUCT_TOTAL_TEXT."&nbsp;:&nbsp;</span> </b></td>
				</tr>";

        echo "<input type='hidden' value='" . $cartcombo_items . "' name='cartcombo_items' >&nbsp;&nbsp;";
                    echo "<input type='hidden' value='" . $cartitems . "' name='cartitems' >&nbsp;&nbsp;";
                    echo "</td></tr>";
                } else {
                    echo "<table width=\"100%\"  border=\"0\" cellspacing=\"1\" cellpadding=\"6\">";
                    echo "<tr><td width='100%' align='center'>".CART_EMPTY_MSG."</td></tr>";
                    echo "<tr><td width='100%' ><input class='button' type='button' value='Continue Shopping' onClick='window.location.href=\"categorydetail.php\"'></td></tr>";
                }
                ?>
                </table>

                </div>
            </td>
                </tr>

                </table>

                </td>
                </tr>
                <?php /*if (!isset($_SESSION["sess_addresses_collected"]) or ($_SESSION["sess_addresses_collected"] == false )) {*/ ?>
                <tr>
                    <td colspan="3">


				<div class="form_wrapper">
				<div class="register_form_outer">
					<div class="col-sm-12 col-lg-6 col-md-6 ship_border no_border">
					<div class="bill_form_marg">
					<div class="registrationform_container">
						<h3><?php echo BILL_ADDR_TEXT; ?></h3>
						<div class="field_wrapper formfield_row">
						 	&nbsp;
						 </div>
						<div class="field_wrapper formfield_row">
							<label><?php echo FIRST_NAME_TEXT; ?>&nbsp;<span class="required">*</span></label>
							<input type="text" name="txtBillingFirstName" value="<?php echo $txtBillingFirstName; ?>"  class="form-control" size="40" maxlength="100" id="txtBillingFirstName">
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo LAST_NAME_TEXT; ?></label>
							<input type="text" name="txtBillingLastName" value="<?php echo $txtBillingLastName; ?>" size="40" maxlength="100" class="form-control" id="txtBillingLastName" >
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo ADDR_LINE1_TEXT; ?>&nbsp;<span class="required">*</span></label>
							<input type="text" name="txtBillingAddress1" value="<?php echo $txtBillingAddress1; ?>" size="40" class="form-control"  maxlength="100" id="txtBillingAddress1">
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo ADDR_LINE2_TEXT; ?></label>
							<input type="text" name="txtBillingAddress2" value="<?php echo $txtBillingAddress2; ?>" size="40" maxlength="100" class="form-control" id="txtBillingAddress2">
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo CITY_TEXT; ?>&nbsp;<span class="required">*</span></label>
							<input type="text" name="txtBillingCity" value="<?php echo $txtBillingCity; ?>" size="40" class="form-control"  maxlength="100" id="txtBillingCity">
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo COUNTRY_TEXT; ?>&nbsp;<span class="required">*</span></label>
							<select id='billCountrySelect' name='bill_country' onchange='updateState(this.id)' class="form-control">
							</select>
							<SCRIPT  type="text/javascript">initCountry(); </SCRIPT>
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo STATE_LABEL; ?><span class="required">*</span></label>
							<select id='billStateSelect' name='bill_state' class="form-control">
                            </select>
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo ZIP_TEXT; ?>&nbsp;<span class="required">*</span></label>
							<input type="text" name="txtBillingZIP" value="<?php echo $txtBillingZIP; ?>" size="10" maxlength="20" class="form-control" id="txtBillingZIP">
						</div>

						<div class="field_wrapper formfield_row">
							<label><?php echo EMAIL_LABEL; ?>&nbsp;<span class="required">*</span></label>
							<input type="text"  class="form-control" name="txtBillingEmail" value="<?php echo $txtBillingEmail; ?>" size="30" maxlength="100" id="txtBillingEmail" onblur="return verifyEmail();">
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo PHONE_TEXT; ?><span class="required">*</span></label>
							<input type="text" name="txtBillingPhone"  class="form-control" value="<?php echo $txtBillingPhone; ?>" size="20" maxlength="30" id="txtBillingPhone">
						</div>
						<div class="clear"></div>
					</div>
					<div class="clear"></div>
					</div>
			</div>
			<div class="col-sm-12 col-lg-6 col-md-6 ship_border">
				<div class="ship_form_marg">
					<div class="registrationform_container">
						<?php
                            if ($hide_shipping_division == 1) {
                                ?>
						<h3><?php echo SHIP_ADDR_TEXT; ?></h3>
						 <?php } ?>
						 <div id="shipping_address_block" style="display:<?php echo $shipping_address_block_display ?>">
						 <div class="field_wrapper formfield_row">
						 	<input type="checkbox" name="chkSameAsAbove" class="clscheckbox" onClick="sameAsAbove();" <?php
									if ($sameshipping == 1) {
										echo " CHECKED ";
									}
																				 ?>>&nbsp;<?php echo SAME_AS_ABOVE_TEXT; ?>
						 </div>
						 <div id="divShippingAddress">
						<div class="field_wrapper formfield_row">
							<label><?php echo FIRST_NAME_TEXT; ?>&nbsp;<span class="required">*</span></label>
							<input  class="form-control" type="text" name="txtShippingFirstName" value="<?php echo $txtShippingFirstName; ?>" size="40" maxlength="100" id="txtShippingFirstName">
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo LAST_NAME_TEXT; ?></label>
							<input  class="form-control" type="text" name="txtShippingLastName" value="<?php echo $txtShippingLastName; ?>" size="40" maxlength="100" id="txtShippingLastName">
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo ADDR_LINE1_TEXT; ?>&nbsp;<span class="required">*</span></label>
							<input type="text"  class="form-control" name="txtShippingAddress1" value="<?php echo htmlentities($txtShippingAddress1); ?>" size="40" maxlength="100" id="txtShippingAddress1">
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo ADDR_LINE2_TEXT; ?></label>
							<input class="form-control" type="text" name="txtShippingAddress2" value="<?php echo htmlentities($txtShippingAddress2); ?>" size="40" maxlength="100" id="txtShippingAddress2">
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo CITY_TEXT; ?>&nbsp;<span class="required">*</span></label>
							<input  class="form-control" type="text" name="txtShippingCity" value="<?php echo htmlentities($txtShippingCity); ?>" size="40" maxlength="100" id="txtShippingCity">
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo COUNTRY_TEXT; ?>&nbsp;<span class="required">*</span></label>
							<select id='shipCountrySelect' name='ship_country' onchange='updateState(this.id)' class="form-control">
                                                            </select>
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo STATE_LABEL; ?><span class="required">*</span></label>
							<select id='shipStateSelect' name='ship_state' class="form-control">
                                                            </select>
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo ZIP_TEXT; ?>&nbsp;<span class="required">*</span></label>
							<input type="text" name="txtShippingZIP"  class="form-control" value="<?php echo $txtShippingZIP; ?>" size="10" maxlength="20" id="txtShippingZIP">
						</div>

						<div class="field_wrapper formfield_row">
							<label><?php echo EMAIL_LABEL; ?>&nbsp;<span class="required">*</span></label>
							<input  class="form-control" type="text" name="txtShippingEmail" value="<?php echo $txtShippingEmail; ?>" size="30" maxlength="100" id="txtShippingEmail" onblur="return verifyEmail('ship');">
						</div>
						<div class="field_wrapper formfield_row">
							<label><?php echo PHONE_TEXT; ?><span class="required">*</span></label>
							<input type="text" name="txtShippingPhone" class="form-control"  value="<?php echo $txtShippingPhone; ?>" size="20" maxlength="30" id="txtShippingPhone">
						</div>
						</div>
						<div class="clear"></div>
						<input type="hidden" name="guest_login" value="<?php echo $guest_login; ?>">
						</div>

					</div>
					</div>
					<div class="clear"></div>
			</div>
			<div class="clear"></div>
		</div>
		</div>
		<div class="clear"></div>







                    </td>
                </tr>


                <SCRIPT  type="text/javascript">initCountry(); </SCRIPT>

                    <?php
              //  }
                if ($giftflag == "true") {
                    $shipping_block_display = "none";
                }
                ?>

                <tr>
                    <td colspan="3">

                        <?php
                         $hide_shipping_meth_division =  Cart::checkShippingRequired($_SESSION["sess_userid"],$visitorId,$total);
                         if ($_SESSION['shipping_enabled'] == "false") {

                            $shipping_block_display = "none";
                            ?>
                        <?php if($hide_shipping_meth_division!=0){ ?>
                        <table cellpadding="4" cellspacing="4" border="0" width="100%">
                            <tr><td>&nbsp;</td></tr>
                            <tr>
                                <td class="text_information" colspan="2"><h4><?php echo SHIP_METHODS_NOT_AVAILABLE_TEXT; ?></h4></td>
                            </tr>
                            <tr><td>&nbsp;</td></tr>
                        </table>
                        <?php } ?>
                            <?php } ?>

                        <?php

                       if($hide_shipping_meth_division == 0){
                            $shipping_block_display = "none";
                            ?>
                        <table cellpadding="4" cellspacing="4" border="0" width="100%">
                            <tr><td>&nbsp;</td></tr>
                            <tr>
                                <td class="text_information" colspan="2"><h4><?php echo ALL_PRODUCTS_IN_CART_HAVE_FREE_SHIPPING_TEXT; ?></h4></td>
                            </tr>
                            <tr><td>&nbsp;</td></tr>
                        </table>
                            <?php } ?>

                        <div id="shipping_block" style="display:<?php echo $shipping_block_display ?>">


                                <!--Shipping Block Division Starts-->
                                <legend><b><?php echo SHIP_METHODS_TEXT; ?></b></legend>


                                <div class="shippingmthd">

                                    <?php
                                    if ($_POST['shippingmode'] != '') {
                                        $shippingmode = $_POST['shippingmode'];
                                    } else if ($_SESSION["sessShippingMethod"] != '') {
                                        $shippingmode = $_SESSION["sessShippingMethod"];
                                    } else {
                                        if ($upsmode == 'Y') {
                                            $shippingmode = 'UPS';
                                        } elseif ($uspsmode == 'Y') {
                                            $shippingmode = 'USPS';
                                        } elseif ($canadapost == 'Y') {
                                            $shippingmode = 'CP';
                                        }elseif ($australiapost == 'Y') {
                                            $shippingmode = 'AP';
                                        }else {
                                            $shippingmode = 'Flat Rate';
                                        }

                                        if ($txtCurrency == 'AUD') {
                                            $shippingmode = 'AP';
                                        }
                                    }
                                    ?>

                                    <div class="row">
                                        <?php if ($upsmode != "N" && $txtCurrency != 'AUD') {
                                            ?>
                                        <div class="col-xs-12 col-sm-4 col-md-4">
                                            <input type="radio" name="shippingmode" value="<?php echo "UPS"; ?>" <?php
                                            if ($shippingmode == 'UPS') {
                                                echo "checked";
                                            }
                                                   ?> class="checkbox pull-left"><?php echo UPS_TEXT; ?>
                                        </div>
                                        <div class="col-xs-12 col-sm-8 col-md-8">
                                            <img src="images/ups.gif" >
                                        </div>
                                        <div class="clearfix">&nbsp;</div>

                                        <?php } ?>

                                        <?php
                                        if ($fedexmode != "N" && $txtCurrency != 'AUD') {
                                            ?>
                                        <div class="col-xs-12 col-sm-4 col-md-4">
                                            <input type="radio" name="shippingmode" value="FDXG" <?php
                                                    if ($shippingmode == $fedexmode) {
                                                        echo "checked";
                                            }
                                                               ?> class="checkbox  pull-left"><?php echo $fedexShipping; ?>
                                        </div>
                                        <div class="col-xs-12 col-sm-8 col-md-8">
                                            <img src="images/fedex.gif" width="113" height="31">
                                        </div>
                                        <div class="clearfix">&nbsp;</div>
                                        <?php } ?>
                                        <?php if ($uspsmode == "Y" && $txtCurrency != 'AUD') {
                                            ?>

                                        <div class="col-xs-12 col-sm-4 col-md-4">
                                            <input type="radio" name="shippingmode" value="<?php echo "USPS"; ?>" <?php
                                            if ($shippingmode == 'USPS') {
                                                echo "checked";
                                            }
                                                   ?> class="checkbox  pull-left"><?php echo USPS_TEXT; ?>
                                        </div>
                                        <div class="col-xs-12 col-sm-8 col-md-8">
                                            <img src="images/usps.gif">
                                        </div>
                                        <div class="clearfix">&nbsp;</div>
                                        <?php } ?>

                                        <?php if ($canadapost == "Y" && $txtCurrency != 'AUD') {
                                            ?>
                                        <div class="col-xs-12 col-sm-4 col-md-4">
                                            <input type="radio" name="shippingmode" value="<?php echo "CP"; ?>" <?php
                                                if ($shippingmode == 'CP') {
                                                    echo "checked";
                                                }
                                                       ?> class="checkbox  pull-left"><?php echo CANADA_POST_TEXT; ?>
                                        </div>
                                        <div class="col-xs-12 col-sm-8 col-md-8">
                                            <img src="images/canadapost.gif">
                                        </div>
                                        <div class="clearfix">&nbsp;</div>
                                        <?php } ?>

                                        <?php if ($australiapost == "Y") {
                                            ?>

                                        <div class="col-xs-12 col-sm-4 col-md-4">
                                            <input type="radio" name="shippingmode" value="<?php echo "AP"; ?>" <?php
                                                    if ($shippingmode == 'AP') {
                                                        echo "checked";
                                                    }
                                                           ?> class="checkbox  pull-left"><?php echo AUSTRALIA_POST_TEXT; ?>
                                        </div>
                                        <div class="col-xs-12 col-sm-8 col-md-8">
                                            <img src="images/australiapost.jpg">
                                        </div>
                                        <div class="clearfix">&nbsp;</div>
                                        <?php } ?>

                                        <?php if ($flatrate == "Y") {
                                            ?>



                                        <div class="col-xs-12 col-sm-4 col-md-4">
                                            <input type="radio" name="shippingmode" value="<?php echo "Flat Rate"; ?>" <?php
                                                    if ($shippingmode == 'Flat Rate') {
                                                        echo "checked";
                                                    }
                                                           ?> class="checkbox  pull-left"><?php echo $flatrate_name; ?>
                                        </div>
                                        <div class="col-xs-12 col-sm-8 col-md-8">&nbsp;</div>
                                        <div class="clearfix">&nbsp;</div>
                                        <?php } ?>
                                    </div>

                                </div>
                        </div>

                        <!--Shipping Block Division Ends-->

                    </td>
                </tr>

                <tr>


                    <?php if ($enable_commentbox == 'Y' && $giftflag == "false") { ?>

                <tr><td colspan="3">
                        <div class="billaddres">


                                <div class="col-xs-12 col-sm-4 col-md-4">
                                    <?php echo ENTER_COMMENTS_TEXT;?>
                                </div>
                                <div class="col-xs-12 col-sm-8 col-md-8">
                                    <textarea name="txtComments" rows="5" class="form-control"><?php echo stripslashes($_POST['txtComments']); ?></textarea>
                                </div>

                            <div class="clearfix"></div>


                        </div>
                    </td> </tr>

                    <?php } ?>

                </table>

                <div align="center"><input type='submit' class="button" value='<?php echo CONFIRM_ORDER_BUTTON; ?>' name='btnConfirmOrder' id="btnConfirmOrder" onClick="return ConfirmCheck();"></div>

            </div>


            <div align="left" class="float_clear1"></div>


            <!--items display area end -->
        </div>

    </form>
    <!--center content area end-->


    <div align="left" class="clear"></div>
	</div>
    <!--mainbody area end -->
	</div>
</div>
<div align="left" class="clear"></div>


<?php
include "includes/" . $active_template[2]; /* Bottom File Name */
?>
