<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
class ComboPack
{
    
    /// get all combo packs
    public static function get_all_combos()
    {
        global $tableprefix, $pdo;
            $QueryCombos = "SELECT * 
                FROM " . $tableprefix . "combo";
            $resSet = $pdo->pdoQuery($QueryCombos)->results();
         return $resSet;
        
    }
    
    
     /// get combo avaialable quantity
    
    public static function get_available_combo_quantity($combo_id)
    {
        global $tableprefix, $pdo;
        $combo_available=0;
        $combo_quantity=self::get_combo_details($combo_id);
        $combo_quantity=$combo_quantity['quantity'];
        $combo_products=self::get_combo_products($combo_id);        
        foreach ($combo_products as $products) {
            $products_per_combo=$products['product_quantity'];
             $whereConditions = array('product_option_id' => $products['product_option_id']);
            $result = $pdo->select($tableprefix . 'product_options', array('product_stock'), $whereConditions)->results();
            $products_in_stock=$result[0]['product_stock'];
            $combo_available_for_product=((int)$products_in_stock/(int)$products_per_combo);
            if($combo_available_for_product<1)
            {
                $combo_available=$combo_available_for_product;
                break;
            }
            
           if(($combo_available_for_product<=$combo_available) || ($combo_available ==0))
           {
               $combo_available=$combo_available_for_product;
           }
            
        }
        return ($combo_available<=$combo_quantity)?$combo_available:$combo_quantity;
        
        
    }
    
    

    
    
    /// check product in stock
    
    public static function check_combo_items_available_in_stock($combo_id,$combo_quantity=1)
    {
        global $tableprefix, $pdo;
        $combo_products=self::get_combo_products($combo_id);
//        print_r($combo_products);exit;
        $combo_available=1;
        foreach ($combo_products as $products) {
            $products_requested=$combo_quantity*$products['product_quantity'];
             $whereConditions = array('product_option_id' => $products['product_option_id']);
            $result = $pdo->select($tableprefix . 'product_options', array('product_stock'), $whereConditions)->results();
            $products_available=$result[0];
            
            if($products_available<$products_requested)
            {
                $combo_available=false;
                break;
            }
            
        }
        return $combo_available;
        
        
    }
    
    
    
    /// get combo details
     public static function get_combo_details($combo_id)
    {
        global $tableprefix, $pdo; 
        $combo_details=array();
        if (!empty($combo_id)) {
            $whereConditions = array('combo_id' => $combo_id);
            $result = $pdo->select($tableprefix . 'combo', array('*'), $whereConditions)->results();
            if (!empty($result[0])) {
              $combo_details=$result[0];
            } 
        }
        return $combo_details;
        
    }
    
    /// validate if requested number of products is available
    public static function validate_stock_availablity($combo_id,$requested_quantitiy)
    {
        global $tableprefix, $pdo; 
        $status=false;
        if (!empty($combo_id)) {
            $whereConditions = array('combo_id' => $combo_id);
            $result = $pdo->select($tableprefix . 'combo', array('quantity'), $whereConditions)->results();
            if (!empty($result[0]) && ($result[0]['quantity']>=$requested_quantitiy)) {
               $status=1;
            } 
        }
        return $status;
        
    }
    
    //// get all products in combo pack
    public static function get_combo_products($combo_id)
    {
         global $tableprefix, $pdo;
         $resSet=array();
         if (!empty($combo_id)) {
            $QueryComboProducts = "SELECT p.product_id,po.product_option_id,p.product_name,p.product_artist_id,cp.product_quantity 
                FROM " . $tableprefix . "combo_products cp
                LEFT JOIN " . $tableprefix . "product_options po ON po.product_option_id = cp.product_option_id
                LEFT JOIN " . $tableprefix . "products p ON p.product_id = po.product_id
                WHERE cp.combo_id =:combo_id";
//          echo $QueryComboProducts;exit;
                       
            $resSet = $pdo->pdoQuery($QueryComboProducts, array("combo_id" => $combo_id))->results();
        }
         return $resSet;
        
    }
    
    /// calculate price of combo pack
    
    public static function get_combo_price($combo_id,$quantity=1)
    {
         global $tableprefix, $pdo;
         $price=0;
          if (!empty($combo_id)) {
              $whereConditions = array('combo_id' => $combo_id);
            $result = $pdo->select($tableprefix . 'combo', array('price'), $whereConditions)->results();
            
             if (!empty($result[0])) {
                 if($quantity>1)
                 {
                     $price=$quantity*$result[0]['price'];
                 }
                 else
                 {
                    $price= $result[0]['price'];
                 }
            } 
          }
        return $price;
    }
    
    /// calculate weight of combo pack
    public static function get_combo_weight($combo_id)
    {
         global $tableprefix, $pdo;
         $weight=0;
         if (!empty($combo_id)) {
            $QueryComboProducts = "SELECT SUM(po.product_shipping_weight) as weight
                FROM " . $tableprefix . "combo_products cp
                LEFT JOIN " . $tableprefix . "product_options po ON po.product_option_id = cp.product_option_id
                WHERE cp.combo_id =:combo_id";
            $resSet = $pdo->pdoQuery($QueryComboProducts, array("combo_id" => $combo_id))->results();
            $weight=$resSet[0]['weight'];
        }
        return $weight;
    }
    
    
    /// get product quantity in combo pack
     public static function get_product_quantity($combo_id,$product_option_id)
    {
         global $tableprefix, $pdo;
         $weight=0;
         if (!empty($combo_id)) {
            $QueryComboProducts = "SELECT product_quantity as quantity
                FROM " . $tableprefix . "combo_products cp
                WHERE cp.combo_id =:combo_id and product_option_id=:product_option_id";
            $resSet = $pdo->pdoQuery($QueryComboProducts, array("combo_id" => $combo_id,"product_option_id"=>$product_option_id))->results();
            $weight=$resSet[0]['quantity'];
        }
        return $weight;
    }
    
    
}
