
DROP TABLE IF EXISTS `multicart_admin_menu`;
CREATE TABLE IF NOT EXISTS `multicart_admin_menu` (
  `menu_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `page_name` varchar(200) NOT NULL DEFAULT '',
  `title` text NOT NULL,
  `link` varchar(200) NOT NULL DEFAULT '',
  `parent_id` smallint(4) NOT NULL DEFAULT '0',
  `display_order` tinyint(4) NOT NULL DEFAULT '0',
  `divname` varchar(200) NOT NULL DEFAULT '',
  `status` enum('ACTIVE','INACTIVE') NOT NULL DEFAULT 'ACTIVE',
  PRIMARY KEY (`menu_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_affiliates`;
CREATE TABLE IF NOT EXISTS `multicart_affiliates` (
  `affiliate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `affiliate_name` varchar(100) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `first_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `address1` varchar(100) DEFAULT NULL,
  `address2` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `zip` varchar(20) DEFAULT NULL,
  `fax` varchar(100) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `taxid` varchar(100) DEFAULT NULL,
  `date_registered` date DEFAULT NULL,
  `deleted` char(1) DEFAULT 'N',
  `vapproved` char(2) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`affiliate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_affiliate_banner`;
CREATE TABLE IF NOT EXISTS `multicart_affiliate_banner` (
  `naff_banner_id` int(11) NOT NULL AUTO_INCREMENT,
  `vaff_banner_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`naff_banner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_affiliate_payments`;
CREATE TABLE IF NOT EXISTS `multicart_affiliate_payments` (
  `affiliate_payment_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `affiliate_id` bigint(20) DEFAULT NULL,
  `order_id` int(11) NOT NULL,
  `amount_paid` double DEFAULT NULL,
  `date_marked_for_payment` date DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `comments` text,
  PRIMARY KEY (`affiliate_payment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_affiliate_registrations`;
CREATE TABLE IF NOT EXISTS `multicart_affiliate_registrations` (
  `registration_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `vaffiliate_currency` varchar(10) NOT NULL DEFAULT '',
  `affiliate_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `order_id` int(11) NOT NULL,
  `user_name` varchar(100) DEFAULT NULL,
  `user_first_name` varchar(100) DEFAULT NULL,
  `user_last_name` varchar(100) DEFAULT NULL,
  `user_email` varchar(100) DEFAULT NULL,
  `referral_charge` double DEFAULT NULL,
  `registration_date` date DEFAULT NULL COMMENT 'its Order date ',
  `affiliate_payment_id` bigint(20) DEFAULT NULL,
  `user_totalpurchasedamount` double DEFAULT NULL,
  PRIMARY KEY (`registration_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_artists`;
CREATE TABLE IF NOT EXISTS `multicart_artists` (
  `artist_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `artist_name` varchar(100) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `first_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `address1` varchar(100) DEFAULT NULL,
  `address2` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `zip` varchar(20) DEFAULT NULL,
  `fax` varchar(100) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `storename` text,
  `portfolio` text,
  `commission` double DEFAULT NULL,
  `taxid` varchar(100) DEFAULT NULL,
  `vseller_currency` varchar(50) NOT NULL DEFAULT '',
  `date_registered` date DEFAULT NULL,
  `company` varchar(50) DEFAULT NULL,
  `website` varchar(30) DEFAULT NULL,
  `deleted` char(1) DEFAULT 'N',
  `vapproved` char(2) NOT NULL DEFAULT 'N',
  `defaultflatrate` float NOT NULL DEFAULT '0',
  `additionalflatrate` float NOT NULL DEFAULT '0',
  `sellerPlanID` int(11) NOT NULL DEFAULT '0',
  `enablepaypal` char(1) NOT NULL DEFAULT '',
  `enablepaypalsandbox` char(1) NOT NULL DEFAULT '',
  `paypalidentitytoken` varchar(200) NOT NULL DEFAULT '',
  `paypalemail` varchar(100) NOT NULL DEFAULT '',
  `plan_expired` enum('Y','N') NOT NULL DEFAULT 'N' COMMENT 'Whether \r\n\r\nplan expired or not',
  `theme_color` varchar(50) NOT NULL,
  `theme_banner` varchar(50) NOT NULL,
  `theme_numrows` varchar(255) NOT NULL,
  `theme_numcols` int(10) NOT NULL,
  `device_id` varchar(255) DEFAULT NULL,
  `is_vacation_mode` enum('Y','N') DEFAULT 'N' COMMENT 'check vacation mode is activated or not',
  `seller_time_zone` varchar(100) DEFAULT NULL COMMENT 'Seller time zone used for publish later feature',
  `ip_address` varchar(100) DEFAULT NULL COMMENT 'ip address of user',
  `ip_location` varchar(255) DEFAULT NULL COMMENT 'country , state,city',
  PRIMARY KEY (`artist_id`),
  KEY `seller_index` (`vapproved`,`deleted`),
  KEY `date_register` (`date_registered`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_artists_membershipDetails`;
CREATE TABLE IF NOT EXISTS `multicart_artists_membershipDetails` (
  `artist_memID` int(11) NOT NULL AUTO_INCREMENT,
  `artist_id` int(11) NOT NULL DEFAULT '0',
  `artist_memStartDate` date NOT NULL DEFAULT '0000-00-00',
  `artist_memEndDate` date NOT NULL DEFAULT '0000-00-00',
  `plan_Id` int(11) NOT NULL DEFAULT '0',
  `plan_SubscriptionCharge` double NOT NULL DEFAULT '0',
  `transaction_id` varchar(255) NOT NULL,
  PRIMARY KEY (`artist_memID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_artist_devices`;
CREATE TABLE IF NOT EXISTS `multicart_artist_devices` (
  `artist_device_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `artist_id` bigint(20) NOT NULL DEFAULT '0',
  `device_id` varchar(255) NOT NULL DEFAULT '0',
  `device_type` varchar(255) NOT NULL DEFAULT '0',
  `date_added` datetime DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`artist_device_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `multicart_artist_feedbacks`;
CREATE TABLE IF NOT EXISTS `multicart_artist_feedbacks` (
  `artist_feedback_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `feedback_content` text,
  `rating` smallint(6) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `artist_id` bigint(20) DEFAULT NULL,
  `date_added` date DEFAULT NULL,
  `published` char(1) DEFAULT 'N',
  PRIMARY KEY (`artist_feedback_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_artist_payments`;
CREATE TABLE IF NOT EXISTS `multicart_artist_payments` (
  `artist_payment_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `artist_id` bigint(20) DEFAULT NULL,
  `order_id` bigint(20) DEFAULT NULL,
  `commission_percentage` double DEFAULT NULL,
  `seller_order_total_amount` double NOT NULL DEFAULT '0',
  `admin_commision_amount` double NOT NULL DEFAULT '0',
  `total_amount` double DEFAULT NULL,
  `amount_paid` double DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `comments` text,
  `date_marked_for_payment` date DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_status` enum('P','C') NOT NULL DEFAULT 'P',
  `seller_viewed_status` tinyint(1) NOT NULL DEFAULT '0',
  `discount_amount` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`artist_payment_id`),
  KEY `order_id` (`order_id`),
  KEY `payment_status` (`payment_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;



DROP TABLE IF EXISTS `multicart_artist_portfolios`;
CREATE TABLE IF NOT EXISTS `multicart_artist_portfolios` (
  `artist_portfolio_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `artist_id` int(11) DEFAULT NULL,
  `artist_description` text,
  `artist_photo` varchar(200) DEFAULT NULL,
  `artist_sample_work_1` varchar(200) DEFAULT NULL,
  `artist_sample_work_2` varchar(200) DEFAULT NULL,
  `artist_sample_work_3` varchar(200) DEFAULT NULL,
  `artist_sample_work_4` varchar(200) DEFAULT NULL,
  `artist_sample_work_5` varchar(200) DEFAULT NULL,
  `artist_sample_work_6` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`artist_portfolio_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_banners`;
CREATE TABLE IF NOT EXISTS `multicart_banners` (
  `nbanner_id` int(11) NOT NULL AUTO_INCREMENT,
  `vbanner_name` varchar(50) NOT NULL DEFAULT '',
  `vbanner_locurl` varchar(250) NOT NULL DEFAULT '',
  `vbanner_image` varchar(50) NOT NULL DEFAULT '',
  `dbanner_date` date NOT NULL DEFAULT '0000-00-00',
  `nbanner_display_count` int(11) NOT NULL DEFAULT '0',
  `vbannerdelete_status` char(1) NOT NULL DEFAULT '',
  `cdn_images_moved` enum('Y','N') NOT NULL DEFAULT 'N',
  PRIMARY KEY (`nbanner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_cart`;
CREATE TABLE IF NOT EXISTS `multicart_cart` (
  `cart_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(11) DEFAULT NULL,
  `visitor_cart_id` varchar(40) DEFAULT NULL,
  `product_id` bigint(20) DEFAULT NULL,
  `product_option_id` bigint(20) NOT NULL,
  `quantity` int(11) DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `datetime_added` varchar(20) DEFAULT NULL,
  `digital_product_flag` enum('Y','N') DEFAULT 'N',
  `gift_product_flag` enum('Y','N') DEFAULT 'N',
  `seller_id` int(11) DEFAULT NULL,
  `subscription_flag` enum('Y','N') DEFAULT 'N' COMMENT 'store subscription status of a product',
  `subscription_duration` int(11) DEFAULT NULL,
  PRIMARY KEY (`cart_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_cart_temp`;
CREATE TABLE IF NOT EXISTS `multicart_cart_temp` (
  `ncart_temp_id` int(11) NOT NULL AUTO_INCREMENT,
  `ncart_id` int(11) NOT NULL DEFAULT '0',
  `ncart_quantity` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ncart_temp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_categories`;
CREATE TABLE IF NOT EXISTS `multicart_categories` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `route` varchar(100) DEFAULT NULL,
  `count` int(11) DEFAULT '0',
  `gift_certificate_flag` char(1) NOT NULL DEFAULT '',
  `avatar` varchar(250) NOT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `cdn_images_moved` enum('Y','N') DEFAULT 'N',
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_category_options`;
CREATE TABLE IF NOT EXISTS `multicart_category_options` (
  `category_option_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) NOT NULL,
  `option_id` bigint(20) NOT NULL,
  PRIMARY KEY (`category_option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_content_management`;
CREATE TABLE IF NOT EXISTS `multicart_content_management` (
  `content_id` int(11) NOT NULL AUTO_INCREMENT,
  `content_name` varchar(25) NOT NULL DEFAULT '',
  `content_heading` text NOT NULL,
  `content_text` text NOT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_countries`;
CREATE TABLE IF NOT EXISTS `multicart_countries` (
  `country_id` int(11) NOT NULL AUTO_INCREMENT,
  `country_name` varchar(64) NOT NULL DEFAULT '',
  `country_iso_code_2` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`country_id`),
  KEY `IDX_COUNTRY_NAME` (`country_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_couponcode`;
CREATE TABLE IF NOT EXISTS `multicart_couponcode` (
  `ccID` int(11) NOT NULL AUTO_INCREMENT,
  `ccStartDate` date NOT NULL DEFAULT '0000-00-00',
  `ccEndDate` date NOT NULL DEFAULT '0000-00-00',
  `ccCode` varchar(50) NOT NULL DEFAULT '',
  `sellerId` int(11) DEFAULT NULL COMMENT 'equivalent to artist_id(StoreId)',
  `categoryId` text,
  `productId` text,
  `ccDescription` text NOT NULL,
  `ccDiscount` float NOT NULL DEFAULT '0',
  `subscriptionStatus` char(1) NOT NULL DEFAULT '',
  `ccStatus` char(1) NOT NULL DEFAULT '',
  `coupon_type` varchar(50) NOT NULL DEFAULT '',
  `discount_type` enum('PERCENTAGE','FLAT') DEFAULT 'PERCENTAGE',
  PRIMARY KEY (`ccID`),
  UNIQUE KEY `ccCode` (`ccCode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_currency_master`;
CREATE TABLE IF NOT EXISTS `multicart_currency_master` (
  `ncurrency_id` int(11) NOT NULL AUTO_INCREMENT,
  `vcurrency_name` varchar(50) NOT NULL DEFAULT '',
  `vcurrency_code` varchar(10) NOT NULL DEFAULT '',
  `vcurrency_symbol` varchar(10) NOT NULL DEFAULT '',
  `nexchange_price` float NOT NULL DEFAULT '0',
  `vactive` char(1) NOT NULL DEFAULT '',
  `vcurrency_delete_status` char(1) NOT NULL DEFAULT '',
  `usdollar_rate` float NOT NULL DEFAULT '1',
  PRIMARY KEY (`ncurrency_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_custom_fields`;
CREATE TABLE IF NOT EXISTS `multicart_custom_fields` (
  `ncustom_id` int(11) NOT NULL AUTO_INCREMENT,
  `vcustom_field_form_id` int(11) NOT NULL DEFAULT '0',
  `vcustom_field_name` varchar(50) NOT NULL DEFAULT '',
  `vcustom_field_type` varchar(50) NOT NULL DEFAULT '',
  `vrequired_custom_field` char(1) NOT NULL DEFAULT '',
  `vcustom_sort_order` int(11) NOT NULL DEFAULT '0',
  `vcustom_display_field` char(1) NOT NULL DEFAULT '',
  `vcustom_delete_status` char(1) NOT NULL DEFAULT '',
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`ncustom_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_custom_fields_value`;
CREATE TABLE IF NOT EXISTS `multicart_custom_fields_value` (
  `nvalue_id` int(11) NOT NULL AUTO_INCREMENT,
  `ncustom_field_id` int(11) NOT NULL DEFAULT '0',
  `ncustom_table_id` int(11) NOT NULL DEFAULT '0',
  `vfield_name_value` text NOT NULL,
  `vcustom_field_name` text NOT NULL,
  `vcustom_field_type` text NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`nvalue_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_custom_form`;
CREATE TABLE IF NOT EXISTS `multicart_custom_form` (
  `ncustom_form_id` int(11) NOT NULL AUTO_INCREMENT,
  `vcustom_form_name` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`ncustom_form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_digital_product`;
CREATE TABLE IF NOT EXISTS `multicart_digital_product` (
  `ndigital_id` int(11) NOT NULL AUTO_INCREMENT,
  `vdigital_product_name` varchar(250) NOT NULL DEFAULT '',
  `ndigital_productid` int(11) NOT NULL DEFAULT '0',
  `ndigital_orderid` int(11) NOT NULL DEFAULT '0',
  `vdigital_product_code` text NOT NULL,
  `ndownload_try` int(11) NOT NULL DEFAULT '0',
  `ndownload_count` int(11) NOT NULL DEFAULT '0',
  `ndownload_expiry` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ndownload_expiry_days` int(11) NOT NULL DEFAULT '0',
  `ndownload_status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ndigital_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_email_templates`;
CREATE TABLE IF NOT EXISTS `multicart_email_templates` (
  `nemail_id` int(11) NOT NULL AUTO_INCREMENT,
  `vtemplate_name` varchar(100) NOT NULL DEFAULT '',
  `vtemplate_title` varchar(100) NOT NULL DEFAULT '',
  `vemail_body` text NOT NULL,
  `vreplaceable_variables` text NOT NULL,
  `vtemplate_flag` char(1) DEFAULT '',
  `artist_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`nemail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_favourites`;
CREATE TABLE IF NOT EXISTS `multicart_favourites` (
  `nId` int(11) NOT NULL AUTO_INCREMENT,
  `nProductId` int(11) NOT NULL,
  `nProductOptionId` int(11) NOT NULL,
  `nUserId` int(11) NOT NULL,
  `seller_id` int(11) NOT NULL,
  `dDate` datetime NOT NULL,
  `status` enum('Y','N') NOT NULL DEFAULT 'Y' COMMENT 'Y = Active , N = Deactive',
  PRIMARY KEY (`nId`),
  KEY `nProductId` (`nProductId`,`nProductOptionId`,`nUserId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Store favourites Items';


DROP TABLE IF EXISTS `multicart_fedexsettings`;
CREATE TABLE IF NOT EXISTS `multicart_fedexsettings` (
  `fid` int(11) NOT NULL AUTO_INCREMENT,
  `FedexAccno` varchar(40) DEFAULT NULL,
  `FedexMeterno` varchar(20) DEFAULT NULL,
  `FedexWeight` varchar(20) DEFAULT NULL,
  `FedexServer` varchar(20) DEFAULT NULL,
  `FedexDropOff` varchar(100) DEFAULT NULL,
  `FedexService` text,
  `FedexPassword` varchar(50) DEFAULT NULL,
  `FedexKey` varchar(50) DEFAULT NULL,
  `FedexPackage` varchar(50) DEFAULT NULL,
  `FedexCurrency` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_feedbacks`;
CREATE TABLE IF NOT EXISTS `multicart_feedbacks` (
  `feedback_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `feedback_content` text,
  `user_id` bigint(20) DEFAULT NULL,
  `date_added` date DEFAULT NULL,
  `published` char(1) DEFAULT 'N',
  PRIMARY KEY (`feedback_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_flat_rate_default`;
CREATE TABLE IF NOT EXISTS `multicart_flat_rate_default` (
  `flat_rate_default_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `flat_rate_name` varchar(250) NOT NULL,
  `first_Item_charge` float NOT NULL,
  `additional_Item_charge` float NOT NULL,
  PRIMARY KEY (`flat_rate_default_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_flat_rate_seller`;
CREATE TABLE IF NOT EXISTS `multicart_flat_rate_seller` (
  `flat_rate_seller_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `flat_rate_name` varchar(250) NOT NULL,
  `first_Item_charge` float NOT NULL,
  `additional_Item_charge` float NOT NULL,
  `seller_id` bigint(20) NOT NULL,
  PRIMARY KEY (`flat_rate_seller_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_giftcertificates`;
CREATE TABLE IF NOT EXISTS `multicart_giftcertificates` (
  `gift_id` int(11) NOT NULL AUTO_INCREMENT,
  `vgift_coupon_code` varchar(255) NOT NULL,
  `ngift_order_id` int(11) NOT NULL,
  `ngift_coupon_amount` double NOT NULL,
  `ngift_product_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `nused_gift_amount` double NOT NULL DEFAULT '0',
  `seller_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gift_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_giftcoupon_master`;
CREATE TABLE IF NOT EXISTS `multicart_giftcoupon_master` (
  `ngift_id` int(11) NOT NULL AUTO_INCREMENT,
  `ngift_product_id` int(11) NOT NULL DEFAULT '0',
  `ngift_order_id` int(11) NOT NULL DEFAULT '0',
  `vgift_coupon_code` varchar(250) NOT NULL DEFAULT '',
  `ngift_coupon_amount` float NOT NULL DEFAULT '0',
  `ngift_coupon_products` text NOT NULL,
  `vgift_currency` varchar(10) NOT NULL DEFAULT '',
  `vgift_delete_status` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`ngift_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_help`;
CREATE TABLE IF NOT EXISTS `multicart_help` (
  `hid` int(11) NOT NULL AUTO_INCREMENT,
  `hcid` int(11) DEFAULT NULL,
  `htitle` varchar(100) DEFAULT NULL,
  `hdescription` text,
  `hposition` int(11) DEFAULT NULL,
  `active` enum('0','1') DEFAULT NULL,
  `himage` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`hid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_helpcategory`;
CREATE TABLE IF NOT EXISTS `multicart_helpcategory` (
  `hcid` int(11) NOT NULL AUTO_INCREMENT,
  `htype` varchar(50) DEFAULT NULL,
  `hctitle` varchar(100) DEFAULT NULL,
  `hcposition` int(11) DEFAULT NULL,
  `active` enum('0','1') DEFAULT NULL,
  PRIMARY KEY (`hcid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_homepagebanners`;
CREATE TABLE IF NOT EXISTS `multicart_homepagebanners` (
  `homepage_banner_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `image` varchar(250) NOT NULL,
  `deleted` enum('Y','N') NOT NULL DEFAULT 'N',
  `created_on` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `link` varchar(255) NOT NULL,
  `cdn_images_moved` enum('Y','N') NOT NULL DEFAULT 'N',
  PRIMARY KEY (`homepage_banner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_language_master`;
CREATE TABLE IF NOT EXISTS `multicart_language_master` (
  `nlanguageId` int(10) NOT NULL AUTO_INCREMENT,
  `languageName` varchar(50) NOT NULL DEFAULT '0',
  `prevLanguage` varchar(50) DEFAULT '0',
  `backupFile` varchar(500) DEFAULT '0',
  `langActive` enum('0','1') DEFAULT '0',
  `langDeleteStatus` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`nlanguageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_message_to_seller`;
CREATE TABLE IF NOT EXISTS `multicart_message_to_seller` (
  `message_to_seller_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `artist_id` int(11) NOT NULL,
  `name` varchar(250) NOT NULL,
  `email` varchar(250) NOT NULL,
  `subject` varchar(250) NOT NULL,
  `message` text NOT NULL,
  `created_on` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `read` enum('Y','N') NOT NULL DEFAULT 'N',
  `seller_viewed_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`message_to_seller_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_metatags`;
CREATE TABLE IF NOT EXISTS `multicart_metatags` (
  `nId` int(11) NOT NULL AUTO_INCREMENT,
  `vTitle` varchar(200) DEFAULT NULL,
  `vKeywords` text,
  `vDescription` text,
  `vPageName` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`nId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_newsletters`;
CREATE TABLE IF NOT EXISTS `multicart_newsletters` (
  `nl_id` int(11) NOT NULL AUTO_INCREMENT,
  `nl_subject` varchar(200) NOT NULL DEFAULT '',
  `nl_message` text NOT NULL,
  `nl_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`nl_id`),
  UNIQUE KEY `nl_id` (`nl_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_options`;
CREATE TABLE IF NOT EXISTS `multicart_options` (
  `option_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `option_name` varchar(250) NOT NULL,
  PRIMARY KEY (`option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_orders`;
CREATE TABLE IF NOT EXISTS `multicart_orders` (
  `order_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `billing_first_name` varchar(100) DEFAULT NULL,
  `billing_last_name` varchar(100) DEFAULT NULL,
  `billing_address1` varchar(100) DEFAULT NULL,
  `billing_address2` varchar(100) DEFAULT NULL,
  `billing_city` varchar(100) DEFAULT NULL,
  `billing_state` varchar(100) DEFAULT NULL,
  `billing_country` varchar(100) DEFAULT NULL,
  `billing_zip` varchar(20) DEFAULT NULL,
  `billing_fax` varchar(30) DEFAULT NULL,
  `billing_email` varchar(100) DEFAULT NULL,
  `billing_phone` varchar(20) DEFAULT NULL,
  `shipping_first_name` varchar(100) DEFAULT NULL,
  `shipping_last_name` varchar(100) DEFAULT NULL,
  `shipping_address1` varchar(100) DEFAULT NULL,
  `shipping_address2` varchar(100) DEFAULT NULL,
  `shipping_city` varchar(100) DEFAULT NULL,
  `shipping_state` varchar(100) DEFAULT NULL,
  `shipping_country` varchar(100) DEFAULT NULL,
  `shipping_zip` varchar(20) DEFAULT NULL,
  `shipping_fax` varchar(20) DEFAULT NULL,
  `shipping_email` varchar(100) DEFAULT NULL,
  `shipping_phone` varchar(20) DEFAULT NULL,
  `prefered_shippin_method` varchar(200) DEFAULT NULL,
  `order_date` date DEFAULT NULL,
  `order_total_price` double DEFAULT NULL,
  `taxrate` double DEFAULT '0',
  `couponCode` varchar(50) NOT NULL DEFAULT '0',
  `couponCodeDiscount` float NOT NULL DEFAULT '0',
  `couponCodeSeller_Id` int(11) NOT NULL DEFAULT '0',
  `order_status` tinyint(4) DEFAULT NULL,
  `vorder_currency` varchar(10) NOT NULL DEFAULT '',
  `vpayment_status` char(1) NOT NULL DEFAULT '',
  `transaction_id` varchar(255) DEFAULT NULL,
  `vgiftcertificate_code` varchar(255) NOT NULL DEFAULT '',
  `nused_gift_amount` double NOT NULL DEFAULT '0',
  `namount_paid` double NOT NULL DEFAULT '0',
  `buyer_comments` text NOT NULL,
  `payment_completed_status` enum('Y','N') NOT NULL DEFAULT 'N',
  `seller_viewed_status` tinyint(1) NOT NULL DEFAULT '0',
  `is_subscription_order` enum('Y','N') NOT NULL DEFAULT 'N',
  PRIMARY KEY (`order_id`),
  KEY `paymentstatus` (`vpayment_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_order_details`;
CREATE TABLE IF NOT EXISTS `multicart_order_details` (
  `order_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) DEFAULT NULL,
  `product_id` bigint(20) DEFAULT NULL,
  `product_option_id` int(11) NOT NULL,
  `product_name` varchar(200) DEFAULT NULL,
  `product_code` varchar(20) DEFAULT NULL,
  `product_price` double DEFAULT NULL,
  `product_tax` float NOT NULL,
  `product_quantity` int(11) DEFAULT NULL,
  `artist_id` bigint(20) DEFAULT NULL,
  `item_status` smallint(6) DEFAULT NULL,
  `artist_payment_status` smallint(6) DEFAULT NULL,
  `artist_payment_id` bigint(20) DEFAULT NULL,
  `user_refund_id` bigint(20) DEFAULT '0',
  `product_discount` int(11) DEFAULT '0',
  `item_delivery_date` datetime NOT NULL,
  `product_commission_amount` float NOT NULL DEFAULT '0',
  `digital_product_flag` enum('Y','N') DEFAULT 'N',
  `gift_product_flag` enum('Y','N') DEFAULT 'N',
  `subscription_product_flag` enum('Y','N') DEFAULT 'N',
  `product_shipping_price` float DEFAULT '0',
  `product_shipping_name` varchar(255) DEFAULT NULL,
  `allow_free_shipping` enum('Y','N') DEFAULT 'N',
  PRIMARY KEY (`order_detail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_order_status`;
CREATE TABLE IF NOT EXISTS `multicart_order_status` (
  `order_status_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `order_status` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`order_status_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_products`;
CREATE TABLE IF NOT EXISTS `multicart_products` (
  `product_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_name` varchar(255) DEFAULT NULL,
  `product_code` varchar(20) DEFAULT NULL,
  `product_description` text,
  `product_price` double DEFAULT NULL,
  `product_category` int(11) DEFAULT NULL,
  `product_artist_id` int(11) DEFAULT NULL,
  `date_added` date DEFAULT NULL,
  `deleted` char(1) DEFAULT 'N',
  `featured` char(1) DEFAULT 'N',
  `vdigital_product` char(1) NOT NULL DEFAULT '',
  `vapproved` char(2) NOT NULL DEFAULT 'N',
  `payment_status` enum('PENDING','COMPLETED') NOT NULL DEFAULT 'PENDING',
  `seller_viewed_status` tinyint(1) NOT NULL DEFAULT '0',
  `alias` varchar(100) DEFAULT NULL,
  `publish_status` char(1) DEFAULT 'N',
  `publish_scheduled_date` datetime DEFAULT NULL,
  `allow_free_shipping` enum('Y','N') DEFAULT 'N' COMMENT 'Allow free shipping for products',
  `allow_subscription` enum('Y','N') DEFAULT 'N' COMMENT 'Allow free subscription for products',
  `subscription_mode` enum('Daily','Monthly','Yearly') DEFAULT 'Monthly' COMMENT 'Subscription modes',
  `product_tags` text COMMENT 'Product tags for easy searching',
  `publish_timezone` varchar(255) DEFAULT NULL COMMENT 'timezone to publish product',
  `seller_vacation_mode` enum('Y','N') DEFAULT 'N' COMMENT ' N=Vacation mode  not ebaled , Y= Vacation mode enabled',
  `default_image_small` varchar(255) DEFAULT NULL COMMENT 'default image for listing pages',
  `default_stock` int(11) DEFAULT '0' COMMENT 'sum of all  option stock value ',
  `default_additional_price` float DEFAULT '0' COMMENT 'default option additional price value',
  `default_shipping_weight` float DEFAULT '0' COMMENT 'default option weight',
  `default_discount` float DEFAULT '0' COMMENT 'default option discount % ',
  `default_discount_description` varchar(250) DEFAULT NULL COMMENT 'default option discount description ',
  `vSellerStatus` enum('Y','N') DEFAULT 'Y' COMMENT 'seller status',
  `default_option_id` int(11) DEFAULT NULL COMMENT 'default option id refered from product options table',
  `seller_name` varchar(255) DEFAULT NULL COMMENT 'save seller name',
  PRIMARY KEY (`product_id`),
  KEY `vapproved` (`vapproved`),
  KEY `date_added` (`date_added`),
  KEY `deleted` (`deleted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_product_impression`;
CREATE TABLE IF NOT EXISTS `multicart_product_impression` (
  `product_impression_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) NOT NULL,
  `ip` varchar(250) NOT NULL,
  `visited_on` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`product_impression_id`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_product_listing_fee_payment`;
CREATE TABLE IF NOT EXISTS `multicart_product_listing_fee_payment` (
  `product_listing_fee_payment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) NOT NULL,
  `total_amount` int(11) NOT NULL,
  `amount_paid` int(11) NOT NULL,
  `payment_method` varchar(250) NOT NULL,
  `payment_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `payment_status` enum('PENDING','COMPLETED') NOT NULL,
  PRIMARY KEY (`product_listing_fee_payment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_product_options`;
CREATE TABLE IF NOT EXISTS `multicart_product_options` (
  `product_option_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) NOT NULL,
  `additional_price` float NOT NULL,
  `image_small` varchar(250) NOT NULL,
  `image_big` varchar(250) NOT NULL,
  `product_stock` int(11) NOT NULL,
  `reorder_level` int(11) NOT NULL,
  `product_shipping_weight` float NOT NULL,
  `default_option` enum('YES','NO') NOT NULL DEFAULT 'YES',
  `discount` float NOT NULL,
  `discount_description` varchar(250) NOT NULL,
  `product_width` int(11) NOT NULL,
  `product_height` int(11) NOT NULL,
  `product_length` int(11) NOT NULL,
  `cdn_images_moved` enum('Y','N') NOT NULL DEFAULT 'N',
  PRIMARY KEY (`product_option_id`),
  KEY `defaultoption` (`product_id`,`default_option`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_product_option_values`;
CREATE TABLE IF NOT EXISTS `multicart_product_option_values` (
  `product_option_value_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_option_id` bigint(20) NOT NULL,
  `option_id` bigint(20) NOT NULL,
  `value` varchar(250) NOT NULL,
  PRIMARY KEY (`product_option_value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_product_view_images`;
CREATE TABLE IF NOT EXISTS `multicart_product_view_images` (
  `nproduct_image_id` int(11) NOT NULL AUTO_INCREMENT,
  `nimage_productid` int(11) NOT NULL DEFAULT '0',
  `vimage_name` varchar(250) NOT NULL DEFAULT '',
  `vimage_description` text NOT NULL,
  `vproduct_image_delete_status` char(1) NOT NULL DEFAULT '',
  `cdn_images_moved` enum('Y','N') NOT NULL DEFAULT 'N',
  PRIMARY KEY (`nproduct_image_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_rating`;
CREATE TABLE IF NOT EXISTS `multicart_rating` (
  `nrat_id` int(11) NOT NULL AUTO_INCREMENT,
  `vrating` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`nrat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_record_ratings`;
CREATE TABLE IF NOT EXISTS `multicart_record_ratings` (
  `nrts_id` int(11) NOT NULL AUTO_INCREMENT,
  `nrating_id` int(11) NOT NULL DEFAULT '0',
  `nruser_id` int(11) NOT NULL DEFAULT '0',
  `nrseller_id` int(11) NOT NULL DEFAULT '0',
  `ntotal_ratings` int(11) NOT NULL DEFAULT '0',
  `vType` char(1) NOT NULL DEFAULT 's',
  `vActive` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`nrts_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_refunds`;
CREATE TABLE IF NOT EXISTS `multicart_refunds` (
  `refund_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `seller_id` bigint(20) NOT NULL DEFAULT '0',
  `buyer_id` bigint(20) NOT NULL DEFAULT '0',
  `product_id` bigint(20) NOT NULL DEFAULT '0',
  `order_id` bigint(20) NOT NULL DEFAULT '0',
  `quantity` bigint(20) DEFAULT NULL,
  `return_reason` text NOT NULL,
  `Customer_Feedback` text,
  `Status` varchar(255) DEFAULT NULL,
  `Additional_info` text,
  `date` date NOT NULL DEFAULT '0000-00-00',
  `refund_mode` varchar(255) DEFAULT NULL,
  `reference_number` varchar(255) DEFAULT NULL,
  `seller_viewed_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`refund_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_report_product`;
CREATE TABLE IF NOT EXISTS `multicart_report_product` (
  `nreport_id` int(11) NOT NULL AUTO_INCREMENT,
  `nreport_product_id` int(11) NOT NULL DEFAULT '0',
  `nreport_customerid` int(11) NOT NULL DEFAULT '0',
  `nproduct_view_count` int(11) NOT NULL DEFAULT '0',
  `dproduct_view_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`nreport_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_Review`;
CREATE TABLE IF NOT EXISTS `multicart_Review` (
  `nRId` int(11) NOT NULL AUTO_INCREMENT,
  `nUserId` int(11) NOT NULL DEFAULT '0',
  `nProdId` int(11) NOT NULL DEFAULT '0',
  `vDes` text NOT NULL,
  `vActive` enum('0','1') NOT NULL DEFAULT '0',
  `seller_viewed_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nRId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_sellerPlans`;
CREATE TABLE IF NOT EXISTS `multicart_sellerPlans` (
  `plan_Id` int(11) NOT NULL AUTO_INCREMENT,
  `plan_Title` varchar(100) NOT NULL DEFAULT '',
  `plan_Description` text NOT NULL,
  `plan_Period` char(1) NOT NULL DEFAULT '',
  `plan_SubscriptionCharge` double NOT NULL DEFAULT '0',
  `plan_Status` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`plan_Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_seller_favourites`;
CREATE TABLE IF NOT EXISTS `multicart_seller_favourites` (
  `nId` int(11) NOT NULL AUTO_INCREMENT,
  `nUserId` int(11) DEFAULT '0',
  `nSellerId` int(11) DEFAULT '0',
  `dDate` datetime DEFAULT NULL,
  `status` enum('Y','N') DEFAULT 'Y',
  PRIMARY KEY (`nId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='store favourites sellers';


DROP TABLE IF EXISTS `multicart_settings`;
CREATE TABLE IF NOT EXISTS `multicart_settings` (
  `nsettings_id` int(11) NOT NULL AUTO_INCREMENT,
  `vLicenceKey` varchar(250) DEFAULT NULL,
  `site_name` varchar(100) DEFAULT NULL,
  `site_url` varchar(250) DEFAULT NULL,
  `site_secure_url` varchar(250) DEFAULT NULL,
  `site_email` varchar(100) DEFAULT NULL,
  `site_logo` varchar(100) DEFAULT NULL,
  `vReview` varchar(9) NOT NULL DEFAULT 'automatic',
  `banner_size` varchar(15) NOT NULL DEFAULT '',
  `npagination_limit` int(11) NOT NULL DEFAULT '0',
  `enable_google` char(1) NOT NULL DEFAULT '',
  `nproduct_images` int(11) NOT NULL DEFAULT '0',
  `google_adsense_value` text NOT NULL,
  `enable_shipping` char(1) NOT NULL DEFAULT '',
  `enable_tax` enum('0','1','2') NOT NULL DEFAULT '0',
  `enable_flatrate` varchar(10) NOT NULL DEFAULT 'Y',
  `default_flatrate` float NOT NULL DEFAULT '0',
  `additional_flatrate` float NOT NULL DEFAULT '0',
  `defaulttax_rate` float DEFAULT '0',
  `enable_fedexshipping` varchar(10) DEFAULT 'N',
  `enable_uspsshipping` varchar(10) NOT NULL DEFAULT 'N',
  `enable_canadapost` varchar(10) NOT NULL DEFAULT 'N',
  `enable_australiapost` varchar(10) NOT NULL DEFAULT 'N',
  `canada_merchantId` varchar(30) DEFAULT NULL,
  `canada_server` varchar(30) DEFAULT NULL,
  `more_images` char(1) NOT NULL DEFAULT '',
  `ndisplay_stock` char(1) NOT NULL DEFAULT '',
  `ndisplay_banner` char(1) NOT NULL DEFAULT '',
  `site_style` varchar(100) DEFAULT NULL,
  `admin_name` varchar(100) DEFAULT NULL,
  `admin_password` varchar(100) DEFAULT NULL,
  `admin_email` varchar(100) DEFAULT NULL,
  `products_per_page` int(11) DEFAULT NULL,
  `publish_feedbacks` char(1) DEFAULT NULL,
  `publish_featured` char(1) DEFAULT 'Y',
  `publish_newitem` char(1) DEFAULT 'Y',
  `publish_shoppingcart` char(1) DEFAULT 'Y',
  `artist_commission` double DEFAULT '0',
  `referral_charge` double DEFAULT '0',
  `vauthorize_enable` char(1) NOT NULL DEFAULT '',
  `venable_gift_payment` char(1) NOT NULL DEFAULT '',
  `venable_couponCode_payment` char(1) NOT NULL DEFAULT 'N',
  `enable_buyerToseller` char(1) NOT NULL DEFAULT 'N',
  `enable_membership` char(1) NOT NULL DEFAULT 'N',
  `authorize_loginid` varchar(200) DEFAULT NULL,
  `authorize_transkey` varchar(200) DEFAULT NULL,
  `authorize_password` varchar(200) DEFAULT NULL,
  `authorize_email` varchar(200) DEFAULT NULL,
  `authorize_test_mode` char(1) DEFAULT NULL,
  `enablepaypal` char(1) DEFAULT NULL,
  `enableworldpay` char(1) NOT NULL DEFAULT 'N',
  `worldpay_testmode` enum('0','100') NOT NULL DEFAULT '0',
  `worldpay_inst_Id` varchar(15) DEFAULT NULL,
  `worldpay_email` varchar(30) DEFAULT NULL,
  `worldpay_transact_method` enum('A','C','E','R') DEFAULT NULL,
  `enablepaypalsandbox` char(1) DEFAULT NULL,
  `paypalidentitytoken` varchar(200) DEFAULT NULL,
  `paypalemail` varchar(100) DEFAULT NULL,
  `vgoogle_check_enable` char(1) NOT NULL DEFAULT '',
  `vgooglecheck_id` varchar(250) NOT NULL DEFAULT '',
  `vgooglecheck_key` varchar(250) NOT NULL DEFAULT '',
  `vgooglecheck_mode` varchar(10) NOT NULL DEFAULT '',
  `vyourpay_enable` char(1) NOT NULL DEFAULT '',
  `vyourpay_storeid` varchar(250) NOT NULL DEFAULT '',
  `vyourpay_certificate_file` varchar(250) NOT NULL DEFAULT '',
  `vyourpay_mode` varchar(5) NOT NULL DEFAULT '',
  `approve_sellers` enum('1','2','3') NOT NULL DEFAULT '1',
  `approve_affiliates` enum('1','2','3') NOT NULL DEFAULT '1',
  `approve_products` enum('1','2') NOT NULL DEFAULT '1',
  `enable_rma` varchar(10) NOT NULL DEFAULT 'N',
  `rma_repair` varchar(10) NOT NULL DEFAULT 'N',
  `rma_replace` varchar(10) NOT NULL DEFAULT 'N',
  `rma_refund` varchar(10) NOT NULL DEFAULT 'N',
  `rma_confirm_message` varchar(10) NOT NULL DEFAULT 'N',
  `rma_status_change` varchar(10) NOT NULL DEFAULT 'N',
  `enable_bulkupload` varchar(10) NOT NULL DEFAULT 'N',
  `flatrate_displayname` varchar(255) NOT NULL DEFAULT 'Over night ground',
  `admin_currency` varchar(255) NOT NULL DEFAULT 'USD',
  `enable_multicurrency` enum('Y','N') NOT NULL DEFAULT 'N',
  `slideshow_delay` int(5) NOT NULL,
  `enable_affiliates` enum('Y','N') NOT NULL DEFAULT 'Y',
  `more_image_limit` int(11) NOT NULL DEFAULT '4',
  `vyourpay_userid` varchar(100) NOT NULL,
  `paypal_api_username` varchar(200) NOT NULL,
  `paypal_api_password` varchar(200) NOT NULL,
  `paypal_api_signature` varchar(255) NOT NULL,
  `paypal_application_app_id` varchar(255) NOT NULL,
  `product_listing_fee` double NOT NULL DEFAULT '0',
  `enable_commentbox` enum('Y','N') NOT NULL DEFAULT 'N',
  `vbluepay_enable` enum('Y','N') NOT NULL DEFAULT 'N',
  `bluepay_accountid` varchar(255) NOT NULL,
  `bluepay_secretkey` varchar(255) NOT NULL,
  `bluepay_test_mode` enum('TEST','LIVE') NOT NULL DEFAULT 'TEST',
  `enable_fbshare` enum('Y','N') NOT NULL DEFAULT 'Y',
  `enable_tweet` enum('Y','N') NOT NULL DEFAULT 'Y',
  `enable_gplusshare` enum('Y','N') NOT NULL DEFAULT 'Y',
  `enable_pinit` enum('Y','N') NOT NULL DEFAULT 'Y',
  `enable_instagram` enum('Y','N') NOT NULL DEFAULT 'Y',
  `enable_favourites` enum('Y','N') NOT NULL DEFAULT 'N' COMMENT 'Enable Favourites list',
  `enable_seller_account` enum('Y','N') NOT NULL DEFAULT 'N' COMMENT 'Enable seller account activate option for buyers',
  `enable_product_scheduled_publishing` enum('Y','N') NOT NULL DEFAULT 'N' COMMENT 'Enable product scheduled publishing',
  `enable_subscription_products` enum('Y','N') NOT NULL DEFAULT 'N' COMMENT 'Enable subscription for products',
  `currency_settings` enum('FREE','LIVE') NOT NULL DEFAULT 'FREE' COMMENT 'Settings to enable currency conversion Api ',
  `currency_api_key` varchar(50) NOT NULL COMMENT 'Store Api key for production mode',
  `enable_scalability_settings` enum('Y','N') DEFAULT 'Y',
  `enable_amazon_cdn_images` enum('Y','N') DEFAULT 'N',
  `amazon_bucket_name` varchar(255) DEFAULT NULL,
  `amazon_access_key` varchar(255) DEFAULT NULL,
  `amazon_secret_key` varchar(255) DEFAULT NULL,
  `dwolla_payment_enable` enum('Y','N') NOT NULL DEFAULT 'N',
  `dwolla_payment_test_mode` enum('Y','N') NOT NULL DEFAULT 'N',
  `dwolla_key` varchar(255) DEFAULT NULL,
  `dwolla_secretkey` varchar(255) DEFAULT NULL,
  `stripe_payment_enable` enum('Y','N') NOT NULL DEFAULT 'N',
  `stripe_payment_test_mode` enum('Y','N') NOT NULL DEFAULT 'N',
  `stripe_publish_key` varchar(255) DEFAULT NULL,
  `stripe_secretkey` varchar(255) DEFAULT NULL,
  `enable_free_shipping` enum('Y','N') NOT NULL DEFAULT 'N',
  `min_order_amount` double(11,2) DEFAULT NULL,
  PRIMARY KEY (`nsettings_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_shipping_details`;
CREATE TABLE IF NOT EXISTS `multicart_shipping_details` (
  `nshipping_id` int(11) NOT NULL AUTO_INCREMENT,
  `nshipping_type` int(11) NOT NULL DEFAULT '0',
  `norder_id` int(11) NOT NULL DEFAULT '0',
  `nshp_productid` int(11) NOT NULL DEFAULT '0',
  `nproduct_option_id` int(11) NOT NULL,
  `nshp_productname` varchar(255) NOT NULL,
  `vshipping_name` varchar(250) NOT NULL DEFAULT '',
  `nshipping_cost` float NOT NULL DEFAULT '0',
  `nshipping_weight` int(11) NOT NULL DEFAULT '0',
  `vshipping_currency` varchar(10) NOT NULL DEFAULT '',
  `dshipped_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `nshp_status` char(1) NOT NULL DEFAULT '',
  `user_id` bigint(11) NOT NULL DEFAULT '0',
  `seller_id` bigint(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nshipping_id`),
  KEY `norder_id` (`norder_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_shipping_methods`;
CREATE TABLE IF NOT EXISTS `multicart_shipping_methods` (
  `shipping_method_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `shipping_method_name` varchar(255) DEFAULT NULL,
  `shipping_method_logo` varchar(255) DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `vdeleted` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`shipping_method_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_shipping_settings`;
CREATE TABLE IF NOT EXISTS `multicart_shipping_settings` (
  `sid` tinyint(11) NOT NULL AUTO_INCREMENT,
  `nShippingweight` int(11) NOT NULL DEFAULT '0',
  `ups_rate` varchar(255) NOT NULL DEFAULT '',
  `container_type` varchar(255) NOT NULL DEFAULT '',
  `address_quote_method` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_social_media`;
CREATE TABLE IF NOT EXISTS `multicart_social_media` (
  `social_media_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `title` varchar(250) NOT NULL,
  `link` text NOT NULL,
  `logo` varchar(250) NOT NULL,
  `active` enum('Y','N') NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`social_media_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_subscribers`;
CREATE TABLE IF NOT EXISTS `multicart_subscribers` (
  `nl_subscribersID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `nl_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nl_subscribersID`),
  UNIQUE KEY `nl_subscribersID` (`nl_subscribersID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_taxrate`;
CREATE TABLE IF NOT EXISTS `multicart_taxrate` (
  `Tid` int(20) NOT NULL AUTO_INCREMENT,
  `taxname` varchar(255) DEFAULT NULL,
  `vtaxbase` varchar(40) DEFAULT NULL,
  `vCountry` varchar(255) DEFAULT NULL,
  `vState` text,
  `ntaxrate` float NOT NULL DEFAULT '0',
  `vtaxaddress` enum('shipping','billing') NOT NULL DEFAULT 'shipping',
  `rate_enable` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`Tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_template_master`;
CREATE TABLE IF NOT EXISTS `multicart_template_master` (
  `ntemplate_id` int(11) NOT NULL AUTO_INCREMENT,
  `vtemplate_name` varchar(50) NOT NULL DEFAULT '',
  `vtop_filename` varchar(50) NOT NULL DEFAULT '',
  `vleft_filename` varchar(50) NOT NULL DEFAULT '',
  `vbottom_filename` varchar(50) NOT NULL DEFAULT '',
  `vimages_folder` varchar(250) NOT NULL DEFAULT '',
  `vcss_name` varchar(100) NOT NULL DEFAULT '',
  `vcss_original` varchar(100) NOT NULL DEFAULT '',
  `vactive_status` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`ntemplate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `multicart_users`;
CREATE TABLE IF NOT EXISTS `multicart_users` (
  `user_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varchar(100) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `first_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `address1` varchar(100) DEFAULT NULL,
  `address2` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `fax` varchar(100) DEFAULT NULL,
  `zip` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_registered` date DEFAULT NULL,
  `affiliate_id` bigint(20) DEFAULT NULL,
  `deleted` char(1) DEFAULT 'N',
  `newsLetter` char(1) NOT NULL DEFAULT 'N',
  `vaff_type` varchar(10) DEFAULT NULL,
  `device_id` varchar(255) DEFAULT NULL,
  `is_seller` enum('Y','N') DEFAULT 'N' COMMENT 'seller account activated or not',
  `seller_id` int(11) DEFAULT NULL COMMENT 'save previleged seller id',
  `ip_address` varchar(100) DEFAULT NULL COMMENT 'ip address of user',
  `ip_location` varchar(255) DEFAULT NULL COMMENT 'country , state,city',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

DROP TABLE IF EXISTS `multicart_usps_settings`;
CREATE TABLE IF NOT EXISTS `multicart_usps_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(40) NOT NULL DEFAULT '',
  `server` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

DROP TABLE IF EXISTS `multicart_us_states`;
CREATE TABLE IF NOT EXISTS `multicart_us_states` (
  `state_id` int(10) NOT NULL AUTO_INCREMENT,
  `state_name` varchar(100) DEFAULT NULL,
  `state_abbr` varchar(50) DEFAULT NULL,
  `country_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`state_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='store us states list';

DROP TABLE IF EXISTS `multicart_sections`;
CREATE TABLE `multicart_sections` (
  `section_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_name` varchar(100) NOT NULL,
  `avatar` varchar(250) DEFAULT NULL,
  `status` enum('Y','N') NOT NULL DEFAULT 'Y',
  `alias` varchar(100) DEFAULT NULL,
  `cdn_images_moved` enum('Y','N') DEFAULT 'N',
  PRIMARY KEY (`section_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `multicart_section_category`;
CREATE TABLE `multicart_section_category` (
  `section_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`section_category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `multicart_combo`;
CREATE TABLE `multicart_combo` (
  `combo_id` int(11) NOT NULL AUTO_INCREMENT,
  `combo_name` varchar(100) NOT NULL,
  `status` enum('Y','N') NOT NULL DEFAULT 'Y',
  `alias` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`combo_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `multicart_combo_products`;
CREATE TABLE `multicart_combo_products` (
  `combo_products_id` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `combo_id` int NOT NULL,
  `products_id` int NOT NULL
) ENGINE='MyISAM' COLLATE 'utf8_general_ci';

ALTER TABLE `multicart_settings`
ADD COLUMN `enable_recommendation` CHAR(1) NOT NULL DEFAULT 'N' AFTER `enable_google`,
ADD COLUMN `recommendation_licence_value` TEXT NOT NULL AFTER `google_adsense_value`;

ALTER TABLE `multicart_settings`
ADD `enable_sectioncategory` varchar(10) COLLATE 'utf8_general_ci' NOT NULL DEFAULT 'N' AFTER `enable_bulkupload`;

ALTER TABLE `multicart_products`
ADD `product_section` text NULL AFTER `product_category`;

ALTER TABLE `multicart_combo`
ADD `quantity` int(11) NOT NULL AFTER `combo_name`;

ALTER TABLE `multicart_combo`
ADD `price` float NOT NULL AFTER `quantity`;

ALTER TABLE `multicart_combo`
ADD `avatar` varchar(250) COLLATE 'utf8_general_ci' NULL AFTER `price`,
ADD `cdn_images_moved` enum('Y','N') COLLATE 'utf8_general_ci' NULL DEFAULT 'N';

ALTER TABLE `multicart_combo_products`
CHANGE `products_id` `product_id` int(11) NOT NULL AFTER `combo_id`,
ADD `product_option_id` int(11) NOT NULL;

ALTER TABLE `multicart_combo_products`
ADD `product_quantity` int(11) NOT NULL DEFAULT '1' AFTER `product_option_id`;

ALTER TABLE `multicart_cart`
ADD COLUMN `combo_id` INT(11) NULL DEFAULT NULL AFTER `subscription_duration`;

ALTER TABLE `multicart_combo`
ADD COLUMN `seller_id` int(11) DEFAULT NULL;

ALTER TABLE `multicart_order_details`
ADD COLUMN `combo_id` int(11) DEFAULT NULL;

ALTER TABLE `multicart_combo`
ADD `combo_description` TEXT NOT NULL AFTER `combo_name`;

ALTER TABLE `multicart_settings`
ADD `cloudfront_cdn_url` varchar(255) NULL AFTER `enable_amazon_cdn_images`;

ALTER TABLE `multicart_settings`
ADD `enable_megamenu` varchar(100) DEFAULT 'N' NOT NULL ;

ALTER TABLE `multicart_settings`
ADD `enable_cookie` varchar(100) DEFAULT 'N' NOT NULL ;

ALTER TABLE `multicart_settings`  ADD `stripe_connect_payment_enable` ENUM('Y','N') NOT NULL DEFAULT 'N'  AFTER `enable_cookie`,  ADD `stripe_connect_publish_key` VARCHAR(255) NOT NULL  AFTER `stripe_connect_payment_enable`,  ADD `stripe_connect_secretkey` VARCHAR(255) NOT NULL  AFTER `stripe_connect_publish_key`,  ADD `stripe_connect_client_id` VARCHAR(255) NOT NULL  AFTER `stripe_connect_secretkey`;

ALTER TABLE `multicart_artists` ADD `stripe_user_id` VARCHAR(255) NOT NULL AFTER `ip_location`;

ALTER TABLE `multicart_artists` ADD `stripe_account_synched` ENUM('YES','NO') NOT NULL DEFAULT 'NO' AFTER `stripe_user_id`;