<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		          |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com (c) 2005              |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php


//echo date('Y/m/d H:i:s')."<br>";
//echo "timezone--------->".date_default_timezone_get();

include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

if (isset($_SESSION["sess_artistid"]) and $_SESSION["sess_artistid"] != "") {
    $artistid = $_SESSION["sess_artistid"];
} else {
    header("Location:login.php");
    exit;
}
if(checkArtistExpired($artistid)){
    header("Location:seller_plan_upgrade.php?sellerid=".$artistid);
    exit;
}
/*
 * Orders
 */

$sql = "SELECT o.*,CONCAT(o.billing_first_name, ' ' ,o.billing_last_name) as user_name, od.product_discount,sum( (od.product_price-(od.product_price*product_discount/100)) * od.product_quantity) as total,sum(od.product_tax)as taxtotal
FROM " . $tableprefix . "orders o
INNER JOIN " . $tableprefix . "order_details od ON o.order_id = od.order_id
WHERE od.artist_id = :artistid AND o.vpayment_status != 'P' GROUP BY o.order_id ORDER BY o.order_id DESC LIMIT 0,5";

               // echo $sql;

$orderResult = $pdo->pdoQuery($sql,array("artistid"=>$artistid))->results();

//echo "ordr result--->";echo "<pre>";print_r($orderResult);
/*
 * Orders - End
 */

/*
 * Review
 */
$revSql = "SELECT r.vDes,u.user_name,p.product_name
FROM " . $tableprefix . "Review r
LEFT JOIN " . $tableprefix . "users u ON r.nUserId=u.user_id
LEFT JOIN " . $tableprefix . "products p ON r.nProdId=p.product_id
WHERE p.product_artist_id= :sess_artistid AND r.vActive = '1' ORDER BY r.nRId DESC LIMIT 0,1";
$reviewResult = $pdo->pdoQuery($revSql,array("sess_artistid"=>$_SESSION['sess_artistid']))->results();
/*
 * Review-End
 */

//Counts
$reviewCount = 0;
$ordersToBeShippedCount = 0;

$refundCount = 0;
$unpublishedProducts = 0;

$revCountSql = "SELECT COUNT(r.nRId) AS totalcount
FROM " . $tableprefix . "Review r
LEFT JOIN " . $tableprefix . "products p ON r.nProdId=p.product_id
WHERE p.product_artist_id= :sess_artistid
AND r.vActive = '0' AND p.deleted != 'Y'";

$CountRevResult = $pdo->pdoQuery($revCountSql,array("sess_artistid"=>$_SESSION['sess_artistid']))->results();

if (count($CountRevResult) > 0) {
    $revRow = ($CountRevResult[0]);
    $reviewCount = ($revRow['totalcount'])?$revRow['totalcount']:0;
}

$productCountSql = "SELECT COUNT(product_id) AS totalcount
FROM " . $tableprefix . "products p
WHERE p.product_artist_id= :sess_artistid
AND p.publish_status = 'N' AND product_category != 1 AND deleted != 'Y'";

//echo $_SESSION['sess_artistid'];


$productCountResult = $pdo->pdoQuery($productCountSql,array("sess_artistid"=>$_SESSION['sess_artistid']))->result();
if (count($productCountResult) > 0) {
    $unPublishCount = $productCountResult['totalcount'];
}


/* $ordCountSql = "SELECT DISTINCT count(o.order_id) as totalcount
  FROM ".$tableprefix."orders o
  INNER JOIN ".$tableprefix."users u ON o.user_id = u.user_id
  INNER JOIN ".$tableprefix."order_details od
  ON o.order_id=od.order_id
  INNER JOIN ".$tableprefix."order_status os
  ON od.item_status=os.order_status_id AND os.order_status_id='1'
  WHERE od.artist_id='".$artistid."'
  AND o.vpayment_status != 'P' GROUP BY o.order_id ORDER BY o.order_id"; */

  $qryopt .= " AND o.vorder_currency = cm.vcurrency_code";
  $ordCountSql = "SELECT o.order_id
  FROM " . $tableprefix . "currency_master cm," . $tableprefix . "orders o
  INNER JOIN " . $tableprefix . "order_details od ON o.order_id = od.order_id
  INNER JOIN " . $tableprefix . "order_status os ON od.item_status = os.order_status_id AND os.order_status_id='1'
  WHERE od.artist_id = :artistid
  AND o.vpayment_status != 'P'" . $qryopt;
  $ordCountSql.=" GROUP BY o.order_id ORDER BY o.order_id DESC ";

  $CountOrdResult = $pdo->pdoQuery($ordCountSql,array("artistid"=>$artistid))->results();

  if (count($CountOrdResult) > 0) {
    $ordRow = ($CountOrdResult[0]);
    //$ordersToBeShippedCount = $ordRow->totalcount;
    $ordersToBeShippedCount = count($CountOrdResult);
}


$sql = "select count(r.refund_id) as totalcount
from " . $tableprefix . "refunds r
INNER JOIN " . $tableprefix . "orders o
ON o.order_id=r.order_id
where r.Status is NULL AND r.seller_id=:artistid";



$CountRefundResult = $pdo->pdoQuery($sql,array("artistid"=>$artistid))->results();
if (count($CountRefundResult) > 0) {
    $ordRow = ($CountRefundResult[0]);
    $refundCount = $ordRow['totalcount'];
}
/*
 * Order Counts Start
 */




$sqlOrdCnt = "SELECT o.order_id
FROM " . $tableprefix . "orders o
INNER JOIN " . $tableprefix . "order_details od ON o.order_id = od.order_id
WHERE od.artist_id = :artistid ";

//Today
$totalOrdersTodayCount = 0;

$condition = "AND o.vpayment_status='C' AND o.order_date = DATE(NOW()) GROUP BY o.order_id";
$sqlOrdCnt .= $condition;

$orderCntResult = $pdo->pdoQuery($sqlOrdCnt,array("artistid"=>$artistid))->results();
if (count($orderCntResult) > 0) {
    $ordCntRow = ($orderCntResult[0]);
    $totalOrdersTodayCount = count($orderCntResult);
}

//Week
$totalOrdersWeekCount = 0;
$sqlOrdCnt = "SELECT o.order_id
FROM " . $tableprefix . "orders o
INNER JOIN " . $tableprefix . "order_details od ON o.order_id = od.order_id
WHERE od.artist_id = :artistid ";
$condition = "AND o.vpayment_status='C' AND YEARWEEK(o.order_date) = YEARWEEK(NOW())  GROUP BY o.order_id";
$sqlOrdCnt .= $condition;

$orderCntResult = $pdo->pdoQuery($sqlOrdCnt,array("artistid"=>$artistid))->results();
if (count($orderCntResult) > 0) {
    $ordCntRow = ($orderCntResult[0]);
    $totalOrdersWeekCount = count($orderCntResult);
}

//Month
$totalOrdersMonthCount = 0;
$sqlOrdCnt = "SELECT o.order_id
FROM " . $tableprefix . "orders o
INNER JOIN " . $tableprefix . "order_details od ON o.order_id = od.order_id
WHERE od.artist_id = :artistid ";
$condition = " AND o.vpayment_status='C' AND date_format(o.order_date,'%Y%m') = date_format(NOW(),'%Y%m')  GROUP BY o.order_id";
$sqlOrdCnt .= $condition;

$orderCntResult = $pdo->pdoQuery($sqlOrdCnt,array("artistid"=>$artistid))->results();
if (count($orderCntResult) > 0) {
    $ordCntRow = ($orderCntResult[0]);
    $totalOrdersMonthCount = count($orderCntResult);
}

//Last Month
$totalOrdersLastMonthCount = 0;
$sqlOrdCnt = "SELECT o.order_id
FROM " . $tableprefix . "orders o
INNER JOIN " . $tableprefix . "order_details od ON o.order_id = od.order_id
WHERE od.artist_id = :artistid ";

$condition = " AND o.vpayment_status='C' AND date_format(o.order_date,'%Y%m') = date_format(NOW() - INTERVAL 1 MONTH, '%Y%m')   GROUP BY o.order_id";
$sqlOrdCnt .= $condition;

$orderCntResult = $pdo->pdoQuery($sqlOrdCnt,array("artistid"=>$artistid))->results();
if (count($orderCntResult) > 0) {
    $ordCntRow = ($orderCntResult);
    $totalOrdersLastMonthCount = count($orderCntResult);
}

if ($totalOrdersLastMonthCount == 0) {
    $totalOrdersChangeCount = $totalOrdersMonthCount;
} else if ($totalOrdersMonthCount == 0) {
    $totalOrdersChangeCount = '-' . $totalOrdersLastMonthCount;
} else {
    $totalOrdersChangeCount = ( ( $totalOrdersMonthCount - $totalOrdersLastMonthCount ) / $totalOrdersLastMonthCount ) * 100;
}
//$totalOrdersChangeCount = number_format( $totalOrdersChangeCount,2,".","");



/*
 * Order Counts End
 */
//Counts - End
//Amounts

$sellerAmountPending = 0;
$sql = "SELECT sum( ((od.product_price-(od.product_price*product_discount/100)) - (od.product_price*a.commission/100)) * od.product_quantity)
as totalamount
FROM " . $tableprefix . "order_details od
inner join " . $tableprefix . "orders o ON o.order_id = od.order_id
AND o.vpayment_status != 'P'
AND o.order_status = 4
inner join " . $tableprefix . "artists a ON od.artist_id = a.artist_id
WHERE od.artist_id = :artistid
AND od.artist_payment_status = 0";

$orderAmntResult = $pdo->pdoQuery($sql,array("artistid"=>$artistid))->results();


if (count($orderAmntResult) > 0) {
    $row = ($orderAmntResult[0]);
    $sellerAmountPending = $row['totalamount'];
    $sellerAmountPending = $sellerAmountPending > 0 ? $sellerAmountPending : 0;
}

$sellerAmountSettled = 0;
$sql = "SELECT SUM(ap.amount_paid) AS totalamount FROM " . $tableprefix . "artist_payments ap
WHERE ap.artist_id = :artistid";

$orderAmntResult = $pdo->pdoQuery($sql,array("artistid"=>$artistid))->results();

if (count($orderAmntResult) > 0) {
    $row = ($orderAmntResult[0]);
    $sellerAmountSettled = $row['totalamount'];
}


//Amounts - End
//Categories
//

$totalCategories = 0;
$sql = "SELECT COUNT(category_id) AS total FROM " . $tableprefix . "categories
WHERE  gift_certificate_flag != 'Y'";

//parent_id = '".addslashes($catid)."' AND

$orderAmntResult = $pdo->pdoQuery($sql)->results();

if (count($orderAmntResult) > 0) {
    $row = ($orderAmntResult[0]);
    $totalCategories = $row->total;
}


$sql = "SELECT COUNT(prd.product_id) AS total
FROM " . $tableprefix . "products prd
WHERE prd.product_artist_id = :sess_artistid AND deleted  ='N' ";
//vapproved='Y' AND
$orderAmntResult = $pdo->pdoQuery($sql,array("sess_artistid"=>$_SESSION["sess_artistid"]))->results();

if (count($orderAmntResult) > 0) {
    $row = ($orderAmntResult[0]);
    $totalProducts = $row['total'];
}

//Categories - End
//Messages Count
$newMessages = 0;
$sql = "SELECT COUNT(message_to_seller_id) AS total
FROM " . $tableprefix . "message_to_seller
WHERE artist_id = :sess_artistid AND `read` ='N'";

$orderAmntResult = $pdo->pdoQuery($sql,array("sess_artistid"=>$_SESSION["sess_artistid"]))->results();

if (count($orderAmntResult) > 0) {
    $row = ($orderAmntResult[0]);
    $newMessages = $row['total'];
}

$cms_content_terms = displayCMS('seller_home_text');
//Messages Count - End
include "../includes/htmltop1.php";
?>


<body>
    <div class="main_outer">
        <!--header area start -->
        <?php include_once("../includes/topheader_sellerNew.php"); ?>
        <!--header area end -->
        <!--     <div align="left" class="main_body"> -->
        <div class="clearfix"></div>

        <?php /*/////////////////////////Contant Area Starts //Manu R S - 21/09/17 */?>
        <div class="contant_area">

            <!--main body start -->
            <?php
            include_once("../includes/artisttopmenuNew.php")
            ?>
            <!-- ***************************************************************** -->
            <div class="right_main_cont_outer">
             <div class="right_main_cont_inner">


                <div align="left" class="content_area">
                    <div class="seller_dashboard_newdesign">
                    <!--<div align="left" class="welcome_box">
                            <div align="center" class="wecome_txt_area"><?php echo WELCOME_TEXT; ?>&nbsp;<?php echo getArtistName($artistid); ?></div>
                        </div>-->
                        <div class="dashboard_leftcolumn">
                            <div class="dashboard_welcome">
                                <h2><?php echo stripslashes($cms_content_terms[0]) ?></h2>
                                <p><?php echo stripslashes($cms_content_terms[1]) ?></p>

                            </div>
                            <div class="add_prdctsnearnmoney">
                                <div class="dashboard_add_prdcts">
                                    <h2><?php echo TEXT_ADD_PRODUCT; ?></h2>
                                    <div class="add_prdctsnearnmoney_content">
                                        <img src="../images/icon_product.gif">
                                        <p><?php echo TEXT_ADD_PRODUCT; ?></p>
                                        <div class="clear"></div>
                                    </div>
                                </div>
                                <div class="dashboard_earn_money">
                                    <h2><?php echo TEXT_EARN_MONEY; ?></h2>
                                    <div class="add_prdctsnearnmoney_content">
                                        <img src="../images/icon_dollar.gif">
                                        <p><?php echo TEXT_RELAX_SENTENCE; ?></p>
                                    </div>
                                </div>
                                <div class="clear"></div>
                            </div>
                            <div class="dashboard_recent_orders">
                                <h2><?php echo TEXT_RECENT_ORDERS; ?></h2>
                                <table width="638" border="0" cellspacing="0" cellpadding="0" class="rcnt_orders table admin_table no_margin">
                                    <tr>
                                        <th valign="top" align="left"><?php echo TEXT_ORDER_ID;?></th>
                                        <th valign="top" align="left"><?php echo TEXT_USER_NAME;?></th>
                                        <th valign="top" align="left"><?php echo TEXT_ORDERS_STATUS;?></th>
                                        <th valign="top" align="left"><?php echo TEXT_DATE_ADDED;?></th>
                                        <th valign="top" align="left"><?php echo TEXT_ORDERS_TOTAL;?></th>
                                        <th width="5%" valign="top" align="left">&nbsp;</th>
                                    </tr>

                                    <?php //if (mysql_num_rows($orderResult) > 0) { ?>
                                    <?php if(!empty($orderResult)){ ?>

                                    <?php
//    while ($ordRow = mysql_fetch_array($orderResult)) {
                                    foreach ($orderResult as $ordRow){

                                        $itemTotal  =  $ordRow["total"];

                                        if($ordRow['vgiftcertificate_code']!='' && $ordRow['nused_gift_amount']!=0 )
                                        {

                                            $giftDiscountAmount         =   $ordRow['nused_gift_amount'];

                   // $itemTotal                  =   $itemTotal - $giftDiscountAmount; commented this line to show price without gift certificate

                                        }

                                        $couponCodeDiscountAmount           =   0;

                                        if(($artistid==$ordRow['couponCodeSeller_Id']) && ($ordRow['couponCodeDiscount']>0))
                                        {
                                            $couponCodeDiscountAmount       =   $ordRow['couponCodeDiscount'];
               // $itemTotal                      =   $itemTotal - $couponCodeDiscountAmount; commented this line to show price without  coupon amount.

                                        }

       // $orderTotal = $itemTotal + $ordRow["taxtotal"];
                                        $orderTotal = $itemTotal + $ordRow["taxtotal"];

        // added for including the shipping total
                                        $totalshippingcost = 0;
//        $select_shipping_cost = "SELECT sd.vshipping_name, sd.nshipping_cost
//                           FROM " . $tableprefix . "shipping_details sd
//                           WHERE sd.norder_id = ".$ordRow['order_id']." AND sd.seller_id = '".addslashes($artistid)."' AND  sd.nshp_status = 'C'  ";
                                        $select_shipping_cost = "SELECT sd.vshipping_name, sd.nshipping_cost
                                        FROM " . $tableprefix . "shipping_details sd
                                        WHERE sd.norder_id =:orderId AND sd.seller_id = :sellerId AND  sd.nshp_status = 'C'  ";

//        $result_shipping_cost = mysql_query($select_shipping_cost);
                                        $result_shipping_cost = $pdo->pdoQuery($select_shipping_cost, array("orderId" => $ordRow['order_id'], "sellerId" => addslashes($artistid)))->results();
//        if (mysql_num_rows($result_shipping_cost) > 0) {
                                        if(!empty($result_shipping_cost)){
                                            $totalshippingcost = 0;
//            while ($shipping_row = mysql_fetch_array($result_shipping_cost)) {
                                            foreach($result_shipping_cost as $shipping_row){
                                                $totalshippingcost+=$shipping_row['nshipping_cost'];
                                            }
                                        }
                                        $orderTotal += $totalshippingcost;

                                        $link = 'vieworder.php?orderid=' . $ordRow["order_id"];
                                        ?>
                                        <tr>
                                            <td valign="top" align="left"><?php echo htmlentities($ordRow["order_id"]); ?></td>
                                            <td valign="top" align="left"><?php echo ($ordRow["user_name"]); ?></td>
                                            <td valign="top" align="left"><?php echo getArtistOrderStatus($ordRow["order_id"], $artistid); ?></td>
                                            <td valign="top" align="left"><?php echo dateFormat($ordRow["order_date"], "Y-m-d", "m/d/Y") ?></td>
                                            <td valign="top" align="left"><?php echo $adminCurrency['currency_symbol']; ?><?php echo htmlentities(number_format($orderTotal, 2, '.', '')); ?></td>
                                            <td><a href="<?php echo $link; ?>"><?php echo LINK_VIEW; ?></a></td>

                                        </tr>
                                        <?php } ?>
                                        <?php } else { ?>
                                        <tr>
                                            <td valign="top" colspan="6" align="left"><?php echo TEXT_NO_ORDER; ?></td>
                                        </tr>
                                        <?php } ?>
                                    </table>
                                    <a href="orders.php"><?php echo LINK_VIEW_ALL_ORDER; ?></a>
                                </div>
                                <div class="rcnt_prdctreviews">
                                    <h2><?php echo TEXT_PRODUCT_REVIEW; ?></h2>
                                    <?php
                                    if (count($reviewResult) > 0) {
                                        $reviewRow = ($reviewResult[0])
                                        ?>
                                        <table width="638" border="0" cellspacing="0" cellpadding="0" class="prdct_review table admin_table no_margin">
                                            <tr>
                                                <td width="93" align="left" valign="top" class="text_hilite1"><?php echo TEXT_REVIEW; ?></td>
                                                <td width="10" align="left" valign="top" class="text_hilite1">:</td>
                                                <td width="535" align="left" valign="top">
                                                    <?php echo nl2br(htmlentities(stripslashes($reviewRow["vDes"]))); ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td valign="top" align="left" class="text_hilite1"><?php echo TEXT_POSTEDBY; ?></td>
                                                <td valign="top" align="left" class="text_hilite1">:</td>
                                                <td valign="top" align="left"><?php echo ($reviewRow["user_name"]); ?></td>
                                            </tr>
                                            <tr>
                                                <td valign="top" align="left" class="text_hilite1"><?php echo TEXT_PRODUCT; ?></td>
                                                <td valign="top" align="left" class="text_hilite1">:</td>
                                                <td valign="top" align="left"><?php echo (stripslashes($reviewRow["product_name"])); ?></td>
                                            </tr>
                                        </table>
                                        <a href="product_reviews.php"><?php echo LINK_VIEW_ALL_REVIEW; ?></a>
                                        <?php } else {
                                            ?>
                                            <p><?php echo TEXT_NO_REVIEW; ?></p>
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="dashboard_rightcolumn">
                                        <div class="dashboard_catalogue">
                                            <div class="brdrcrnr_topleft"></div>
                                            <div class="brdrcrnr_topright"></div>
                                            <div class="brdrcrnr_btmleft"></div>
                                            <div class="brdrcrnr_btmright"></div>

                                            <h3><?php echo TEXT_CATALOG; ?></h3>

                                            <div class="catalogue_cnt">
                                                <img src="../images/catelogue_icon.png">
                                                <p><?php echo TEXT_CATALOG_CONTAINS; ?> <span class="text_hilite1"><?php echo $totalCategories; ?></span> <?php echo TEXT_CATEGORIES_AND;?> <span class="text_hilite1">  <?php echo $totalProducts; ?></span> <?php echo TEXT_PRODUCTS; ?></p>
                                                <a href="mycatalog.php"><span><?php echo LINK_VIEW_CATALOG; ?></span></a>
                                            </div>
                                            <div class="clear"></div>
                                        </div>
                                        <div class="quick_links">
                                            <div class="brdrcrnr_topleft"></div>
                                            <div class="brdrcrnr_topright"></div>
                                            <div class="brdrcrnr_btmleft"></div>
                                            <div class="brdrcrnr_btmright"></div>

                                            <ul>
                                                <li class="review_icn"><a href="product_reviews.php"><?php echo LINK_REVIEW_APPR ; ?><span>(<?php echo $reviewCount; ?>)</span></a></li>
                                                <li class="rma_icn"><a href="list_refunds.php"><?php echo LINK_RMA_APPR; ?> <span>(<?php echo $refundCount; ?>)</span></a></li>
                                                <li class="mail_icn"><a href="messages.php"><?php echo LINK_MAIL_USER; ?>  <span>(<?php echo $newMessages; ?>)</span></a></li>
                                                <li class="ordr_icn no_brdr"><a href="orders.php?status=1"><?php echo LINK_ORDER_SHIP ; ?><span>(<?php echo $ordersToBeShippedCount; ?>)</span></a></li>
                                                <li class="approv_publish_icon"><a href="myproducts.php"><?php echo LINK_UN_PUBLISHED ; ?><span>(<?php echo $unPublishCount; ?>)</span></a></li>
                                            </ul>

                                        </div>
                                        <table width="315" border="0" cellspacing="0" cellpadding="0" class="ordr_listing_right table admin_table no_margin">
                                            <tr class="hdr">
                                                <th valign="top" align="left"><?php echo TEXT_ORDERS; ?></th>
                                                <th valign="top" align="right"><a href="orders.php"><?php echo LINK_VIEW_ALL;?></a></th>
                                            </tr>
                                            <tr>
                                                <td align="left" valign="top"><?php echo TEXT_TODAY; ?></td>
                                                <td align="left" valign="top" class="text_hilite1">: &nbsp;<?php echo $totalOrdersTodayCount; ?></td>
                                            </tr>
                                            <tr>
                                                <td align="left" valign="top"><?php echo TEXT_THIS_WEEK ; ?></td>
                                                <td align="left" valign="top" class="text_hilite1">: &nbsp;<?php echo $totalOrdersWeekCount; ?></td>
                                            </tr>
                                            <tr>
                                                <td align="left" valign="top"><?php echo TEXT_THIS_MONTH; ?></td>
                                                <td align="left" valign="top" class="text_hilite1">: &nbsp;<?php echo $totalOrdersMonthCount; ?></td>
                                            </tr>
                                            <tr>
                                                <td align="left" valign="top"><?php echo TEXT_LAST_MONTH; ?></td>
                                                <td align="left" valign="top" class="text_hilite1">: &nbsp;<?php echo $totalOrdersLastMonthCount; ?></td>
                                            </tr>
                                            <tr>
                                                <td align="left" valign="top"><?php echo TEXT_CHANGE; ?></td>
                                                <td align="left" valign="top" class="text_hilite1">: &nbsp;<?php echo $totalOrdersChangeCount; ?></td>
                                            </tr>
                                            <tr>
                                                <td align="left" valign="top"><?php echo TEXT_AMT_PEND; ?></td>
                                                <td align="left" valign="top" class="text_hilite1">: &nbsp;<?php echo $adminCurrency['currency_symbol']; ?><?php echo number_format($sellerAmountPending, 2, '.', ''); ?></td>
                                            </tr>
                                            <tr>
                                                <td align="left" valign="top"><?php echo TEXT_AMT_SETTLE; ?></td>
                                                <td align="left" valign="top" class="text_hilite1">: &nbsp;<?php echo $adminCurrency['currency_symbol']; ?><?php echo number_format($sellerAmountSettled, 2, '.', ''); ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>


                                <!--content area start -->



                                <div class="clear"></div>
                                <!--content area ends -->
                            </div>






                            <div align="lemain_bodyft" class="clear_float"><img src="images/clear_admin.gif" alt="" width="1" height="1" /></div>
                            <!--main body end -->
                            <div class="clear"></div>
                        </div>
                    </div>
                </div>



                <?php
                include "../includes/footer_sellers.php";
                ?>
