<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		              |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+

include "includes/config.php";
include "includes/session.php";
include "includes/functions.php";
include "classes/cls_order.php";
include_once "classes/cls_combopack.php";

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

if(isset( $_SESSION["sess_userid"]) and $_SESSION["sess_userid"]!= ""){
	$userid = $_SESSION["sess_userid"];
}else{
	header("Location:login.php");
	exit;
}
$message = '';
$adminCurrency	= GetAdminCurrency();

$currencySymbol	=$adminCurrency['currency_symbol'];

if(isset( $_GET["orderid"]) and $_GET["orderid"]!= ""){
	$orderid = $_GET["orderid"];
}else if(isset( $_POST["orderid"]) and $_POST["orderid"]!= ""){
	$orderid = $_POST["orderid"];
}else{
	header("Location:orders.php");
	exit;
}

$gift_certificate=0;

$itemlist = isset($_POST["chkitems"])?$_POST["chkitems"]:'';
$ddlStatus = isset($_POST["ddlStatus"])?$_POST["ddlStatus"]:'';

$btn = '';
foreach ($_POST as $key =>$value){

	if($value == GO_BUTTON){
		$btn = $key;
		break;
	}

}


if(isset($_POST[$btn]) && $_POST[$btn] == GO_BUTTON){
	$ar = explode("_",$btn );
	$sid = $ar[1] ;
	$ddl = "ddlStatus_".$sid;
	$status = $_POST[$ddl];
			//echo $sql;exit;
        $update = $pdo->update($tableprefix.'order_details', array('item_status' =>$status), array('order_id'=>$orderid,'artist_id'=>$sid))->affectedRows();                        
        
		// Update Item Delivery Time
		if($status=="4")
		{
		
                                $sql_deliverytime_up = $pdo->update($tableprefix.'order_details', array('item_delivery_date' =>date("Y-m-d H:i:s")), array('order_id'=>$orderid,'artist_id'=>$sid))->affectedRows();                        
                                
                                $orderstatus_new = getArtistOrderStatus($orderid, $sid);

				sendOrderStatusChangeMailToSeller($orderid,$sid,$_SESSION["sess_userid"],$orderstatus_new);
		}
		
		// End 

}

//if($_POST["btnGo"] == "Go"){
if(isset($_POST["btnGo"])){
	$message = "";
	if(!isNotNull($itemlist)){
		$message .= SELECT_ITEM_TEXT." <br>";
	}else{
		$ilist = implode(",",$itemlist );
	}
        list($qarr,$qstr) = getInQueryString($ilist);
	if($message  == ""){
            $qarrArr = $qarr;
            $qarrArr['item_status'] = $ddlStatus;
		$sql ="UPDATE  ".$tableprefix."order_details SET
		item_status = :item_status WHERE order_detail_id IN ($qstr)";
		$res = $pdo->pdoQuery($sql,$qarr); 		
		if($ddlStatus=="4")
		{
		
			$sql_deliverytime_up = "UPDATE  ".$tableprefix."order_details SET item_delivery_date =now()
							WHERE order_detail_id IN ($qstr)";
			
			$pdo->pdoQuery($sql_deliverytime_up,$qarr); 				
			
		}


		$message = CHANGE_SAVE_SUCCESS_TEXT."<br>";
	}else{
		 $message = "<br>".CORRECT_ERRORS_TEXT."<br>" . $message;
	}

}

if(isset($_GET["msg"]) and $_GET["msg"]!=""){
	$msg = $_GET["msg"];
	switch($msg){
		case "deleted": $message = MSG_USER_DELETED;break;
		default:
			;
	} // switch

}
$artistlist = getOrderArtists($orderid);
$artists = explode(",",$artistlist );

$order_flag = 0;

$rs_q=$pdo->select($tableprefix.'settings','','')->results();  
$rr_settings=$rs_q[0];


  
   //$sql=      "SELECT o.*,sum( (od.product_price-(od.product_price*product_discount/100)) * od.product_quantity) as order_total_price
    $sql=      "SELECT o.* 
			FROM ".$tableprefix."orders o 
			LEFT JOIN ".$tableprefix."order_details od ON od.order_id=o.order_id 
			WHERE o.user_id =:user_id AND o.order_id = :order_id GROUP BY o.order_id ";
$result = $pdo->pdoQuery($sql,array("user_id"=>$_SESSION["sess_userid"],"order_id"=>$orderid))->results();

if(!empty($result))
{
	$prow = $result[0];
	$ordernumber = $prow["order_id"];
	$currencySymbol	=$adminCurrency['currency_symbol'];
	$ordertotal = $prow["order_total_price"];
        $order_total_amount = $prow["order_total_price"];
        $order_taxrate=$prow["taxrate"];
        $couponCodeDiscount=$prow["couponCodeDiscount"];
        if($prow["nused_gift_amount"] >0 || $couponCodeDiscount>0 ) {

           $giftDiscountAmount           = $prow["nused_gift_amount"];

           $couponCodeDiscountAmount = $prow["couponCodeDiscount"];

           $TotalDiscount   = $giftDiscountAmount + $couponCodeDiscountAmount;

           $priceafterdiscount=$ordertotal-$TotalDiscount;

           $ordertotal=number_format($priceafterdiscount,2,".","");

        }
	//$taxrate=$prow["taxrate"];
	$orderdate = $prow["order_date"];
	$orderdate = dateFormat($orderdate,"Y-m-d","m/d/Y");
	$userid = $prow["user_id"];
	
	$exchange_price = isset($prow["nexchange_price"])?$prow["nexchange_price"]:0;
	
	$netTotal=$ordertotal;

}
/*---------Multicart 2.0 Upgradation---------*/
else
{
	$order_flag = 1;
}

$totalshippingAmount = 0;

$totalshippingAmount      =    Order::orderShippingCost($orderid);
$taxtotal                =      Order::getorderTaxTotal($orderid);
$ordertotal=$ordertotal+$totalshippingcost+$taxtotal;

$taxrate                =  $taxtotal;

$netTotal   =   $netTotal + $totalshippingAmount+$taxtotal;
/*---------Multicart 2.0 Upgradation---------*/

$statlist= array();
$statlist[4] = DELIVERED_STATUS_TEXT;

/*display the active template*/

$active_template = displayTemplate();


include "includes/htmltop.php";

/* Top File Name */

include_once ("includes/".$active_template[0]);


/*---------Multicart 2.0 Upgradation---------*/

$hide_shipping_display = 0;

$select_order = "SELECT prd.product_id 
				 FROM ".$tableprefix."products prd
                                 INNER JOIN ".$tableprefix."order_details ord_det ON ord_det.product_id = prd.product_id
                                 INNER JOIN ".$tableprefix."orders ord ON ord.order_id = ord_det.order_id
                                 WHERE prd.vdigital_product = 'Y'
				  AND ord.order_id =:order_id";
				  
$result_order =$pdo->pdoQuery($select_order,array("order_id"=>$orderid))->results();

if(!empty($result_order))
{

	$hide_shipping_display = 1;

}		

			$select_order_gift = "SELECT prd.product_id 
				 	  FROM ".$tableprefix."products prd
                                          INNER JOIN ".$tableprefix."order_details ord_det ON ord_det.product_id = prd.product_id
                                          INNER JOIN ".$tableprefix."orders ord ON ord.order_id = ord_det.order_id
                                          INNER JOIN ".$tableprefix."categories cat ON prd.product_category = cat.category_id
					  WHERE cat.gift_certificate_flag = 'Y'
					  AND ord.order_id = :order_id";
				  
$result_order_gift = $pdo->pdoQuery($select_order_gift,array("order_id"=>$orderid))->results();

if(!empty($result_order_gift))
{

	$hide_shipping_display = 1;
	$gift_certificate=1;

}	

$hide_shipping_display = 0;
$hide_shipping_display = Order::checkShippingBlockRequiredForOrder($orderid);

/*---------Multicart 2.0 Upgradation---------*/


?>
<SCRIPT>
function confirmDelete(){
	if(confirm('<?php echo CONFIRM_DELETE_TEXT;?>') ){
		return true;
	}
	return false;
}
function confirmStatus(){
	if(confirm('<?php echo CONFIRM_STATUS_CHANGE_TEXT;?>') ){

		return true;
	}
	return false;
}
</SCRIPT>


<!--mainbody area start -->
<div class="main_body">
	<div class="inner_page_container">
		<h1><?php echo ORDER_DETAILS_TEXT;?></h1>
		
		<!--center content area start-->		
		<form name="frmFeedback" action="<?php echo $_SERVER["PHP_SELF"]?>" method="POST">
		<input type="hidden" name="orderid" value="<?php echo htmlentities($orderid);?>">
		
		<div class="clear"></div>
		<div class="col-sm-12 col-lg-12 col-md-12 ">
			<div class="text_information"><?php echo $message?></div>
		</div>
		
<?php
		
/*--------Multicart 2.0 Upgradation------------

confirming whether the order is placed by the logged in user

inorder to avoid the url mangling

*/		
		
if($order_flag == 0) // start of url checking
{								
					
								
?>	

	
		<div class="vieworder_box_main_outer">
			<div class="message"><?php echo $message;?></div>
			<h2><?php echo ORDER_DETAILS_TEXT;?></h2>
			<div class="vieworder_box_outer">
				<?php
                    $orderDeliveryStatus    =    getOrderStatus($orderid);
                    switch ($orderDeliveryStatus)
                    {
                    	case 'Delivered': $orderStatus = DELIVERED_STATUS_TEXT;
                    	break;
                    	case 'Pending': $orderStatus = PENDING_STATUS_TEXT;
                    	break;
                    	case 'Shipped': $orderStatus = SHIPPED_STATUS_TEXT;
                    	break;
                    	case 'Cancelled': $orderStatus = CANCELLED_STATUS_TEXT;
                    	break;
                    	case 'Returned to Seller': $orderStatus = RETURNED_STATUS_TEXT;
                    	break;
                    	case 'Seller Received Back': $orderStatus = RECEIVED_STATUS_TEXT;
                    	break;
                        default :
                            
                        $orderStatus = $orderDeliveryStatus;
                        break;
                    }
                    ?>
			
					<div class="col-xs-12 col-sm-6 col-md-4 col-lg-4 vieworder_box_L_outer">
						<?php echo ORDER_NUM_TEXT;?>
					</div>
					<div class="col-xs-12 col-sm-6 col-md-8 col-lg-8 vieworder_box_R_outer">
						<?php echo $ordernumber;?>
					</div>

					<div class="col-xs-12 col-sm-6 col-md-4 col-lg-4 vieworder_box_L_outer">
						<?php echo ORDER_DATE_TEXT1;?>
					</div>
					<div class="col-xs-12 col-sm-6 col-md-8 col-lg-8 vieworder_box_R_outer">
						<?php echo $orderdate;?>
					</div>

					<div class="col-xs-12 col-sm-6 col-md-4 col-lg-4 vieworder_box_L_outer">
						<?php echo ORDER_TOTAL_TEXT;?>
					</div>
					<div class="col-xs-12 col-sm-6 col-md-8 col-lg-8 vieworder_box_R_outer">
						<div id="totalCost" style="float:left;">
							<?php 
	                        echo $adminCurrency['currency_symbol'];?> <?php 
	                        //echo number_format($netTotal,2,".","" );
	                        echo number_format($order_total_amount+$order_taxrate,2,".","" ); 
	                        ?>
	                    </div>
					</div>
					
					<div class="col-xs-12 col-sm-6 col-md-4 col-lg-4 vieworder_box_L_outer">
						<?php echo ORDER_STATUS_TEXT1;?>
					</div>
					<div class="col-xs-12 col-sm-6 col-md-8 col-lg-8 vieworder_box_R_outer">
						<?php echo $orderStatus; ?>
					</div>
			</div>
		<div class="clearfix"></div>
		</div>
		<div class="clearfix"></div>

		<div class="vieworder_box_main_outer">
			<h2><?php echo ORDER_PART_DETAILS_TEXT;?></h2>
			
			<?php 
				if(isNotNull($artists)){
				$ordermsg = ORDER_CNT_TEXT;
				$ordermsg =str_replace("COUNT",count($artists),$ordermsg);
			  }
			?>
			<div class="vieworder_box_order_containts_outer"><?php echo $ordermsg; ?></div>			
			
		</div>
		
		<div class="shipping_details_outer">
			<h2><?php echo ORDER_PART_TEXT;?> <?php echo $i+1;?></h2>
			<?php
				if(isNotNull($artists)){
					$cartTotal = 0; echo Order::showIconTexts($orderid); //echo "This order contains ".count($artists)." sub order(s)";
					for($i=0;$i< count($artists);$i++){
						?>						
						<div class="order_part_txt_outer">
							<?php echo SELLER_TEXT1;?>: &nbsp;<?php echo stripslashes(getArtistName_Location($artists[$i]));?></b>&nbsp;&nbsp;<?php echo ORDER_STATUS_TEXT;?>&nbsp; <span style="color:red;"><?php 
							switch (getArtistOrderStatus($orderid,$artists[$i]))
							{
								case 'Delivered': $orderStatus = DELIVERED_STATUS_TEXT;
								break;
								case 'Pending': $orderStatus = PENDING_STATUS_TEXT;
								break;
								case 'Shipped': $orderStatus = SHIPPED_STATUS_TEXT;
								break;
								case 'Cancelled': $orderStatus = CANCELLED_STATUS_TEXT;
								break;
								case 'Returned to Seller': $orderStatus = RETURNED_STATUS_TEXT;
								break;
								case 'Seller Received Back': $orderStatus = RECEIVED_STATUS_TEXT;
								break;
							}
							echo $orderStatus;
						   // echo getArtistOrderStatus($orderid,$artists[$i]); ?></span>
						</div>
										   
						<div class="table-responsive">
							<table border="0" width="100%" class="table table-bordered oder_table">
								<tr class="ordheads_heads">
									<td width='3%'> </td>
									<td width='20%'><?php echo PRODUCT_NAME_TEXT1;?></td>
									<td width='10%'><?php echo CODE_TEXT;?></td>
									<td width='8%'><?php echo RATE_TEXT;?></td>
									<td width='6%'><?php echo QTY_TEXT;?></td>
									<td width='6%'><?php echo PRICE_TEXT;?></td>
									<td width='8%'><?php echo DISCOUNT_TEXT;?></td>
									<td width='10%'><?php echo STATUS_TEXT;?></td>
								</tr>
							 
		<?php
		  if($gift_certificate==0)
		  { // check if products are not gifts certificates
			
			 $sql=" SELECT od.*,s.order_status,o.vorder_currency,o.taxrate,gm.ngift_product_id,gm.vgift_coupon_code
														FROM ".$tableprefix."order_details od
					INNER JOIN ".$tableprefix."order_status s ON s.order_status_id = od.item_status
					LEFT JOIN ".$tableprefix."giftcoupon_master gm ON gm.ngift_product_id=od.product_id 
					LEFT JOIN ".$tableprefix."orders o ON o.order_id=od.order_id 
					WHERE  od.order_id = :order_id  AND  (od.artist_id = :artist_id) order by  product_price DESC";
					
		} // end if 			
			//echo $sql . "<br>";
			
			
	if($gift_certificate==1)
		  { //	check if products are not gifts certificates
			  $sql="SELECT od.*,s.order_status,o.vorder_currency,o.taxrate,gm.ngift_product_id,gm.vgift_coupon_code
														FROM ".$tableprefix."order_details od
					INNER JOIN ".$tableprefix."order_status s ON s.order_status_id = od.item_status
					LEFT JOIN ".$tableprefix."giftcertificates gm ON gm.ngift_product_id=od.product_id  AND gm.ngift_order_id=od.order_id
					LEFT JOIN ".$tableprefix."products p ON p.product_id=od.product_id 
					LEFT JOIN ".$tableprefix."orders o ON o.order_id=od.order_id 
					WHERE  od.order_id = :order_id  AND  (od.artist_id = :artist_id) order by  product_price DESC ";
		}				
		
		//echo $sql;
		
			$result1 = $pdo->pdoQuery($sql,array("order_id"=>$orderid,"artist_id"=>$artists[$i]))->results();
									
										//echopre($result1);
										
										//Combo Section Below
										$combo_items=array();
										$combo_crt_id_map='';
										$temp_combo=array();
										foreach ($result1 as $index=>$prd) {

											
											if($prd['combo_id']!='')
											{
												if(!in_array($prd['combo_id'],$temp_combo)){
													$temp_combo[]=$prd['combo_id'];
												$combo_items[$prd['combo_id']]['prd_name'][$prd['product_option_id']]=$prd['product_name'];
												
												$combo_items[$prd['combo_id']]['prd_qty'][$prd['product_option_id']]=$prd['product_quantity'];                                                                
											   $selectCase = array("product_id" => $prd['product_id'],"product_option_id"=>$prd['product_option_id'],"combo_id"=>$prd['combo_id']);
													$result = $pdo->select($tableprefix . "combo_products", "product_quantity", $selectCase)->results();
													//echo"<b>"."qty---------->".$prd['product_quantity'].' - '.$result[0]["product_quantity"].'<br/>';
													$combo_quantity=$prd['product_quantity']/$result[0]["product_quantity"];
													$combo_items[$prd['combo_id']]['quantity']=$combo_quantity;
//                                                                     if(isset($combo_items[$prd['combo_id']]['productoptionids']))
//                                                                    {
//                                                                        $combo_items[$prd['combo_id']]['productoptionids'].="," .$prd['product_option_id'];
//                                                                    }
//                                                                    else {
//                                                                        $combo_items[$prd['combo_id']]['productoptionids']=$prd['product_option_id'];
//                                                                    }
//
										//            if(isset($combo_items[$prd['combo_id']]['cartids']))
										//            {
										//                $combo_items[$prd['combo_id']]['cartids'].="," .$prd['cart_id'];
										//            }
										//            else {
										//                $combo_items[$prd['combo_id']]['cartids']=$prd['cart_id'];
										//            }
												}
											}
										}
                                         
										$combo_details=array();
										foreach($combo_items as $index=>$combos)
										{

										   $combo_details[$index] =  ComboPack::get_combo_details($index);
										   $combo_details[$index]['required_quantity']=$combo_items[$index]['quantity'];
										}
										//Combo Section Above
										//echopre($combo_details);
										
			$k=1;
			$subtotal = 0;
			$ddlStatus = "ddlStatus_".$artists[$i];
			$$ddlStatus = '';
			$ddl = makeDropDownList($ddlStatus,$statlist,$$ddlStatus ,false ,"textbox" , "","" );
			$btnStatus = "btnGo_".$artists[$i];
			$btn = "<input type='submit' value='".GO_BUTTON."' name='".$btnStatus."' class='button'  onClick='return confirmStatus();'> ";
			foreach($result1 as $rw){
				$link = "<a href='editmyproduct.php?productid=".$rw["product_id"]."'>";
				
				$check = "<input type='checkbox' name='chkitems[]' value='" . $rw["order_detail_id"] . "' class='checkbox'> ";
				
				$rate = $rw["product_price"];
				
				$currencySymbol	=$adminCurrency['currency_symbol'];
				$qty = $rw["product_quantity"];
				$artistid = $rw["artist_id"];
				$refund_id=$rw["user_refund_id"];
				$giftid=$rw["ngift_product_id"];
				$productid=$rw["product_id"];
				$price = $rate * $qty;
												
if($rw['digital_product_flag'] == "Y"){           
$product_shipping_cost = $adminCurrency['currency_symbol'].'&nbsp;0.00';;
$shippingName = NO_SHIPPING;
$producttype = DIGITAL_PRODUCT;
}
else{
$product_shipping_cost = ($rw['product_shipping_price']!=0)?$adminCurrency['currency_symbol'].'&nbsp;'.number_format($rw['product_shipping_price'],2,".",""):$adminCurrency['currency_symbol'].'&nbsp;0.00';
$shippingName = ($rw['product_shipping_price']!=0)?$rw['product_shipping_name']:FREE_SHIP_TEXT;
$producttype =  ($rw['subscription_product_flag']=='Y')?SUBSCRIPTION_PRODUCT:NORMAL_PRODUCT;
}
				
													$discount=0;

																		if($rw["product_discount"] !="0") {
																			$discount=($price*$rw["product_discount"]/100);

																		}


																		$discountstr="";

																		if($rw["product_discount"] !="0") {
																			$price=$price-($price*$rw["product_discount"]/100);
																			$discountstr="<br>".strtolower(MAIL_ORDER_TEXT_DISCOUNT)."(".$rw["product_discount"]."%)";
																		}
												if($rw['combo_id']==''){
													$subtotal += $price;
												}
				//$subtotal += $price;
				
				//$taxrate=$rw["taxrate"];
				
				$rate  = number_format($rate,2,".","" );
				$price = number_format($price,2,".","" );
				
				
/*----------Multicart 2.0 Upgradation-----------------------*/								
				
				if($rw["order_status"] != "Cancelled" && getOrderStatus($orderid) != 'Delivered')
				{
				
/*----------Multicart 2.0 Upgradation-----------------------*/																
				
					$txtDdl = CHANGE_STATUS_TEXT."&nbsp;&nbsp;".$ddl."&nbsp;&nbsp;".$btn."&nbsp;";
				}else{
					$txtDdl = "&nbsp;";
				}
				
												if($rw['combo_id']==''){
												?>
				   <tr class="ordheads_table_list">
						<td valign="top" class=""><?php echo $k; ?> </td>
						<td valign="top" align="left" class="" style='word-break:break-all;'><?php echo Order::showDigitalItemIcon($rw["digital_product_flag"]).(generalMethods::html_entity($rw["product_name"])).$discountstr.Order::check_free_ship_product_text($rw["product_id"]); ?>
						
						
						
					 </td>
						<td valign="top" align="left" class="" style='word-break:break-all;'><?php echo generalMethods::html_entity($rw["product_code"]); ?></td>
						<td valign="top" align="left" class=""><?php echo $currencySymbol;?> <?php echo htmlentities($rate); ?></td>
						<td valign="top" align="left" class=""><?php echo htmlentities($qty); ?></td>
						<td align="left" valign="top" class=""><?php echo $currencySymbol;?> <?php echo htmlentities($price); ?></td>
						<td align="left" valign="top" class=""><?php echo $currencySymbol;?><?php echo htmlentities(round($discount,3)); ?></td>                                                                            
						<td valign="top" class=""><?php 
						switch (($rw["order_status"]))
						{
							case 'Delivered': $orderStatus = DELIVERED_STATUS_TEXT;
							break;
							case 'Pending': $orderStatus = PENDING_STATUS_TEXT;
							break;
							case 'Shipped': $orderStatus = SHIPPED_STATUS_TEXT;
							break;
							case 'Cancelled': $orderStatus = CANCELLED_STATUS_TEXT;
							break;
							case 'Returned to Seller': $orderStatus = RETURNED_STATUS_TEXT;
							break;
							case 'Seller Received Back': $orderStatus = RECEIVED_STATUS_TEXT;
							break;
						}echo $orderStatus;
						//echo ($rw["order_status"]); ?>&nbsp;</td>
															  
					</tr>
					
	<tr><td colspan="8"><br><?php if($rw['vgift_coupon_code']!='') {  ?><span class="required"><?php echo GIFT_CERTIFICATE_CODE_TEXT;?> <?php echo $rw['vgift_coupon_code'];?></span><?php } ?></td></tr>

								 <?php
									$k++;
								}
							   $queryOrderDetail_digital = "SELECT gc.vdigital_product_code,gc.ndownload_try,gc.ndownload_expiry,gc.ndownload_expiry_days
		FROM  ".$tableprefix."digital_product gc where gc.ndigital_productid=:ndigital_productid AND gc.ndigital_orderid=:ndigital_orderid ";
								$rs_digital=$pdo->pdoQuery($queryOrderDetail_digital,array("ndigital_productid"=>$rw['product_id'],"ndigital_orderid"=>$orderid))->results();
					   $product_download_details ="";

		$digitalProductRows =  $rs_digital[0];

   if($digitalProductRows>0)
{
$product_download_details_link = "";
 $download_link = "";

 $cnt	=1 ;

foreach($rs_digital as $orderDetailObjdigital)
{

						$download_link = " <br>".DOWNLOAD_LINK_TEXT." ".$cnt." - ".SITE_URL."/digital_product_download.php?download_code=".$orderDetailObjdigital['vdigital_product_code']."\r\n";
	$product_download_details_link = $download_link;

?>
														<tr > <td colspan="8" valign="top" height="40px;" class="" style='word-break:break-all;'>

																<b> <a href="<?php echo SITE_URL ;?>/digital_product_download.php?download_code=<?php echo $orderDetailObjdigital['vdigital_product_code'];?>" target="_blank" class="whitebg"><?php echo $product_download_details_link;?> </a> </b>
															</td></tr>


  <?php
			$cnt++;
			   }

		  }
?>
  

			<?php
			}
						
	//////////////////////////////////////////////////////////////////////////////////////////////
	
     $combo_items_for_display=array();
	foreach ($result1 as $index=>$prd) {

	$combo_items_for_display[$prd['combo_id']]['prd_name'][$prd['product_option_id']]=$prd['product_name'];
	/*$combo_items[$prd['combo_id']]['prd_qty'][$prd['product_option_id']]=$prd['product_quantity'];
	$selectCase = array("product_id" => $prd['product_id'],"product_option_id"=>$prd['product_option_id'],"combo_id"=>$prd['combo_id']);
	$result = $pdo->select($tableprefix . "combo_products", "product_quantity", $selectCase)->results();
	$combo_quantity=$prd['product_quantity']/$result[0]["product_quantity"];
	$combo_items[$prd['combo_id']]['quantity']=$combo_quantity;*/
												
										  
                                        }
                                         
	$cartcombo_items ='';
	foreach ($combo_details as $combo) {
		
		$currency_attributes = displayCurrencyType();
		//print_r($combo);exit;
	  
	 $cartcombo_items .= "," . $combo["combo_id"];
				   $cntt++;
				   $price=$combo["price"];
				   $combo_products='';
				   

					foreach ($combo_items_for_display[$combo["combo_id"]]['prd_name'] as $index=>$prd_name) {
						$combo_products.='<div class="col-xs-9 col-md-8">'.$prd_name.' <i> </i></div>';
					}                                   
				   
				   $digitalFlag='N';
					$discountstr='';
					$optionsStr='';
					$productname=$combo["combo_name"];
					 $conversionRate = ConvertedCurrencyRate($currency_attributes[2]);
					 //print_r($combo["required_quantity"].' - '.$price.' - '.$conversionRate);
					 //exit;
		$converted_price = $combo["required_quantity"]*$price * $conversionRate;

		$rate = $converted_price;
		$freeship_flag_text='';
		 //$total += $converted_price;
		 $subtotal += $converted_price;
					
				   
				   if($activated_seller_id==$combo['seller_id'])
					{
						 $flag_single_account_flag_class   =   'tr_bg_warning';
					}
					else{
						$flag_single_account_flag_class   =   '';
					}
	  

	 
		$product_weight = $combo["required_quantity"] * ComboPack::get_combo_weight($combo["combo_id"]);
	  
		$total_shipping_weight += $product_weight;
				   
												?>
				   <tr>
						<td valign="top" class=""><?php echo $k; ?> </td>
						<td valign="top" align="left" class="" style='word-break:break-all;'><?php echo Order::showDigitalItemIcon($rw["digital_product_flag"]).(generalMethods::html_entity($productname)).$discountstr.Order::check_free_ship_product_text($rw["product_id"]); 
		echo  '<div class="clearfix"></div>';
		echo '<div class="row">'.$combo_products.'</div>';
																?>
						
						
						
					 </td>
						<td valign="top" align="left" class="" style='word-break:break-all;'>Combo product</td>
						<td valign="top" align="left" class=""><?php echo $currencySymbol;?> <?php echo htmlentities($price); ?></td>
						<td valign="top" align="left" class=""><?php echo htmlentities($combo["required_quantity"]); ?></td>
						<td align="left" valign="top" class=""><?php echo $currencySymbol;?> <?php echo htmlentities($converted_price); ?></td>
						<td align="left" valign="top" class=""><?php echo $currencySymbol;?><?php echo htmlentities(round($discount,3)); ?></td>                                                                            
						<td valign="top" class=""><?php 
						switch (($rw["order_status"]))
						{
							case 'Delivered': $orderStatus = DELIVERED_STATUS_TEXT;
							break;
							case 'Pending': $orderStatus = PENDING_STATUS_TEXT;
							break;
							case 'Shipped': $orderStatus = SHIPPED_STATUS_TEXT;
							break;
							case 'Cancelled': $orderStatus = CANCELLED_STATUS_TEXT;
							break;
							case 'Returned to Seller': $orderStatus = RETURNED_STATUS_TEXT;
							break;
							case 'Seller Received Back': $orderStatus = RECEIVED_STATUS_TEXT;
							break;
						}echo $orderStatus;
						//echo ($rw["order_status"]); ?>&nbsp;</td>
															  
					</tr>
														<?php
				   
				$k++;
		$cnt++;
	}
										
										
										
										
										
										
										
										
										
										?>
				</table>
						</div>
		
					<?php 
					$grand_total=$subtotal;
					?>
					<div class="row">
						<div class="col-xs-12 col-sm-6"><?php echo $txtDdl;?></div>
						<div class="col-xs-12 col-sm-6">
							<span class="fright"><?php echo SUB_TOT_TEXT;?>&nbsp;<?php echo $currencySymbol;?> <?php echo number_format($grand_total,2,".","" ); ?></span>
						</div>
					</div>
		
		 
					<?php 
					   $cartTotal+=$grand_total;
					}
					
					
				}
				?>
				
				<div class="clearfix">&nbsp;</div>
				
				<?php							
		
		
		$select_shipping_cost = "SELECT sd.vshipping_name, sd.nshipping_cost,sd.nshp_productname,CONCAT(ar.first_name,' ',ar.last_name)as artist_name
						FROM ".$tableprefix."shipping_details sd
						INNER JOIN ".$tableprefix."artists ar ON ar.artist_id = sd.seller_id                          
						WHERE sd.norder_id = :norder_id AND  nshp_status = 'C' order by ar.artist_name";
		
		$result_shipping_cost = $pdo->pdoQuery($select_shipping_cost,array("norder_id"=>$orderid))->results();
		?>
		<div class="clearfix"></div>
		
		<h2><?php echo SHIP_DETAILS_TEXT;?></h2>
		
		<div class="table-responsive">
			<table width="100%" border="0" cellpadding="3" cellspacing="3" class="table table-bordered oder_table">
			<tr class="ordheads_heads">
			<td><?php echo SELLER;?></td>
			<td><?php echo SHIP_TYPE_TEXT;?></td>
			<td><?php echo SHIPPING_COST_TEXT;?></td>
			</tr>
			<?php
									
			if(!empty($result_shipping_cost))
			{
			foreach($result_shipping_cost as $shipping_row)
			{
			$totalshippingcost+=$shipping_row['nshipping_cost'];		
			?>	
			<tr class="ordheads_table_list"><td><?php echo stripslashes($shipping_row['artist_name']); ?></td>
			<td><?php echo stripslashes($shipping_row['vshipping_name']); ?></td><td><?php echo $currencySymbol;?> <?php echo number_format($shipping_row['nshipping_cost'],2,".","" ); ?></td></tr>
			<?php 
			} // end while 
			} // end if number of rows
			else
			{
			?>
			<tr><td colspan="3" class="text_information"> <?php echo NO_SHIP_DETAILS_TEXT;?></td></tr>
			<tr><td colspan="3">&nbsp; </td></tr>
			<?php
			
			} // ens else
			
			
			?>
			</table>
		</div>
		
		<div class="shipping_details_price_txt"><?php echo PRODUCT_TOT_TEXT;?> <?php echo $currencySymbol;?> <?php echo number_format($cartTotal,2,".","" ); ?></div>
		
		<?php 
		if($prow['couponCodeDiscount']>0){
		
		$carttotal_tmp=$netTotal-$totalshippingcost-$totaltax;
		$priceafterdiscount=$cartTotal-($prow['couponCodeDiscount']);
		$couponCodeDiscountAmount = $prow['couponCodeDiscount'];
		?>
		
		<div class="clearfix">&nbsp;</div>
		
		<div class="shipping_details_price_txt">
			<font color="#FF0000" class="couponpad"><?php echo COUPON_CODE_TEXT1;?>&nbsp;<?php echo $prow['couponCode']?></font><br/><?php echo DISCOUNT_TEXT1;?> <?php echo $currencySymbol;?> &nbsp;<?php echo number_format($couponCodeDiscountAmount,2,".","" ); ?>
		</div>
		<?php
		}
		?>
		
		<?php 
		if($prow['vgiftcertificate_code']!='' && $prow['nused_gift_amount']!=0 ){
		
		?>
		<div class="shipping_details_price_txt specialmessage">
			<?php echo GIFT_CERTIFICATE_AMT_TEXT;?> - <?php echo $currencySymbol;?>
			&nbsp;<?php echo number_format($prow['nused_gift_amount'],2,".","" ); ?>
		</div>
		
		<div class="shipping_details_price_txt specialmessage">
			<?php echo GIFT_CERTIFICATE_CODE_TEXT;?> 
			&nbsp;<?php echo $prow['vgiftcertificate_code']; ?>
		</div>
		<?php  } ?>
		
		<?php 
		if($prow["nused_gift_amount"]>0 || $prow['couponCodeDiscount']>0 ) {
		$giftDiscountAmount           = $prow["nused_gift_amount"];
																							   
		$couponCodeDiscountAmount = $prow["couponCodeDiscount"];
		
		$TotalDiscount   = $giftDiscountAmount + $couponCodeDiscountAmount;
		
		$priceafterdiscount=$cartTotal-$TotalDiscount;
		
		$cartTotal=number_format($priceafterdiscount,2,".","");
		
		?>    
		<div class="shipping_details_price_txt specialmessage">
			<?php echo PRODUCT_TOT_TEXT_DISCOUNT;?>
			<?php echo $currencySymbol;?>
			<?php echo number_format($cartTotal,2,".","" ); ?>
		</div>
		<?php } ?>
		
		<?php if(!empty($totalshippingcost))
		{
		?>					
		<div class="shipping_details_price_txt">
			<?php echo SHIP_TOT_TEXT;?>
			<?php echo $currencySymbol;?>
			<?php echo number_format($totalshippingcost,2,".","" ); ?>
		</div>
		
		<?php } // end if ?>
		
		<?php if(!empty($order_taxrate))
		{
		?>
		<div class="shipping_details_price_txt">
			<?php echo TAX_RATE_TEXT1;?> <?php echo $currencySymbol;?> <?php echo number_format($order_taxrate,2,".","" ); ?>
		</div>
		<?php } // end if ?>	
		
		
		
		
		<div class="shipping_details_price_txt">
			<?php echo ORDER_TOT_TEXT;?> <?php echo $currencySymbol;?> 
			&nbsp;<?php 
			//echo number_format($cartTotal+$totalshippingcost+$taxrate,2,".","" ); 
			echo number_format($order_total_amount+$order_taxrate,2,".","" ); 
			?>
		</div>
		
		
		<div class="shipping_details_price_txt">
			<b>
			<?php echo AMT_PAID_TEXT;?> 
			<?php echo $currencySymbol;?> 		
			<?php echo number_format($prow['namount_paid'],2,".","" ); ?>
			</b>
		</div>
		
		<div class="clearfix">&nbsp;</div>
				
				
		</div>
 


		<div class="full-width">
		<!--items display area start -->
		<div class="order_detailspg">
		 
	<div class="row">		
		<?php
		
		if($hide_shipping_display == 0)
		{
		
		?>
	
		<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
			<div class="view_order_address_outer">
				<h2><?php echo SHIP_ADDR_TEXT;?></h2>
				<div class="clearfix"></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo FIRST_NAME_TEXT;?></label></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo ($prow["shipping_first_name"]);?></div>
				<div class="clearfix"></div>
				
				<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo LAST_NAME_TEXT;?></label></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo ($prow["shipping_last_name"]);?></div>
				<div class="clearfix"></div>
				
				<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo ADDR1_TEXT;?></label></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo ($prow["shipping_address1"]);?></div>
				<div class="clearfix"></div>
				
				<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo ADDR2_TEXT;?></label></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo ($prow["shipping_address2"]);?></div>
				<div class="clearfix"></div>
				
				<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo CITY_TEXT;?></label></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo ($prow["shipping_city"]);?></div>
				<div class="clearfix"></div>
				
				<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo STATE_LABEL;?></label></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo getCodeValue($prow["shipping_state"],2,$prow["shipping_country"]);?></div>
				<div class="clearfix"></div>
				
				<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo COUNTRY_TEXT;?></label></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo getCodeValue($prow["shipping_country"],1);?></div>
				<div class="clearfix"></div>
				
				<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo ZIP_TEXT;?></label></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo htmlentities($prow["shipping_zip"]);?></div>
				<div class="clearfix"></div>
				
				<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo PHONE_TEXT;?></label></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo htmlentities($prow["shipping_phone"]);?></div>
				<div class="clearfix"></div>
				
				<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo FAX_TEXT;?></label></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo htmlentities($prow["shipping_fax"]);?></div>
				<div class="clearfix"></div>
				
				<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo EMAIL_LABEL;?></label></div>
				<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo htmlentities($prow["shipping_email"]);?></div>
			<div class="clearfix"></div>
			</div>
			<div class="clearfix"></div>
		</div>
		<?php

		}
		
		?>
		<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
			<div class="view_order_address_outer">
			<h2><?php echo BILL_ADDR_TEXT;?></h2>
			<div class="clearfix"></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo FIRST_NAME_TEXT;?></label></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo ($prow["billing_first_name"]);?></div>
			<div class="clearfix"></div>
			
			<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo LAST_NAME_TEXT;?></label></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo ($prow["billing_last_name"]);?></div>
			<div class="clearfix"></div>
			
			<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo ADDR1_TEXT;?></label></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo ($prow["billing_address1"]);?></div>
			<div class="clearfix"></div>
			
			<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo ADDR2_TEXT;?></label></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo ($prow["billing_address2"]);?></div>
			<div class="clearfix"></div>
			
			<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo CITY_TEXT;?></label></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo ($prow["billing_city"]);?></div>
			<div class="clearfix"></div>
			
			<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo STATE_LABEL;?></label></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo getCodeValue($prow["billing_state"],2,$prow["billing_country"]);?></div>
			<div class="clearfix"></div>
			
			<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo COUNTRY_TEXT;?></label></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo getCodeValue($prow["billing_country"],1);?></div>
			<div class="clearfix"></div>
			
			<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo ZIP_TEXT;?></label></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo htmlentities($prow["billing_zip"]);?></div>
			<div class="clearfix"></div>
			
			<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo PHONE_TEXT;?></label></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo htmlentities($prow["billing_phone"]);?></div>
			<div class="clearfix"></div>
			
			<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo FAX_TEXT;?></label></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo htmlentities($prow["billing_fax"]);?></div>
			<div class="clearfix"></div>
			
			<div class="col-xs-12 col-sm-6 view_order_address_outer_L"><label><?php echo EMAIL_LABEL;?></label></div>
			<div class="col-xs-12 col-sm-6 view_order_address_outer_R"><?php echo htmlentities($prow["billing_email"]);?></div>
			<div class="clearfix"></div>
		
		<div class="clearfix"></div>
		
		</div>	
		</div>

		<div class="clearfix">&nbsp;</div>
 
                <?php if($prow['buyer_comments']!='') { ?>


                <tr><td colspan="3">
                        
                        <div class="border_bgclr">
                            <table cellpadding="2" cellspacing="2" width="100%" class="responsive">
                                <tr><td><?php echo COMMENT_TEXT;?> </td>
                                    <td> <?php echo stripslashes($prow['buyer_comments']) ;?></td></tr>
                            </table>
                        </div>
                    </td></tr>

                <?php  } ?>
                
		<tr><td colspan="3" align="center"><input type="button"  value="<?php echo BACK_ORDERS_BUTTON;?>"  class="button"  onClick="window.location.href='orders.php'" >&nbsp;&nbsp;<input type="button" value="<?php echo ACCOUNT_BACK_BUTTON;?>" name="btnBack"  class="button" onClick="window.location.href='myaccount.php'">
		<?php if($rr_settings['enable_rma']=='Y' &&  (substr_count( getOrderStatus($orderid),"Delivered")>0) && $refund_id==0 && $giftid==''){ ?> <input type="button"  value="<?php echo REQUEST_REFUND_TEXT;?>"  class="button"  onClick="window.location.href='refund_request.php?orderid=<?php echo $orderid;?>'" ><?php }?>
		</td></tr>
		</table>
		<div class="clear"></div>
		
		</div>
		
<?php
}
else
{
?>			
		<br>
		
			<table cellpadding="0" cellspacing="0" border="0" width="100%" class="responsive">
				<tr>
					<td align="center" class="text_information"><?php echo NO_ORDER_TEXT;?></td>				
				</tr>
			</table>	
		
		
<?php

} // end of url checking

?>	
</div>

<div class="clearfix"></div>	
		
	
	
		<div align="left" class="float_clear1"></div>
					
					
		 <!--items display area end -->
		  </div>
		
  </form>
		<!--center content area end-->	

 
	</div>
</div>
<!--mainbody area end -->

		<div class="clear"></div>
				

<?php
include "includes/".$active_template[2];	/* Bottom File Name */
?>																		
