<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2011 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts PrintLogic                     |

// +----------------------------------------------------------------------+

// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |

// +----------------------------------------------------------------------+
App::uses('AppController', 'Controller');
App::uses('Sanitize', 'Utility');

class GiftcardDetailsController extends AppController

{

    var $name = "GiftcardDetail";

    //var $helpers = array('Html', 'Form','Pagination','Javascript');   

    var $helpers = array('Html', 'Form','Paginator','JS','Flash'); 

	var $components = array ('Pagination','Catmenu'); // Added

	var $uses = array('GiftcardDetail','Giftcard','Setting','Currency','User','Category','Cmspage','Dynamicpage'); 

    var $paginate = array('limit' => 25,'order' => array('GiftcardDetail.user_id' => 'desc'));

	

	function index(){

	    $sus		=	$this->Session->read('Userlog');

		global $currency;

		$curr		=	$this->Currency->findByCode($currency);		

		$this->set('curlogo',$curr["Currency"]["logo"]);

		$this->set('sus', $sus);

		$user_id	=	$sus["id"];		

		$data = $this->paginate('GiftcardDetail', array('GiftcardDetail.user_id '=>$user_id));

		$this->set('pagelimit', $this->paginate["limit"]);			

		$this->passedArgs['limit']=$this->paginate["limit"];

		$this->set('passedarg',$this->passedArgs);

		$this->set('data',$data);

	}

	

	

	 function beforeFilter()

    {

		/*if (isset($this->Setting) && !empty($this->Setting->table))  

        {  

             $this->Setting->load();  

        } */
        $this->loadModel('Setting');
        $this->Setting->load();
        
		global $sitefolder; 

		global $meta_description;

		global $meta_keywords;

		global $page_title;

		global $currency;

		$cnfg 				=	Configure::read('Neutrino');

		$sitefolder			=	$cnfg["sitebasefolder"];

		$currency			=	$cnfg["currency"];

		$meta_description	=	$cnfg["meta_description"];

		$meta_keywords		=	$cnfg["meta_keywords"];

		$page_title			=	$cnfg["page_title"];

		global $style; 

		$style				=	$cnfg["style"];

		$this->set('style', $style);

		$this->set('meta_description', $meta_description);

		$this->set('meta_keywords', $meta_keywords);

		$this->pageTitle = $page_title	; 

		$this->set('cnfg',$cnfg);

		$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.
		
		$this->set('sitefolder', $sitefolder);

		$httpHost	=	$_SERVER['HTTP_HOST'];

		$this->set('sitebase',FULL_BASE_URL);

    }

	function beforeRender()

    {

       	//Code for Category Menu Listing starts here..

		 $lst	=	$this->Category->find('all');			 

		 foreach($lst as $det)

		 $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);

		 $this->set('menu_array', $menu_array);			
		 $footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));	
		$this->set('footerlinks', $footer_links);	
		$pages =    $this->Dynamicpage->getpages();
		//echo "hello<pre>";print_r($pages);
		$this->set('pagesdynamic', $pages);

    }

	

	function __validateLoginStatus($typ='A')

    {

           if($typ == 'A'){

				if($this->Session->check('Admin') == false)

				{

					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 

					$this->Session->setFlash('The URL you\'ve followed requires you login.');

				}

			}else{

				if($this->Session->check('Userlog') == false)

				{

					$this->redirect(array('controller' => 'users', 'action' => 'login')); 

					$this->Session->setFlash('The URL you\'ve followed requires you login.');

				}

			}

    } 

	

}

?>