<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2011 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts PrintLogic                     |

// +----------------------------------------------------------------------+

// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |

// +----------------------------------------------------------------------+
App::uses('AppController', 'Controller');
App::uses('Sanitize', 'Utility');

class SettingsController extends AppController

{

    var $name = "Setting";

    //var $helpers = array('Html', 'Form','Pagination','Javascript','Ajax');   
    var $helpers = array('Html', 'Form','Paginator','Js','Flash');  

    var $components = array ('Pagination','Catmenu','History','Email','Resize'); // Added

	var $uses = array('Setting',  'Country','Currency','Category','Statecode'); 

    function indexm()
    {
       	$this->__validateLoginStatus(); 
	   	$admsess	=	$this->Session->read('Admin');
		if($admsess["settings"] <> 1){
			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}
		
		$data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value'))); 

		/*********************** Section to load css files name................................*/
		$theme_root=CSS;
		$csarr	=	array();
		$themes_dir = @ opendir($theme_root);
		$i	=	0;
		while ( ($theme_file = readdir($themes_dir)) !== false ) 
		{
			if($theme_file <> '.' && $theme_file <> '..' && $theme_file <> 'index.php'){
				$thm		=	explode('.css',$theme_file);
				$csarr[$i]	=	$thm[0];
				$i++;
			}
		}
		$this->set('csarr', $csarr);		

		/*********************** Section to load css files name................................*/

		if($_SERVER['REQUEST_METHOD']=='POST'){
			$set		=	$_POST;
			$flag		=	true;
			$msg		=	'';
			if($set['admin_email']==''){
				$msg = $msg." Site email can't be empty<br>";
				$flag	=	false;
			}else{

				if (!preg_match("/^[a-z0-9.%-]+@[a-z0-9.%-]+.[a-z]{2,4}$/", trim($set['admin_email']))){
				//if (!eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $set['admin_email'])){
					$msg 	= $msg." Invalid Site email<br>";
					$flag	=	false;
				}
			}

			if($flag==true){                           
				if(!empty($_FILES['site_logo']['tmp_name'])) {
					$ext	=	explode('.',$_FILES['site_logo']['name']);
					$error 	= 	$this->Setting->handleFileUpload($_FILES['site_logo'], 'SiteLogo.'.$ext[1]);  
                                        if($error!=NULL){
                                            $msg=$error;
                                            $this->Session->setFlash($msg, 'default',array('class'=> 'failure'));
                                            $msg='';
                                            $data	=	$set;
                                            $this->redirect(array('controller' => 'settings', 'action' => 'indexm'));
                                            $this->set('data', $data);		
                                            $this->layout = 'adm';                                           
                                            //exit;
                                        }                                       
                                        
                                        
				}
				
				//----------------------------- upload banner-----------------//
				$root_directory = WWW_ROOT.IMAGES_URL;
				if(is_uploaded_file($_FILES['offer_banner']['tmp_name'])){

					$ext_offer_banner = pathinfo($_FILES['offer_banner']['name']);
						
			if($ext_offer_banner['extension']=="png" || $ext_offer_banner['extension']=="gif" ||$ext_offer_banner['extension']=="jpg")
			{
				if(move_uploaded_file($_FILES['offer_banner']['tmp_name'], $root_directory."/".$_FILES['offer_banner']['name'])){						
						//-------------remove existing banner-----------------//
						if(file_exists($root_directory."/".$data["special_offer_banner"] && trim($data["special_offer_banner"]) <> '')){
							unlink($root_directory."/".$data["special_offer_banner"]);
						}
						$this->Resize->index($root_directory."/".$_FILES['offer_banner']['name']);
						$this->Resize->resizeImage(250, 132, 'exact');
						$this->Resize->saveImage($root_directory."/".$_FILES['offer_banner']['name'], 100);
						
						$this->Setting->update("special_offer_banner",$_FILES['offer_banner']['name']);						
					}
			}
			else {
				$error= "Invalid file format for offer banner !!";
				$msg=$error;
				$this->Session->setFlash($msg, 'default',array('class'=> 'failure'));
				$this->redirect(array('controller' => 'settings', 'action' => 'indexm'));
			   }	
					
				}

                                //
                                //----------------------------- upload site banner-----------------//
                                if(is_uploaded_file($_FILES['site_banner']['tmp_name'])){
                                	  	
                                	$ext_banner = pathinfo($_FILES['site_banner']['name']);

                                	
                                
                                	
                    if($ext_banner['extension']=="png" || $ext_banner['extension']=="gif" ||$ext_banner['extension']=="jpg")
                   {   	


					if(move_uploaded_file($_FILES['site_banner']['tmp_name'], $root_directory."/".$_FILES['site_banner']['name'])){
						//-------------remove existing banner-----------------//
						if(file_exists($root_directory."/".$data["site_banner"] && trim($data["site_banner"]) <> '')){
							unlink($root_directory."/".$data["site_banner"]);
						}
						$this->Resize->index($root_directory."/".$_FILES['site_banner']['name']);
						$this->Resize->resizeImage(1000, 534, 'exact');
						$this->Resize->saveImage($root_directory."/".$_FILES['site_banner']['name'], 100);

						$this->Setting->update("site_banner",$_FILES['site_banner']['name']);
					}
                  }
                  else { 
                  	$error= "Invalid file format for site banner !!";
                  	$msg=$error;
                  	$this->Session->setFlash($msg, 'default',array('class'=> 'failure'));
                  	$this->redirect(array('controller' => 'settings', 'action' => 'indexm'));
                  }
				}

				//$fax_status=$set['allow_fax'];		
				foreach($set as $fieldname => $value){
				     //if(($fieldname=='fax_email' || $fieldname=='fax_number') && $fax_status=='N') $value='';
					
                                    if($fieldname == 'google_analytics')
                                    {
                                         //$value = mysql_real_escape_string($value);
                                         $value = ($value);
                                    }
                                    $this->Setting->update($fieldname, $value);
				}
				$this->Session->setFlash('Settings Updated Successfully!', 'default',array('class'=> 'success'));
				$data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value'))); 
			}else{
				$this->Session->setFlash($msg, 'default',array('class'=> 'failure'));
				$msg='';
				$data	=	$set;
			}
			//echo "1";exit;
		header('Cache-Control: no-store, private, no-cache, must-revalidate');                  // HTTP/1.1
       		header('Cache-Control: pre-check=0, post-check=0, max-age=0, max-stale = 0', false);    // HTTP/1.1
       		header('Pragma: public');
        	header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');                                       // Date in the past  
     	 	header('Expires: 0', false); 
       		header('Last-Modified: '.gmdate('D, d M Y H:i:s') . ' GMT');
        	header('Pragma: no-cache');
			$this->redirect(array('controller' => 'settings', 'action' => 'indexm')); 
		}
		
		$this->set('data', $data);		
		$this->layout = 'adm'; 
               
    } 


	function ship_setting(){
		 $this->__validateLoginStatus(); 
		 $admsess	=	$this->Session->read('Admin');

		if($admsess["settings"] <> 1){

			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		 if($_SERVER['REQUEST_METHOD']=='POST'){
	
			$set		=	$_POST;

			$flag		=	true;

			$msg		=	'';

			if(!isset($set["shipping_require"])){

				$set["shipping_require"]	=	'N';

			}

			if(!isset($set["shipping_require_australia"])){

				$set["shipping_require_australia"]	=	'N';

			}

			if(!isset($set["shipping_require_canada"])){

				$set["shipping_require_canada"]	=	'N';

			}

			if(!isset($set["shipping_require_fedex"])){

				$set["shipping_require_fedex"]	=	'N';

			}

			if(!isset($set["shipping_require_usps"])){

				$set["shipping_require_usps"]	=	'N';

			}

			if(!isset($set["foflat_shipping_require"])){

				$set["foflat_shipping_require"]	=	'N';

			}

			if(!isset($set["tflat_shipping_require"])){

				$set["tflat_shipping_require"]	=	'N';

			}

			if(!isset($set["sflat_shipping_require"])){

				$set["sflat_shipping_require"]	=	'N';

			}

			if(!isset($set["fflat_shipping_require"])){

				$set["fflat_shipping_require"]	=	'N';

			}
			if(!isset($set["rush_hr_shipping_require"])){

				$set["rush_hr_shipping_require"]	=	'N';

			}
			
			$set["shipping_origin_country"]	=	$set["data"]["shipping_origin_country"];
			if($set["data"]["shipping_origin_country"]=='US')			
			$set["shipping_origin_state"]	=	$set["shipping_origin_state"];
			else
			$set["shipping_origin_state"]	=	$set["origin_state"];
	
			unset($set["data"]);

			if($set['shipping_origin_country']==''){

				$msg = $msg." Shipping Origin Country can't be empty";

				$flag	=	false;

			}

			if($set['shipping_origin_zip']==''){

				$msg = $msg." Shipping Origin Postalcode can't be empty";

				$flag	=	false;

			}

			if($flag==true){

				foreach($set as $fieldname => $value){

					$this->Setting->update($fieldname,$value);

				}

				$this->Session->setFlash('Shipping Settings Updated Successfully!', 'default',array('class'=> 'success'));

			}else{

				$this->Session->setFlash($msg, 'default',array('class'=> 'failure'));

				$msg='';

			}

			
			$this->redirect(array('controller' => 'Settings', 'action' => 'ship_setting')); 
		    exit;
		}

		//$this->redirect(array('controller' => 'settings', 'action' => 'indexm/ship')); 
		//exit;		
		$countrylist	=	$this->Country->find('list',array('fields'=>array('Country.country_iso_code_2','Country.country_name'))); 
		$currencylist	=	$this->Currency->find('list',array('fields'=>array('Currency.code','Currency.name'))); 
		$this->set('countrylist', $countrylist);		
		 //Setting the US States dtails
		$us_cntrydet = $this->Country->find('first', array("conditions"=>array("country_iso_code_2"=>'US')));	
		if(isset($us_cntrydet["Country"]["country_id"]))
		{
		/* $us_states	=	$this->Statecode->findAll("Statecode.country_id ='".$us_cntrydet["Country"]["country_id"]."'");	*/	
		 $us_states	=	$this->Statecode->find("all",array("conditions"=>array("Statecode.country_id"=>$us_cntrydet["Country"]["country_id"])));	
		 $this->set('us_states', $us_states);	
		} 		
		$data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value'))); 
		$this->set('data', $data);
		$curr			=	$this->Currency->findByCode($data["currency"] );
		$this->set('pcurr', $curr["Currency"]);		
		$this->layout = 'adm'; 
	}

	function pay_setting(){
  
		 $this->__validateLoginStatus(); 

		 $admsess	=	$this->Session->read('Admin');

		if($admsess["settings"] <> 1){

			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

 if($_SERVER['REQUEST_METHOD']=='POST'){
		$set		=	$_POST;

		
		if(isset($set["paypal_testmode"])){
		$set["paypal_testmode"]='Y'; }
		else {
		$set["paypal_testmode"]='N'; }		
		if(isset($set["authorize_testmode"])){
		$set["authorize_testmode"]='Y'; }
		else {
		$set["authorize_testmode"]='N'; }
                if(isset($set["payfast_testmode"])){
		$set["payfast_testmode"]='Y'; }
		else {
		$set["payfast_testmode"]='N'; }
		if(isset($set["google_testmode"])){
		$set["google_testmode"]='Y'; }
		else {
		$set["google_testmode"]='N'; }
		if(isset($set["stripe_testmode"])){
		$set["stripe_testmode"]='Y'; }
		else {
		$set["stripe_testmode"]='N'; }

		$flag		=	true;

		$pay_check	=	false;
                $payfast_check	=	false;
                $google_check	=	false;
		$auth_check	=	false;

		$your_check	=	false;

		$world_check=	false;
		$blue_check=	false;

		$goog_check	=	false;

		$msg		=	'';

		$popt	=	array();

		$i	=	0;

		if(isset($set["pay_paypal"])){

			$popt[$i]	=	$_POST["pay_paypal"];

			$pay_check	=	true;

			$i++;

			unset($set["pay_paypal"]);

		}
        if(isset($set["pay_payfast"])){
			$popt[$i]	=	$_POST["pay_payfast"];

			$payfast_check	=	true;
			$i++;
			unset($set["pay_payfast"]);
		}
		if(isset($set["pay_stripe"])){
			$popt[$i]	=	$_POST["pay_stripe"];

			$pay_stripe_check	=	true;
			$i++;
			unset($set["pay_stripe"]);
		}

		if(isset($set["ccard"])){

			if($set["ccard"] == "yourpay"){

				$popt[$i]	=	$set["ccard"];

				$your_check	=	true;

				$i++;

				unset($set["ccard"]);

			}elseif($set["ccard"] == "authorize"){

				$popt[$i]	=	$set["ccard"];

				$auth_check	=	true;

				$i++;

				unset($set["ccard"]);

			}elseif($set["ccard"] == "bluepay"){

				$popt[$i]	=	$set["ccard"];

				$blue_check	=	true;

				$i++;

				unset($set["ccard"]);

			}elseif($set["ccard"] == "worldpay"){

				$popt[$i]		=	$set["ccard"];

				$world_check	=	true;

				$i++;

				unset($set["ccard"]);

			}else{

				unset($set["ccard"]);

			}

		}

		if(isset($set["pay_google"])){

			$popt[$i]	=	$_POST["pay_google"];

			$goog_check	=	true;

			$i++;

			unset($set["pay_google"]);

		}

		

		//for offline credit payment

		if(isset($set["offline_creditpay"]))

		{

		  $set["offline_creditpay"]='Y';

		  $popt[$i]	=	$_POST["offline_creditpay"];

		  $i++; }

		else {

		$set["offline_creditpay"]='N';	 }				

		$this->Setting->updateofflinecredit($set["offline_creditpay"]);

		//for offline credit payment

		

		

		if(!empty($popt)){

			$set["payment_method"]	=	implode("-*-",$popt);

		}else{

			$msg 	= " Select atleast one payment method<br>";

			$flag	=	false;

		}
//echo "<Pre>";print_r($set);exit;

					

		$set["currency"]				=	$set["data"]["currency"];
		$set["tiered_price"]			=	$set["tiered_price"];
		unset($set["data"]);

		if($pay_check == true){

			if($set['paypal_pro_username']==''){

				$msg .= " Paypal Pro Username can't be empty<br>";

				$flag	=	false;

			}

			if($set['paypal_pro_password']==''){

				$msg = $msg." Paypal Pro Password can't be empty<br>";

				$flag	=	false;

			}
			if($set['paypal_pro_signature']==''){

				$msg = $msg." Paypal Pro Signature can't be empty<br>";

				$flag	=	false;

			}

			

		}

                if($payfast_check == true){
			if($set['merchant_id']==''){
				$msg .= " PayFast Merchant Id can't be empty<br>";
				$flag	=	false;
			}
			if($set['merchant_key']==''){
				$msg = $msg." PayFast Merchant Key can't be empty";
				$flag	=	false;
			}

		}
		if($auth_check == true){

			if($set['authorize_email']==''){

				$msg =" Authorize.Net email can't be empty <br>";

				$flag	=	false;

			}else{

				if (!preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/", $set['authorize_email'])){

					$msg 	= $msg." Invalid Authorize.Net email<br>";

					$flag	=	false;

				

				}

			}

			if($set['authorize_loginid']==''){

				$msg = $msg." Authorize.Net Login Id can't be empty<br>";

				$flag	=	false;

			}

			if($set['authorize_transactionkey']==''){

				$msg = $msg." Authorize.Net Transaction Key can't be empty<br>";

				$flag	=	false;

			}

			

			/*if($set['authorize_password']==''){

				$msg = $msg." Authorize.Net Password can't be empty<br>";

				$flag	=	false;

			}*/

			

		}

		if($goog_check	==	true){

			if($set['google_merchantId']==''){

				$msg = $msg." Google Merchant Id can't be empty<br>";

				$flag	=	false;

			}

			if($set['google_merchantkey']==''){

				$msg = $msg." Google Merchant Key can't be empty<br>";

				$flag	=	false;

			}

		}

		if($world_check	==	true){

			if($set['worldpay_inst_Id']==''){

				$msg = $msg." WorldPay Installation Id can't be empty<br>";

				$flag	=	false;

			}

			if($set['worldpay_email']==''){

				$msg = $msg."WorldPay Email can't be empty<br>";

				$flag	=	false;

			}else{

				if (!preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/", $set['worldpay_email'])){

					$msg 	= $msg." Invalid WorldPay email<br>";

					$flag	=	false;

				

				}

			}

		}

		if($your_check	==	true){

			if($set['yourpay_storeid']==''){

				$msg = $msg." YourPay Store Id can't be empty<br>";

				$flag	=	false;

			}
                        if(!isset ($_FILES["txtYourPayCertificate"]["name"])){
                                $msg = $msg." Upload a valid YourPay certificate<br>";

				$flag	=	false;
                        }else{
                                $set['yourpay_certificate_file'] = $_FILES["txtYourPayCertificate"]["name"];
                                $this->Setting->handleFileUpload($_FILES["txtYourPayCertificate"],$_FILES["txtYourPayCertificate"]["name"],'permiss');
                        }

		}

		if($flag==true){

			foreach($set as $fieldname => $value){

				$this->Setting->update($fieldname,$value);

			}

			$this->Session->setFlash('Payment Settings Updated Successfully!', 'default',array('class'=> 'success'));
    header('Cache-Control: no-store, private, no-cache, must-revalidate');                  // HTTP/1.1
       		header('Cache-Control: pre-check=0, post-check=0, max-age=0, max-stale = 0', false);    // HTTP/1.1
       		header('Pragma: public');
        	header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');                                       // Date in the past  
     	 	header('Expires: 0', false); 
       		header('Last-Modified: '.gmdate('D, d M Y H:i:s') . ' GMT');
        	header('Pragma: no-cache');
			$this->redirect(array('controller' => 'Settings', 'action' => 'pay_setting')); 
		}else{

			$this->Session->setFlash($msg, 'default',array('class'=> 'failure'));

			$msg='';

		}
      }
		//$this->redirect(array('controller' => 'settings', 'action' => 'indexm/pay')); 

		//exit;
		$data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value'))); 
		$data["pay_check"]	=	"N";
                $data["payfast_check"]	=	"N";
		$data["pay_google"]	=	"N";
		$data['ccard']		=	'';
		if(isset($data["payment_method"])){
			$pck	=	explode("-*-",$data["payment_method"]);
			foreach($pck as $pk){
				if($pk == "paypal"){
					$data["pay_check"]	=	"Y";
				}elseif($pk == "authorize"){
					$data['ccard']		=	'authorize';
				}elseif($pk == "yourpay"){
					$data['ccard']		=	'yourpay';
				}elseif($pk == "bluepay"){
					$data['ccard']		=	'bluepay';
				}elseif($pk == "worldpay"){
					$data['ccard']		=	'worldpay';
				}elseif($pk == "googlechk"){
					$data["pay_google"]	=	"Y";
				}elseif($pk == "payfast"){
					$data["payfast_check"]	=	"Y";
				}
				elseif($pk == "stripe"){
					$data["pay_stripe_check"]	=	"Y";
				}
			}
			
		}		
	    
		$this->set('data', $data);
		$currencylist	=	$this->Currency->find('list',array('fields'=>array('Currency.code','Currency.name'))); 
		$this->set('currencylist', $currencylist);		
		$this->layout = 'adm'; 
	}

    function beforeFilter()
    {
		/*if (isset($this->Setting) && !empty($this->Setting->table))  
        {  
             $this->Setting->load();  
        } */
        $this->loadModel('Setting');
        $this->Setting->load();
		global $sitefolder; 
		global $meta_description;
		global $meta_keywords;
		global $page_title;
		$cnfg 				=	Configure::read('Neutrino');
		$sitefolder			=	$cnfg["sitebasefolder"];
		$meta_description	=	$cnfg["meta_description"];
		$meta_keywords		=	$cnfg["meta_keywords"];
		$page_title			=	$cnfg["page_title"];
		global $style; 
		$style				=	$cnfg["style"];
		$this->set('style', $style);
		$this->set('meta_description', $meta_description);
		$this->set('meta_keywords', $meta_keywords);
		$this->pageTitle = $page_title	; 
		$this->set('cnfg',$cnfg);		
		$this->set('sitefolder', $sitefolder);
		$httpHost	=	$_SERVER['HTTP_HOST'];
		$this->set('sitebase',FULL_BASE_URL);
    }

	function beforeRender()
	{
		 $lst	=	$this->Category->find('all');		
		  if(empty($lst)===false)
		 { 
			 foreach($lst as $det)
			 $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
			 $this->set('menu_array', $menu_array);		
		}	 
	}

    function __validateLoginStatus($typ='A')
    {
           if($typ == 'A'){
				if($this->Session->check('Admin') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 
				}
		}else{
				if($this->Session->check('Userlog') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'users', 'action' => 'login')); 
				}
			}
    } 

	#################################### Function to show template preview...............................
	function tempreviu($name){
		$this->set("name",$name);
		$this->layout = 'ajax'; 		
	}
	
	function clipart(){
		$this->__validateLoginStatus(); 
	   	$admsess	=	$this->Session->read('Admin');
		if($admsess["cliparts"] <> 1){
			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}
		if(isset($_POST['saveBtn'])){
			extract($_POST);
			
			$data['Setting']['fieldname'] = 'userclipart';
			$data['Setting']['value'] = $user_setting[0];
			$this->Setting->update($data['Setting']['fieldname'],$data['Setting']['value']);
			$this->Setting->update('first_image',floatval($first_image));
			$this->Setting->update('first_text',floatval($first_text));
			$this->Setting->update('addn_image',floatval($addn_image));
			$this->Setting->update('addn_text',floatval($addn_text));
			$this->Session->setFlash('Settings Updated Successfully!', 'default',array('class'=> 'success'));
		}
		
		$userSetting = $this->Setting->findByFieldname('userclipart');
		$first_imagecost = $this->Setting->findByFieldname('first_image');
		$addn_imagecost = $this->Setting->findByFieldname('addn_image');
		$first_textcost = $this->Setting->findByFieldname('first_text');
		$addn_textcost = $this->Setting->findByFieldname('addn_text');
		
		$data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value'))); 
		$curr			=	$this->Currency->findByCode($data["currency"] );
		$this->set('pcurr', $curr["Currency"]);		
		
		$this->set("userSetting",$userSetting['Setting']['value']);
		$this->set("first_imagecost",$first_imagecost['Setting']['value']);
		$this->set("addn_imagecost",$addn_imagecost['Setting']['value']);
		$this->set("first_textcost",$first_textcost['Setting']['value']);
		$this->set("addn_textcost",$addn_textcost['Setting']['value']);
		$this->layout = 'adm'; 
	}

	function __readDirectory($dest){		
		$image_file_path = WWW_ROOT.IMAGES_URL.'editorimages/'.$dest.'/'; 
		$fileArray[0] = $image_file_path;
		$allowedTypes = array("jpg","png","gif");
		$images = array();

		foreach($fileArray as $fileDir){
			$file_handle = dir($fileDir) or die("Wrong path: $fileDir");
			while (false !== ($entry = $file_handle->read())) {
				if($entry != '.' && $entry != '..' && !is_dir($fileDir.$entry)){
					$filetype = explode(".",$entry);
					$ext = strtolower(end($filetype));
					if(in_array($ext,$allowedTypes)){
						//------------show only images with size 50x50-------------------//
						list($width, $height) = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$dest.'/'.$entry);
						if($width == 50 && $height == 50) $images[] = 'editorimages/'.$dest.'/'.$entry;
					}
				}
			}	
		}
		$file_handle->close();
		
		//print_r($images);
		return $images;
	}
	
	function customupload($dest,$flag){
		$udirectory = WWW_ROOT.IMAGES_URL."editorimages/".$dest;
		
		// upload the file
		list($width,$height) = getimagesize($this->data['Setting']['img_field']['tmp_name']); 
		$fileName = time().$this->data['Setting']['img_field']['name']; 

                if($width < 100 || $height < 100)
                {
                    
                    echo "ERROR:Upload image dimensions should be greater than or equal to 100x100";
                    exit;
                }
                
                // create a random png filename
                $pngName = time().'_ADMIN_IMG_'.rand(0, 9999).'.png';
		if(is_uploaded_file($this->data['Setting']['img_field']['tmp_name'])){
			
			if($flag)
			{
				 
                    system("convert ".$this->data['Setting']['img_field']['tmp_name']." -filter point -fuzz 10% -transparent white ".$udirectory."/".$pngName);
                    system("convert ".$this->data['Setting']['img_field']['tmp_name']."   -filter point -fuzz 10% -transparent white   ".$udirectory."/tmb_".$pngName);
			}
			else
			{
				system("convert ".$this->data['Setting']['img_field']['tmp_name']." ".$udirectory."/".$pngName);
				system("convert ".$this->data['Setting']['img_field']['tmp_name']." ".$udirectory."/tmb_".$pngName);
					
			}
                        
			system("convert ".$udirectory."/tmb_".$pngName." -resize 100x100! ".$udirectory."/1024_tmb_".$pngName);
			system("convert ".$udirectory."/tmb_".$pngName." -resize 50x50! ".$udirectory."/tmb_".$pngName);
            echo $filerootDir."/default/".$pngName;
		}
		
		//----------ajax--------------//
		Configure::write('debug', 0); 
		$this->autoRender = false;
		exit;
	}
	
	function clipartajax($dest){
		$images = $this->__readDirectory($dest);
		$this->set("images",$images);
		$this->layout = 'ajax'; 
	}
	
	function delImages($dest){
		extract($_POST);
		$flag = true;
		foreach($del_image as $val){
			if(file_exists(WWW_ROOT.IMAGES_URL."editorimages/".$dest."/".$val)){
				chmod(WWW_ROOT.IMAGES_URL."editorimages/".$dest."/".$val, 0777);
				unlink(WWW_ROOT.IMAGES_URL."editorimages/".$dest."/".$val);
			}
			else $flag = false;
		}
		if($flag) echo "Success";
		else echo "Error";
		//----------ajax--------------//
		Configure::write('debug', 0); 
		$this->autoRender = false;
		exit;
	}
	
	function category(){
		$this->__validateLoginStatus(); 
	   	$admsess	=	$this->Session->read('Admin');
		if($admsess["cliparts"] <> 1){
			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}
		$images = $this->__readCategory();
		$this->set("images",$images);
		$this->layout = 'adm'; 
	}
	
	function __readCategory(){
		$fileDir = WWW_ROOT.IMAGES_URL.'editorimages/'; 

		$file_handle = dir($fileDir) or die("Wrong path: $fileDir");
		while (false !== ($entry = $file_handle->read())) {
			if($entry != '.' && $entry != '..' && is_dir($fileDir.$entry) && $entry <> 'customized' && $entry <> 'editorimages'){
				$images[] = $entry;
			}
		}	
		$file_handle->close();
		
		//print_r($images);
		return $images;
	}
	
	function addcategory(){
		extract($_POST);
		$dir = mkdir(WWW_ROOT.IMAGES_URL.'editorimages/'.$catname,0777);
		
		if($dir) echo 1;
		else echo 0;
		//----------ajax--------------//
		Configure::write('debug', 0); 
		$this->autoRender = false;
		exit;
	}
	
	function categoryajax(){
		$images = $this->__readCategory();
		$this->set("images",$images);
		$this->layout = 'ajax'; 
	}
	
	function delcat(){
		extract($_POST);
		$flag = true;
		foreach($del_image as $val){
			if(is_dir(WWW_ROOT.IMAGES_URL."editorimages/".$val)){
				chmod(WWW_ROOT.IMAGES_URL."editorimages/".$val, 0777);
				 $file_handle = dir(WWW_ROOT.IMAGES_URL."editorimages/".$val);
				 while (false !== ($object = $file_handle->read())) {
				   if ($object != "." && $object != "..") {
					 unlink(WWW_ROOT.IMAGES_URL."editorimages/".$val."/".$object);
				   }
				 }
				rmdir(WWW_ROOT.IMAGES_URL."editorimages/".$val);
			}
			else $flag = false;
		}
		if($flag) echo "Success";
		else echo "Error";
		//----------ajax--------------//
		Configure::write('debug', 0); 
		$this->autoRender = false;
		exit;
	}
	
	function clipartimages($dest='default'){
		$this->__validateLoginStatus(); 
	   	$admsess	=	$this->Session->read('Admin');
		if($admsess["cliparts"] <> 1){
			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}
		$images = $this->__readDirectory($dest);

		
				
		$this->set("images",$images);
		$this->set("dest",$dest);
		$this->layout = 'adm'; 
	}
function checkautotrace()
                {
                   $this->layout = null; 
                  // echo "here"; exit;
                   system('autotrace -v'); exit;
                    
                }
}

?>