<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
App::uses('Component', 'Controller');
class SalesgraphComponent extends Component {
	var $uses = array('Order'); 
	
	function ploteSalesGraph($dataArray){
//========Total Sales Graph
		 $month_arr=array(
			"01"=> "Jan" ,
			"02"=> "Feb" ,
			"03"=> "Mar" ,
			"04"=> "Apr" ,
			"05"=> "May" ,
			"06"=> "Jun" ,
			"07"=> "Jul" ,
			"08"=> "Aug" ,
			"09"=> "Sep" ,
			"10"=> "Oct" ,
			"11"=> "Nov" ,
			"12"=> "Dec"
		); 

		$sales_graph_arr=array();
		list($m, $y) = explode('-', date('m-Y'));
		for ($i = -12; $i <= 0; $i++) {
		  $ts = mktime(0,0,0,$m+$i,1,$y);
		  $m1  = date('m', $ts);
		  $y1  = date('Y', $ts);
		  $sales_graph_arr[$m1."-".$y1] = 0;
		}

		

$res_sales_graph= $dataArray;
$totrow_sales_graph=count($dataArray);
if ( $totrow_sales_graph > 0 ) {
  foreach ($res_sales_graph as $key =>$value) {
     $arr_key = $value[0]['MONTH']."-".$value[0]['year'] ;
	 $sales_graph_arr[$arr_key] = $value[0]['total_amount'] ;
  }
}
//========Total Sales graph ends

$img_width=300;
$img_height=200;		
$margins=40;
//Find the size of graph by substracting the size of borders
$graph_width=$img_width - $margins * 2;
$graph_height=$img_height - $margins * 2; 
$img=imagecreate($img_width,$img_height);
$bar_width=20;
$total_bars=count($sales_graph_arr);
$gap= ($graph_width- $total_bars * $bar_width ) / ($total_bars +1);

//Define Colors ----------------
$bar_color=imagecolorallocate($img,108,108,75);
$background_color=imagecolorallocate($img,225,225,229);
$border_color=imagecolorallocate($img,194,194,198);
$line_color=imagecolorallocate($img,231,231,234);
$text_color=imagecolorallocate($img,0,64,50);

//235,235,238


//Create the border around the graph
imagefilledrectangle($img,1,1,$img_width-2,$img_height-2,$border_color);
imagefilledrectangle($img,$margins,$margins,$img_width-1-$margins,$img_height-1-$margins,$background_color);
if ( $totrow_sales_graph > 0 ) {
//Max value is required to adjust the scale
$max_value=max($sales_graph_arr);
$ratio= $graph_height/$max_value;

//Create scale and draw horizontal lines
//	$horizontal_lines=20;
	$horizontal_lines=10;
	$horizontal_gap=$graph_height/$horizontal_lines;

	for($i=1;$i<=$horizontal_lines;$i++){
		$y=$img_height - $margins - $horizontal_gap * $i ;
		imageline($img,$margins,$y,$img_width-$margins,$y,$line_color);
		$v=intval($horizontal_gap * $i /$ratio);
		imagestring($img,0,5,$y-5,"$".$v,$text_color);

	}
 
//Draw the bars here
	for($i=0;$i< $total_bars; $i++){ 
		// Extract key and value pair from the current pointer position
		$str_key = array();
		list($key,$value)=each($sales_graph_arr); 
		$x1= $margins + $gap + $i * ($gap+$bar_width) ;
		$x2= $x1 + $bar_width; 
		$y1=$margins +$graph_height- intval($value * $ratio) ;
		$y2=$img_height-$margins;
		imagestring($img,0,$x1+3,$y1-10,"$".$value,$text_color);
		$str_key = explode("-",$key);
		$month_name = $month_arr[$str_key[0]];
		//echo $month_name."<br>";
		imagestring($img,0,$x1+3,$img_height-30,$month_name,$text_color);		
		imagestring($img,0,$x1+3,$img_height-20,$str_key[1],$text_color);
		imagefilledrectangle($img,$x1,$y1,$x2,$y2,$bar_color);
	}
} else {
   $default_text ="No Sales.";
   $df_x =$img_width/3;
   $df_y =$img_height/2;
   imagestring($img,3,$df_x,$df_y,$default_text,$bar_color);
}	
	//header("Content-type:image/png");
	imagepng($img,"files/Graph/sales.png")or die("Nop");
	
}	
}
?>