<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			 */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                    |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
App::uses('AppController', 'Controller');
App::uses('Sanitize', 'Utility');
class ContactsController extends AppController {

    var $name = "Contact";
    //var $helpers = array('Html', 'Form', 'Pagination', 'Javascript');
    var $helpers = array('Html', 'Form','Paginator','JS','Flash'); 
    var $components = array('Pagination', 'Catmenu');
    var $uses = array('Contact', 'Cart', 'Category', 'Cmspage','Dynamicpage');
    var $paginate = array('limit' => 25, 'order' => array('Contact.cdate' => 'desc'));

    function beforeFilter() {

       /* if (isset($this->Setting) && !empty($this->Setting->table)) {
            $this->Setting->load();
        }*/
        $this->loadModel('Setting');
        $this->Setting->load();
        global $sitefolder;

        global $meta_description;

        global $meta_keywords;

        global $page_title;

        $cnfg = Configure::read('Neutrino');

        $sitefolder = $cnfg["sitebasefolder"];

        $meta_description = $cnfg["meta_description"];

        $meta_keywords = $cnfg["meta_keywords"];
        
        $page_title = $cnfg["page_title"];

        global $style;
        
        $style = $cnfg["style"];

        $this->set('style', $style);

        $this->set('meta_description', $meta_description);

        $this->set('meta_keywords', $meta_keywords);

        $this->pageTitle = $page_title;

        $this->set('cnfg', $cnfg);

        $this->paginate["limit"] = $cnfg["items_perpage"]; //Setting pagination limit per page.

        $this->set('sitefolder', $sitefolder);

        $httpHost = $_SERVER['HTTP_HOST'];

        $this->set('sitebase', FULL_BASE_URL);
    }

    function beforeRender() {

        $lst = $this->Category->find('all',array('order' => array('position' => 'ASC')));

        if (empty($lst) === false) {

            foreach ($lst as $det)
                $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"], 'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);

            $this->set('menu_array', $menu_array);
        }
        $sus = $this->Session->read('Userlog');
        $this->set('sus', $sus);
        $pages =    $this->Dynamicpage->getpages();
        //echo "hello<pre>";print_r($pages);
        $this->set('pagesdynamic', $pages);
    }

    function index() {
        
        $this->__validateLoginStatus();

        $admsess = $this->Session->read('Admin');

        if ($admsess["feedback"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }

        $criteria = NULL;

        $cmbSearchType = "";

        $txtSearch = "";

        if (isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"]) && $_GET["txtSearch"] <> '') {

            $cmbSearchType = $_GET["cmbSearchType"];

            $txtSearch = trim($_GET["txtSearch"]);

            if ($cmbSearchType == "cname") {

                $data = $this->paginate('Contact', array('Contact.cname  LIKE ' => "%" . addslashes($txtSearch) . "%"));
            } elseif ($cmbSearchType == "cdescr") {

                $data = $this->paginate('Contact', array('Contact.cdescr  LIKE ' => "%" . addslashes($txtSearch) . "%"));
            } elseif ($cmbSearchType == "cemail") {

                $data = $this->paginate('Contact', array('Contact.cemail  LIKE ' => "%" . addslashes($txtSearch) . "%"));
            } elseif ($cmbSearchType == "cdate") {

                $dt = '0000-00-00';

                if ($txtSearch != '' ) {
                	
                	if(strpos($txtSearch,"-")>0)
                	{
                		list ($month, $day, $year) = explode ("-", $txtSearch); //08-12-2010
                		if(strlen($day)==1) $day = '0'.$day;
                		if(strlen($month)==1) $month = '0'.$month;
                		$dt = $year."-".$month."-".$day; //2010-08-13
                	}
                	
                	else if(strpos($txtSearch,"/")>0)
                	{
                		list ($month, $day, $year) = explode ("/", $txtSearch); //08-12-2010
                		if(strlen($day)==1) $day = '0'.$day;
                		if(strlen($month)==1) $month = '0'.$month;
                		$dt = $year."-".$month."-".$day; //2010-08-13
                	}
                   
                }

                $data = $this->paginate('Contact', array('Contact.cdate  LIKE ' => "%" . addslashes($dt) . "%"));
            }else {

                $data = $this->paginate('Contact');
            }
        } else if (isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) &&
                $this->passedArgs["txtSearch"] <> '') {

            $cmbSearchType = $this->passedArgs["cmbSearchType"];

            $txtSearch = $this->passedArgs["txtSearch"];

            if ($cmbSearchType == "cname") {

                $data = $this->paginate('Contact', array('Contact.cname  LIKE ' => "%" . addslashes($txtSearch) . "%"));
            } elseif ($cmbSearchType == "cdescr") {

                $data = $this->paginate('Contact', array('Contact.cdescr  LIKE ' => "%" . addslashes($txtSearch) . "%"));
            } elseif ($cmbSearchType == "cemail") {

                $data = $this->paginate('Contact', array('Contact.cemail  LIKE ' => "%" . addslashes($txtSearch) . "%"));
            } elseif ($cmbSearchType == "cdate") {

                $dt = '0000-00-00';

                if ($txtSearch != '' && strpos($txtSearch, "-") > 0) {

                    list ($month, $day, $year) = explode("-", $txtSearch); //08-12-2010

                    if (strlen($day) == 1)
                        $day = '0' . $day;

                    if (strlen($month) == 1)
                        $month = '0' . $month;

                    $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                }

                $data = $this->paginate('Contact', array('Contact.cdate  LIKE ' => "%" . addslashes($dt) . "%"));
            }else {

                $data = $this->paginate('Contact');
            }
        } else {

            $data = $this->paginate('Contact');
        }

        $this->set('cmbSearchType', $cmbSearchType);

        $this->set('txtSearch', $txtSearch);

        $this->passedArgs['limit'] = $this->paginate["limit"];

        $this->set('passedarg', $this->passedArgs);

        $this->set('feeds', $data);
        
        $this->layout = 'adm';
    }

    function __validateLoginStatus($typ = 'A') {
        if ($typ == 'A') {
            if ($this->Session->check('Admin') == false) {
                $this->Session->setFlash('The URL you have followed requires you login.', 'default', array('class' => 'failure'));
                $this->redirect(array('controller' => 'admins', 'action' => 'login'));
            }
        } else {
            if ($this->Session->check('Userlog') == false) {
                $this->Session->setFlash('The URL you have followed requires you login.', 'default', array('class' => 'failure'));
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
            }
        }
    }

    function add() {

      
        $lst = $this->Category->find('all');
        $sus    =   $this->Session->read('Userlog'); 
        if(isset($sus) && empty($sus)===false){     
          $this->set('sus', $sus);
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));  
        }  
        else {
          $this->set('sus', ''); 
          $sessid   =   $this->Session->id();
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid))); 
        }

      

        $this->set('cartcount', count($citem));

        foreach ($lst as $det)
            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"], 'parent' => $det["Category"]["parent_id"]);

        $this->set('menu_array', $menu_array);

        $footer_links = $this->Cmspage->find('list', array('conditions' => array('Cmspage.type' => 'content', 'Cmspage.status' => 'Y')));
        $this->set('footerlinks', $footer_links);


        //Code Added By shyam for Category Menu Listing ends here..
        ########### Section to store feedbacks............


        $this->data=$_POST['data'];
        $post_data = $this->data;
        

       if (!empty($this->data)) {
           
            $tm = date("Y-m-d");
            $post_data["Contact"]["cdate"] = $tm;


         if(!empty($sus)) {  

            if($this->data["Contact"]["cname"]=='')
            {
                $post_data["Contact"]["cname"]  = $sus['uname'];
            }

             if($this->data["Contact"]["cemail"]=='')
            {
                $post_data["Contact"]["cemail"]= $sus['email'];
            }

         }else{
            $emailsplituname                   = explode("@",$this->data["Contact"]["cemail"]);
            $usernamepart                      = $emailsplituname[0];
            $post_data['Contact']['cname']     = $usernamepart;
         }
         
            
            $post_data['Contact']['cdescr'] = strip_tags($this->data['Contact']['cdescr']);
            $this->data = $post_data;
            if ($this->Contact->save($this->data)) {
                $this->Session->setFlash('Your Feedback has been posted successfully.', 'default', array('class' => 'success'));
                $this->redirect(array('controller' => 'contacts', 'action' => 'add/'));
                exit;
            }
        }
        ########### Section to store feedbacks............
    }

    function edit($id = 0) {

        $this->__validateLoginStatus();
        $admsess = $this->Session->read('Admin');
        if ($admsess["feedback"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        if ($id == 0) {
            $this->redirect(array('controller' => 'contacts', 'action' => 'index'));
            exit();
        }

        $this->Contact->id = $id;        
        if (!empty($this->data)) {
            $post_data = $this->data;
            $post_data['Contact']['cdescr'] = strip_tags($this->data['Contact']['cdescr']);    
            $fdate = explode('-', $post_data["Contact"]["cdate"]);
            if (isset($fdate[0]))
                $post_data["Contact"]["cdate"] = $fdate[2] . '-' . $fdate[0] . '-' . $fdate[1];
            $this->data = $post_data;
           // $this->Contact->saveField('cname', $this->data["Contact"]["cname"]);
            $this->Contact->saveField('cemail', $this->data["Contact"]["cemail"]);
            $this->Contact->saveField('cdate', $this->data["Contact"]["cdate"]);
            $this->Contact->saveField('cdescr', $this->data["Contact"]["cdescr"]);
            $this->Session->setFlash('Feedback has been edited Successfully.', 'default', array('class' => 'success'));
            $this->redirect(array('controller' => 'contacts', 'action' => 'index'));
        }
        $this->data = $this->Contact->read();
        $this->set('feedback', $this->data);
        $this->layout = 'adm';
    }

    function delete($id) {



        $this->__validateLoginStatus();



        $admsess = $this->Session->read('Admin');



        if ($admsess["feedback"] <> 1) {



            $this->redirect(array('controller' => 'admins', 'action' => 'index'));



            exit();
        }



        $this->Contact->delete($id);



        $this->Session->setFlash('Feedback Removed from Database.', 'default', array('class' => 'success'));



        $this->redirect('index');
    }

    function contactus() {

        $sus = $this->Session->read('Userlog');

        $this->set('sus', $sus);

        $dat["user_id"] = 0;

        if (!empty($sus) === true) {

            $dat["user_id"] = $sus["id"];
        }
    }

}

?>